/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Pack
implements Serializable {
    static final long serialVersionUID = -5458360562175088671L;
    public boolean loose;
    public String name;
    public String id;
    public Set installGroups = new HashSet();
    public String group;
    public String description;
    public List osConstraints = null;
    public List dependencies = null;
    public List revDependencies = null;
    public boolean required;
    public long nbytes;
    public boolean preselected;
    public int color;
    public static final int WHITE = 0;
    public static final int GREY = 1;
    public static final int BLACK = 2;
    private static final double KILOBYTES = 1024.0;
    private static final double MEGABYTES = 1048576.0;
    private static final double GIGABYTES = 1.073741824E9;
    private static final DecimalFormat formatter = new DecimalFormat("#,###.##");

    public Pack(String name, String id, String description, List osConstraints, List dependencies, boolean required, boolean preselected, boolean loose) {
        this.name = name;
        this.id = id;
        this.description = description;
        this.osConstraints = osConstraints;
        this.dependencies = dependencies;
        this.required = required;
        this.preselected = preselected;
        this.loose = loose;
        this.nbytes = 0L;
        this.color = 0;
    }

    public String toString() {
        return this.name + " (" + this.description + ")";
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void addRevDep(String name) {
        if (this.revDependencies == null) {
            this.revDependencies = new ArrayList();
        }
        this.revDependencies.add(name);
    }

    public String depString() {
        String name;
        String text = "";
        if (this.dependencies == null) {
            return text;
        }
        for (int i = 0; i < this.dependencies.size() - 1; ++i) {
            name = (String)this.dependencies.get(i);
            text = text + name + ",";
        }
        name = (String)this.dependencies.get(this.dependencies.size() - 1);
        text = text + name;
        return text;
    }

    public static String toByteUnitsString(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(bytes) + " bytes";
        }
        if ((double)bytes < 1048576.0) {
            double value = (double)bytes / 1024.0;
            return formatter.format(value) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            double value = (double)bytes / 1048576.0;
            return formatter.format(value) + " MB";
        }
        double value = (double)bytes / 1.073741824E9;
        return formatter.format(value) + " GB";
    }
}

