/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionDescriptor;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;

public class SectionTable {
    private static final int SED_SIZE = 12;
    protected ArrayList _sections = new ArrayList();
    protected List _text;

    public SectionTable() {
    }

    public SectionTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin, List tpt) {
        PlexOfCps sedPlex = new PlexOfCps(tableStream, offset, size, 12);
        this._text = tpt;
        int length = sedPlex.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = sedPlex.getProperty(x);
            SectionDescriptor sed = new SectionDescriptor(node.getBytes(), 0);
            int fileOffset = sed.getFc();
            if (fileOffset == -1) {
                this._sections.add(new SEPX(sed, this.CPtoFC(node.getStart()), this.CPtoFC(node.getEnd()), new byte[0]));
                continue;
            }
            short sepxSize = LittleEndian.getShort(documentStream, fileOffset);
            byte[] buf = new byte[sepxSize];
            System.arraycopy(documentStream, fileOffset += 2, buf, 0, buf.length);
            this._sections.add(new SEPX(sed, this.CPtoFC(node.getStart()), this.CPtoFC(node.getEnd()), buf));
        }
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._sections.size();
        SEPX sepx = (SEPX)this._sections.get(listIndex);
        sepx.setEnd(sepx.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            sepx = (SEPX)this._sections.get(x);
            sepx.setStart(sepx.getStart() + length);
            sepx.setEnd(sepx.getEnd() + length);
        }
    }

    private int CPtoFC(int CP) {
        TextPiece TP = null;
        for (int i = this._text.size() - 1; i > -1 && CP < (TP = (TextPiece)this._text.get(i)).getCP(); --i) {
        }
        int FC = TP.getPieceDescriptor().getFilePosition();
        int offset = CP - TP.getCP();
        if (TP.usesUnicode()) {
            offset *= 2;
        }
        FC = FC + offset - ((TextPiece)this._text.get(0)).getPieceDescriptor().getFilePosition();
        return FC;
    }

    private int FCtoCP(int fc) {
        int size = this._text.size();
        int cp = 0;
        for (int x = 0; x < size; ++x) {
            TextPiece piece = (TextPiece)this._text.get(x);
            if (fc <= piece.getEnd()) {
                cp += (fc - piece.getStart()) / (piece.usesUnicode() ? 2 : 1);
                break;
            }
            cp += (piece.getEnd() - piece.getStart()) / (piece.usesUnicode() ? 2 : 1);
        }
        return cp;
    }

    public ArrayList getSections() {
        return this._sections;
    }

    public void writeTo(HWPFFileSystem sys, int fcMin) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        int offset = docStream.getOffset();
        int len = this._sections.size();
        PlexOfCps plex = new PlexOfCps(12);
        for (int x = 0; x < len; ++x) {
            SEPX sepx = (SEPX)this._sections.get(x);
            byte[] grpprl = sepx.getGrpprl();
            byte[] shortBuf = new byte[2];
            LittleEndian.putShort((byte[])shortBuf, (short)((short)grpprl.length));
            docStream.write(shortBuf);
            docStream.write(grpprl);
            SectionDescriptor sed = sepx.getSectionDescriptor();
            sed.setFc(offset);
            GenericPropertyNode property = new GenericPropertyNode(this.FCtoCP(sepx.getStart()), this.FCtoCP(sepx.getEnd()), sed.toByteArray());
            plex.addProperty(property);
            offset = docStream.getOffset();
        }
        tableStream.write(plex.toByteArray());
    }
}

