/*
 * Decompiled with CFR 0.152.
 */
package com.IR8278;

import com.IR8278.App;
import com.IR8278.ReportCreation;
import com.IR8278.Utility;
import com.IR8278.ValidationTests;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class EightHundredRelationshipsTab
extends ValidationTests {
    static List<String> control = new ArrayList<String>();
    static List<String> enhancement = new ArrayList<String>();
    static List<String> security = new ArrayList<String>();
    boolean hasAMatch = false;

    private static String[][] whatTextFile(int sheetNum) {
        String[][] res = new String[3][2];
        switch (sheetNum) {
            case 1: {
                res[0][0] = "resources/800-53ACControl.txt";
                res[0][1] = "/800-53ACControl.txt";
                res[1][0] = "resources/800-53ACEnhance.txt";
                res[1][1] = "/800-53ACEnhance.txt";
                res[2][0] = "resources/800-53ACSecurity.txt";
                res[2][1] = "/800-53ACSecurity.txt";
                break;
            }
            case 2: {
                res[0][0] = "resources/800-53ATControl.txt";
                res[0][1] = "/800-53ATControl.txt";
                res[1][0] = "resources/800-53ATEnhance.txt";
                res[1][1] = "/800-53ATEnhance.txt";
                res[2][0] = "resources/800-53ATSecurity.txt";
                res[2][1] = "/800-53ATSecurity.txt";
                break;
            }
            case 3: {
                res[0][0] = "resources/800-53AUControl.txt";
                res[0][1] = "/800-53AUControl.txt";
                res[1][0] = "resources/800-53AUEnhance.txt";
                res[1][1] = "/800-53AUEnhance.txt";
                res[2][0] = "resources/800-53AUSecurity.txt";
                res[2][1] = "/800-53AUSecurity.txt";
                break;
            }
            case 4: {
                res[0][0] = "resources/800-53CAControl.txt";
                res[0][1] = "/800-53CAControl.txt";
                res[1][0] = "resources/800-53CAEnhance.txt";
                res[1][1] = "/800-53CAEnhance.txt";
                res[2][0] = "resources/800-53CASecurity.txt";
                res[2][1] = "/800-53CASecurity.txt";
                break;
            }
            case 5: {
                res[0][0] = "resources/800-53CMControl.txt";
                res[0][1] = "/800-53CMControl.txt";
                res[1][0] = "resources/800-53CMEnhance.txt";
                res[1][1] = "/800-53CMEnhance.txt";
                res[2][0] = "resources/800-53CMSecurity.txt";
                res[2][1] = "/800-53CMSecurity.txt";
                break;
            }
            case 6: {
                res[0][0] = "resources/800-53CPControl.txt";
                res[0][1] = "/800-53CPControl.txt";
                res[1][0] = "resources/800-53CPEnhance.txt";
                res[1][1] = "/800-53CPEnhance.txt";
                res[2][0] = "resources/800-53CPSecurity.txt";
                res[2][1] = "/800-53CPSecurity.txt";
                break;
            }
            case 7: {
                res[0][0] = "resources/800-53IAControl.txt";
                res[0][1] = "/800-53IAControl.txt";
                res[1][0] = "resources/800-53IAEnhance.txt";
                res[1][1] = "/800-53IAEnhance.txt";
                res[2][0] = "resources/800-53IASecurity.txt";
                res[2][1] = "/800-53IASecurity.txt";
                break;
            }
            case 8: {
                res[0][0] = "resources/800-53IRControl.txt";
                res[0][1] = "/800-53IRControl.txt";
                res[1][0] = "resources/800-53IREnhance.txt";
                res[1][1] = "/800-53IREnhance.txt";
                res[2][0] = "resources/800-53IRSecurity.txt";
                res[2][1] = "/800-53IRSecurity.txt";
                break;
            }
            case 9: {
                res[0][0] = "resources/800-53MAControl.txt";
                res[0][1] = "/800-53MAControl.txt";
                res[1][0] = "resources/800-53MAEnhance.txt";
                res[1][1] = "/800-53MAEnhance.txt";
                res[2][0] = "resources/800-53MASecurity.txt";
                res[2][1] = "/800-53MASecurity.txt";
                break;
            }
            case 10: {
                res[0][0] = "resources/800-53MPControl.txt";
                res[0][1] = "/800-53MPControl.txt";
                res[1][0] = "resources/800-53MPEnhance.txt";
                res[1][1] = "/800-53MPEnhance.txt";
                res[2][0] = "resources/800-53MPSecurity.txt";
                res[2][1] = "/800-53MPSecurity.txt";
                break;
            }
            case 11: {
                res[0][0] = "resources/800-53PLControl.txt";
                res[0][1] = "/800-53PLControl.txt";
                res[1][0] = "resources/800-53PLEnhance.txt";
                res[1][1] = "/800-53PLEnhance.txt";
                res[2][0] = "resources/800-53PLSecurity.txt";
                res[2][1] = "/800-53PLSecurity.txt";
                break;
            }
            case 12: {
                res[0][0] = "resources/800-53PEControl.txt";
                res[0][1] = "/800-53PEControl.txt";
                res[1][0] = "resources/800-53PEEnhance.txt";
                res[1][1] = "/800-53PEEnhance.txt";
                res[2][0] = "resources/800-53PESecurity.txt";
                res[2][1] = "/800-53PESecurity.txt";
                break;
            }
            case 13: {
                res[0][0] = "resources/800-53PSControl.txt";
                res[0][1] = "/800-53PSControl.txt";
                res[1][0] = "resources/800-53PSEnhance.txt";
                res[1][1] = "/800-53PSEnhance.txt";
                res[2][0] = "resources/800-53PSSecurity.txt";
                res[2][1] = "/800-53PSSecurity.txt";
                break;
            }
            case 14: {
                res[0][0] = "resources/800-53RAControl.txt";
                res[0][1] = "/800-53RAControl.txt";
                res[1][0] = "resources/800-53RAEnhance.txt";
                res[1][1] = "/800-53RAEnhance.txt";
                res[2][0] = "resources/800-53RASecurity.txt";
                res[2][1] = "/800-53RASecurity.txt";
                break;
            }
            case 15: {
                res[0][0] = "resources/800-53SAControl.txt";
                res[0][1] = "/800-53SAControl.txt";
                res[1][0] = "resources/800-53SAEnhance.txt";
                res[1][1] = "/800-53SAEnhance.txt";
                res[2][0] = "resources/800-53SASecurity.txt";
                res[2][1] = "/800-53SASecurity.txt";
                break;
            }
            case 16: {
                res[0][0] = "resources/800-53SCControl.txt";
                res[0][1] = "/800-53SCControl.txt";
                res[1][0] = "resources/800-53SCEnhance.txt";
                res[1][1] = "/800-53SCEnhance.txt";
                res[2][0] = "resources/800-53SCSecurity.txt";
                res[2][1] = "/800-53SCSecurity.txt";
                break;
            }
            case 17: {
                res[0][0] = "resources/800-53SIControl.txt";
                res[0][1] = "/800-53SIControl.txt";
                res[1][0] = "resources/800-53SIEnhance.txt";
                res[1][1] = "/800-53SIEnhance.txt";
                res[2][0] = "resources/800-53SISecurity.txt";
                res[2][1] = "/800-53SISecurity.txt";
                break;
            }
            case 18: {
                res[0][0] = "resources/800-53PMControl.txt";
                res[0][1] = "/800-53PMControl.txt";
                res[1][0] = "resources/800-53PMEnhance.txt";
                res[1][1] = "/800-53PMEnhance.txt";
                res[2][0] = "resources/800-53PMSecurity.txt";
                res[2][1] = "/800-53PMSecurity.txt";
                break;
            }
            case 19: {
                res[0][0] = "resources/800-53ApJControl.txt";
                res[0][1] = "/800-53ApJControl.txt";
                res[1][0] = "resources/800-53ApJEnhance.txt";
                res[1][1] = "/800-53ApJEnhance.txt";
                res[2][0] = "resources/800-53ApJSecurity.txt";
                res[2][1] = "/800-53ApJSecurity.txt";
            }
        }
        return res;
    }

    protected static void controlList(int sheetNum) throws IOException {
        InputStream is = null;
        control.clear();
        String[][] file = EightHundredRelationshipsTab.whatTextFile(sheetNum);
        String controlFile = file[0][0];
        String resourceFile = file[0][1];
        is = App.class.getResourceAsStream(resourceFile);
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Object matchValue = null;
        String line = reader.readLine().trim();
        String noSpace = "";
        boolean fail = false;
        boolean trueCount = false;
        while (line != null) {
            control.add(line);
            line = reader.readLine();
        }
        for (int i = 0; i < control.size(); ++i) {
        }
        reader.close();
    }

    protected static void enhanceList(int sheetNum) throws IOException {
        InputStream is = null;
        enhancement.clear();
        String[][] file = EightHundredRelationshipsTab.whatTextFile(sheetNum);
        String enhancementFile = file[1][0];
        String input = file[1][1];
        is = App.class.getResourceAsStream(input);
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Object matchValue = null;
        String line = reader.readLine().trim();
        String noSpace = "";
        boolean fail = false;
        boolean trueCount = false;
        while (line != null) {
            enhancement.add(line);
            line = reader.readLine();
        }
        for (int i = 0; i < enhancement.size(); ++i) {
        }
        reader.close();
    }

    protected static void securityList(int sheetNum) throws IOException {
        InputStream is = null;
        security.clear();
        String[][] file = EightHundredRelationshipsTab.whatTextFile(sheetNum);
        String securityFile = file[2][0];
        is = App.class.getResourceAsStream(file[2][1]);
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Object matchValue = null;
        String line = reader.readLine().trim();
        String noSpace = "";
        boolean fail = false;
        while (line != null) {
            security.add(line);
            line = reader.readLine();
        }
        for (int i = 0; i < security.size(); ++i) {
        }
        reader.close();
    }

    protected static void cesValidation(int sheetNum) throws IOException {
        String controlValue = null;
        String enhanceValue = null;
        String securityValue = null;
        boolean failC = false;
        boolean failE = false;
        boolean failS = false;
        EightHundredRelationshipsTab.controlList(sheetNum);
        EightHundredRelationshipsTab.enhanceList(sheetNum);
        EightHundredRelationshipsTab.securityList(sheetNum);
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        System.out.println("Sheet Name: " + sheet.getSheetName());
        report = "Sheet: " + sheet.getSheetName() + System.getProperty("line.separator") + "Amount of Rows: " + rows + System.getProperty("line.separator");
        ReportCreation.writeFile(report);
        ReportCreation.writeFile2(report);
        System.out.println("Section 2.2.1, and 2.2.2");
        System.out.println("Validating first three columns...");
        System.out.println("Rows: " + rows);
        for (int m = 1; m < rows; ++m) {
            int trueCount = 0;
            int y = 0;
            boolean hasMatch = false;
            controlValue = sheet.getRow(m).getCell(0, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK).toString().trim();
            String testValue = new String();
            for (int p = 0; p < control.size(); ++p) {
                testValue = control.get(p).trim();
                String noSpace = controlValue.replaceAll("(^\\h*)|(\\h*$)", "").trim();
                noSpace = noSpace.replaceAll("\u00ed", "\u2019");
                noSpace = noSpace.replaceAll("/", "\\/");
                noSpace = EightHundredRelationshipsTab.cleanTextContent(noSpace);
                if ((testValue = EightHundredRelationshipsTab.cleanTextContent(testValue)).equals(noSpace)) {
                    y = p + 1;
                    ++trueCount;
                    enhanceValue = sheet.getRow(m).getCell(1, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK).toString().trim();
                    enhanceValue = enhanceValue.replace("/n", "").replace("/r", "").replace(System.getProperty("line.separator"), "").replaceAll("(^\\h*)|(\\h*$)", "").trim();
                    enhanceValue = enhanceValue.replaceAll("\u00ed", "\u2019");
                    enhanceValue = enhanceValue.replaceAll("/n", "\\/n");
                    enhanceValue = EightHundredRelationshipsTab.cleanTextContent(enhanceValue);
                    String eTV = enhancement.get(p).trim();
                    if (enhanceValue.equals(eTV = EightHundredRelationshipsTab.cleanTextContent(eTV))) {
                        securityValue = sheet.getRow(m).getCell(2, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK).toString();
                        if (security.get(p).equalsIgnoreCase(securityValue)) {
                            hasMatch = true;
                            ++trueCount;
                            continue;
                        }
                        System.out.println("In security else false.");
                        hasMatch = false;
                        failS = true;
                        continue;
                    }
                    System.out.println("In enhance else false.");
                    System.out.println("P value: " + p);
                    System.out.println("Enhance Array Value: " + enhancement.get(p));
                    System.out.println("M value: " + m);
                    System.out.println("Enhance Value in Template: " + enhanceValue);
                    hasMatch = false;
                    failE = true;
                    continue;
                }
                hasMatch = false;
                failC = true;
            }
            int t = m + 1;
            if (trueCount >= 1) {
                report = Utility.getTime() + " PASS - Section 2.2.1 - (A" + t + ") - Valid Control Number value - Found Value: " + controlValue;
                report = report.concat(System.getProperty("line.separator"));
                ++passCount;
                if (!failE) {
                    report = report.concat(" PASS - Section 2.2.2 - (B" + t + ") - Valid Control Enhancement Element value - Found Value: " + enhanceValue.subSequence(0, 30) + "...");
                    report = report.concat(System.getProperty("line.separator"));
                    ++passCount;
                } else {
                    report = report.concat(" ERROR - Section 2.2.2 - (B" + t + ") - Invalid Control Enhancement value - Found Value: " + enhanceValue);
                    report = report.concat(System.getProperty("line.separator"));
                    ++errorCount;
                }
                if (!failS) {
                    report = report.concat(" PASS - Section 2.2.3 - (C" + t + ") - Valid Security Control Baseline value - Found Value: " + securityValue);
                    report = report.concat(System.getProperty("line.separator"));
                    ++passCount;
                } else {
                    report = report.concat(" ERROR - Section 2.2.3 - (C" + t + ") - Invalid Security Control Baseline value - Found Value: " + securityValue);
                    report = report.concat(System.getProperty("line.separator"));
                    ++errorCount;
                }
                System.out.println(report);
                ReportCreation.writeFile(report);
            } else if (Utility.notRelated(sheet.getRow(m).getCell(4)).equalsIgnoreCase("true")) {
                report = Utility.getTime() + " PASS - Section 2.2.1, 2.2.2 and 2.2.3 - (A" + t + ") - Relationship Value is Not Related To";
                ++passCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
            } else if (!Utility.notRelated(sheet.getRow(m).getCell(4)).equalsIgnoreCase("extra")) {
                if (failC) {
                    report = report.concat(" ERROR - Section 2.2.1 - (A" + t + ") - Invalid Control Number value - Found Value: " + controlValue) + ". Should have been" + control.get(m);
                    report = report.concat(System.getProperty("line.separator"));
                    ++errorCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                } else if (failE) {
                    report = report.concat(" ERROR - Section 2.2.2 - (B" + t + ") - Invalid Control Enhancement value - Found Value: " + enhanceValue) + ". Should have been" + enhancement.get(m);
                    report = report.concat(System.getProperty("line.separator"));
                    ++errorCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                } else if (failS) {
                    report = report.concat(" ERROR - Section 2.2.3 - (C" + t + ") - Invalid Security Control Baseline value - Found Value: " + securityValue) + ". Should have been" + security.get(m);
                    report = report.concat(System.getProperty("line.separator"));
                    ++errorCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.2.1 - (A" + t + ") - Invalid Control Number value - Found Value: " + controlValue + ". Should have been " + control.get(m);
                    report = report.concat(System.getProperty("line.separator"));
                    report = report.concat(" ERROR - Section 2.2.2 - (B" + t + ") - Invalid Control Enhancement Element value - Found Value: " + enhanceValue + ". Should have been" + enhancement.get(m));
                    report = report.concat(System.getProperty("line.separator"));
                    report = report.concat(" ERROR - Section 2.2.3 - (C" + t + ") - Invalid Security Control Baseline value - Found Value: " + securityValue) + ". Should have been" + security.get(m);
                    report = report.concat(System.getProperty("line.separator"));
                    ++errorCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                }
            }
            failC = false;
            failE = false;
            failS = false;
        }
    }

    protected static void rationalValidation(int sheetNum) throws IOException {
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        System.out.println("Section 2.2.3");
        System.out.println("Validating the rational column...");
        System.out.println("Rows: " + rows);
        for (int j = 1; j < rows; ++j) {
            int k = j + 1;
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(j).getCell(0), sheet.getRow(j).getCell(1), sheet.getRow(j).getCell(2), sheet.getRow(j).getCell(3), sheet.getRow(j).getCell(4), sheet.getRow(j).getCell(6), sheet.getRow(j).getCell(7), j, 6);
            cellValue = Utility.isCellEmpty(sheet.getRow(j).getCell(3), j);
            if (check) {
                if (!cellValue.isEmpty()) {
                    if (cellValue.equalsIgnoreCase("Functional")) {
                        report = Utility.getTime() + " PASS - Section 2.2.3 - (D" + k + ") - Valid Rationale Value - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equalsIgnoreCase("Semantic")) {
                        report = Utility.getTime() + " PASS - Section 2.2.3 - (D" + k + ") - Valid Rationale Value - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equalsIgnoreCase("Syntactic")) {
                        report = Utility.getTime() + " PASS - Section 2.2.3 - (D" + k + ") - Valid Rationale Value - Found Value: " + cellValue;
                        ++passCount;
                    } else if (!("Functional".equals(cellValue) && "Semantic".equals(cellValue) && "Syntactic".equals(cellValue) || cellValue.trim().length() == 0)) {
                        report = Utility.getTime() + " ERROR - Section 2.2.3 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid rationale value - Found Value: " + cellValue;
                        ++errorCount;
                    } else if (!("functional".equals(cellValue) && "semantic".equals(cellValue) && "syntactic".equals(cellValue) || cellValue.trim().length() == 0)) {
                        report = Utility.getTime() + " ERROR - Section 2.2.3 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid rationale value - Found Value: " + cellValue;
                        ++errorCount;
                    } else {
                        report = Utility.getTime() + " ERROR - Section 2.2.3 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Rationale value missing - Found Value: " + cellValue;
                        ++errorCount;
                    }
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Rationale value missing - Found Value: " + cellValue;
                    ++errorCount;
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    protected static void relationshipValidation(int sheetNum) throws IOException {
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        System.out.println("Validating the relationship column...");
        System.out.println("Rows: " + rows);
        System.out.println("Section 2.2.4");
        for (int j = 1; j < rows; ++j) {
            String group;
            String fullfilValue;
            int k = j + 1;
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(j).getCell(0), sheet.getRow(j).getCell(1), sheet.getRow(j).getCell(2), sheet.getRow(j).getCell(3), sheet.getRow(j).getCell(4), sheet.getRow(j).getCell(6), sheet.getRow(j).getCell(7), j, 7);
            cellValue = Utility.isCellEmpty(sheet.getRow(j).getCell(4), j);
            if (check) {
                if (!cellValue.isEmpty()) {
                    if (cellValue.equals("subset of")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(8), j);
                        if (fullfilValue.equalsIgnoreCase("Y") || fullfilValue.equalsIgnoreCase("Yes")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Subset of' then Fulfills Value must be 'Y' - Found Value: " + cellValue;
                            ++errorCount;
                        }
                    } else if (cellValue.equals("intersects with")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(8), j);
                        if (group.equals("") && fullfilValue.equalsIgnoreCase("N")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Intersects With' then Fulfills Value must be 'N' unless there is a Group Identifier - Found Value: " + cellValue;
                            ++errorCount;
                        }
                    } else if (cellValue.equalsIgnoreCase("equal to") || cellValue.equalsIgnoreCase("equal")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(8), j);
                        if (fullfilValue.equalsIgnoreCase("Y") || fullfilValue.equalsIgnoreCase("Yes")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Equal' then Fulfills Value must be 'Y' - Found Value: " + cellValue;
                            ++errorCount;
                        }
                    } else if (cellValue.equals("superset of")) {
                        String fulfillValue = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(8), j);
                        if (group.equals("") && fulfillValue.equalsIgnoreCase("N")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Superset Of' then Fulfills Value must be 'N' unless there is a Group Identifier - Found Value: " + cellValue;
                            ++errorCount;
                        }
                    } else if (cellValue.equals("not related to")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(8), j);
                        if (fullfilValue.equalsIgnoreCase("N") || fullfilValue.equalsIgnoreCase("No")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Not Related To' then Fulfills Value must be 'No' or 'N' - Found Value: " + cellValue;
                            ++errorCount;
                        }
                    } else if (cellValue.equals("")) {
                        report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Relationship Element missing - Found Value: " + cellValue;
                        ++errorCount;
                    } else {
                        report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid Relationship Element value - Found Value: " + cellValue;
                        ++errorCount;
                    }
                } else if (cellValue.trim().length() != 0) {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - Relationship Element missing - Found Value: " + cellValue;
                    ++errorCount;
                }
            } else if (cellValue.equals("not related to")) {
                fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                group = Utility.isCellEmpty(sheet.getRow(j).getCell(8), j);
                if (fullfilValue.equalsIgnoreCase("N") || fullfilValue.equalsIgnoreCase("No")) {
                    report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                    ++passCount;
                } else if (!group.equalsIgnoreCase("")) {
                    report = Utility.getTime() + " PASS - Section 2.2.4 - (F" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                    ++passCount;
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Not Related To' then Fulfills Value must be 'No' or 'N' - Found Value: " + cellValue;
                    ++errorCount;
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    protected static void referenceDocumentValidation(int sheetNum) throws IOException {
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        System.out.println("Validating the reference document column...");
        System.out.println("Rows: " + rows);
        System.out.println("Section 2.2.5");
        for (int i = 1; i < rows; ++i) {
            String pattern = "([a-zA-Z0-9]*\\.)*([0-9]*)";
            String pattern2 = "([a-zA-Z0-9]*\\-)*([0-9]*)";
            int k = i + 1;
            report = Utility.reportClear();
            boolean checks = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(5), sheet.getRow(i).getCell(7), i, 8);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(5), i);
            if (checks) {
                if (!cellValue.isEmpty()) {
                    report = Utility.getTime() + " PASS - Section 2.2.5 - (F" + k + ") - Populated Reference Element Value - Found Value: " + cellValue;
                    ++passCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                    continue;
                }
                int j = k - 1;
                report = Utility.getTime() + " ERROR - Section 2.2.5 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Missing Reference Element Value - Found Value: " + cellValue;
                ++errorCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
                continue;
            }
            if (Utility.notRelated(sheet.getRow(i).getCell(4)).equalsIgnoreCase("true")) {
                report = Utility.getTime() + " PASS - Section 2.2.5 - (F" + k + ") - Relationship Value is Not Related To";
                ++passCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
                continue;
            }
            if (!Utility.notRelated(sheet.getRow(i).getCell(4)).equalsIgnoreCase("extra")) continue;
        }
    }

    protected static void referenceDescriptorValidation(int sheetNum) throws IOException {
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        System.out.println("Validating the reference document descriptor column...");
        System.out.println("Rows: " + rows);
        System.out.println("Section 2.2.6");
        for (int i = 1; i < rows; ++i) {
            int j;
            int k = i + 1;
            report = Utility.reportClear();
            boolean refDoc = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), sheet.getRow(i).getCell(7), i, 9);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(6), i);
            if (refDoc) {
                if (cellValue.isEmpty()) {
                    j = k - 1;
                    report = Utility.getTime() + " WARNING - Section 2.2.6 - (G" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - No Descriptor Value";
                    ++warningCount;
                } else if (cellValue.equalsIgnoreCase("No mapping")) {
                    j = k - 1;
                    report = Utility.getTime() + " WARNING - Section 2.2.6 - (G" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - No Descriptor Value";
                    ++warningCount;
                } else {
                    report = Utility.getTime() + " PASS - Section 2.2.6 - (G" + k + ") - Description Exists";
                    ++passCount;
                }
            } else if (cellValue.equalsIgnoreCase("No mapping")) {
                j = k - 1;
                report = Utility.getTime() + " WARNING - Section 2.2.6 - (G" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - No Descriptor Value";
                ++warningCount;
            } else if (cellValue.isEmpty() && Utility.notRelated(sheet.getRow(i).getCell(4)).equalsIgnoreCase("true")) {
                j = k - 1;
                report = Utility.getTime() + " PASS - Section 2.2.6 - (G" + k + ") - Relationship Value is Not Related To " + j + ".";
                ++passCount;
            } else if (!cellValue.isEmpty() || !Utility.notRelated(sheet.getRow(i).getCell(4)).equalsIgnoreCase("extra")) {
                if (cellValue.isEmpty()) {
                    j = k - 1;
                    report = Utility.getTime() + " WARNING - Section 2.2.6 - (G" + k + ") - Relationship Value is Not Related To.";
                    ++warningCount;
                } else if (Utility.notRelated(sheet.getRow(i).getCell(4)).equalsIgnoreCase("true")) {
                    report = Utility.getTime() + " PASS - Section 2.2.6 - (G" + k + ") - Relationship Value is Not Related To.";
                    ++passCount;
                } else if (Utility.notRelated(sheet.getRow(i).getCell(4)).equalsIgnoreCase("extra")) {
                    // empty if block
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    protected static void fullfillValidation(int sheetNum) throws Exception, NullPointerException {
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        System.out.println("Validating the fulfill by column...");
        System.out.println("Rows: " + rows);
        System.out.println("Section 2.2.7");
        for (int i = 1; i < rows; ++i) {
            String nrt;
            int k = i + 1;
            String relationshipValue = Utility.isCellEmpty(sheet.getRow(i).getCell(4), i);
            String groupValue = Utility.isCellEmpty(sheet.getRow(i).getCell(8), i);
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(5), sheet.getRow(i).getCell(7), i, 10);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(7), i);
            if (check) {
                if (!cellValue.isEmpty()) {
                    if (cellValue.equalsIgnoreCase("Y") && (relationshipValue.equalsIgnoreCase("subset of") || relationshipValue.equalsIgnoreCase("equal to") || relationshipValue.equalsIgnoreCase("equal"))) {
                        report = Utility.getTime() + " PASS - Section 2.2.7 - (H" + k + ") - Valid Fulfills - Found Value: " + cellValue;
                        ++passCount;
                    } else if (!groupValue.isEmpty()) {
                        report = Utility.getTime() + " PASS - Section 2.2.7 - (G" + k + ") - Valid Fulfills due to Group Id - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equalsIgnoreCase("N") && (relationshipValue.equalsIgnoreCase("intersects with") || relationshipValue.equalsIgnoreCase("not related to") || relationshipValue.equalsIgnoreCase("superset of"))) {
                        report = Utility.getTime() + " PASS - Section 2.2.7 - (H" + k + ") - Valid Fulfills - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equals("")) {
                        int j = k - 1;
                        report = Utility.getTime() + " ERROR - Section 2.2.7 - (H" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Missing Fulfills value - Found Value: " + cellValue;
                        ++errorCount;
                    } else {
                        int j = k - 1;
                        report = Utility.getTime() + " ERROR - Section 2.2.7 - (H" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid Fulfills value - Found Value: " + cellValue;
                        ++errorCount;
                    }
                } else {
                    int j = k - 1;
                    report = Utility.getTime() + " ERROR - Section 2.2.7 - (H" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Fulfills value missing - Found Value: " + cellValue;
                    ++errorCount;
                }
            } else if (cellValue.trim().length() != 0 && (nrt = Utility.isCellEmpty(sheet.getRow(i).getCell(4), i)).equalsIgnoreCase("not related to")) {
                int j = k - 1;
                report = Utility.getTime() + " WARNING - Section 2.2.7 - (H" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Found \"Not Related To\" in the Relationship Column in Row: " + k + "  - Found Fulfills Value: " + cellValue;
                ++warningCount;
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    public static void groupValidation(int sheetNum) throws IOException {
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        boolean hasAMatch = false;
        String[][] file = EightHundredRelationshipsTab.whatTextFile(sheetNum);
        String controlFile = file[0][0];
        InputStream is = App.class.getResourceAsStream(file[0][1]);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> fe = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            fe.add(line);
            line = reader.readLine();
        }
        reader.close();
        int count = 0;
        System.out.println("Section 2.2.8");
        for (int i = 1; i < rows; ++i) {
            int k = i + 1;
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), sheet.getRow(i).getCell(7), i, 9);
            XSSFRow row = sheet.getRow(i);
            XSSFCell cell = row.getCell(8);
            if (!check) continue;
            if (!cellValue.equalsIgnoreCase("") && cell.getCellTypeEnum() == CellType.FORMULA) {
                switch (cell.getCachedFormulaResultTypeEnum()) {
                    case BOOLEAN: {
                        System.out.println("Group Boolean Value:  " + cell.getBooleanCellValue());
                        break;
                    }
                    case NUMERIC: {
                        System.out.println("Group Numeric Value:  " + cell.getNumericCellValue());
                        break;
                    }
                    case STRING: {
                        cellValue = String.valueOf(cell.getRichStringCellValue());
                    }
                }
            }
            if (!cellValue.isEmpty()) {
                if (cellValue.contains(":")) {
                    int j;
                    Scanner scan = new Scanner(cellValue);
                    Scanner scan2 = new Scanner(cellValue).useDelimiter(":");
                    String frameElement = scan2.next();
                    String group = scan2.next();
                    for (j = 2; j <= rows; ++j) {
                        count = 0;
                        for (int p = 0; p < fe.size(); ++p) {
                            if (!((String)fe.get(p)).equals(frameElement)) continue;
                            ++count;
                        }
                        hasAMatch = count >= 1;
                    }
                    if (hasAMatch) {
                        if (group.matches("[G][0-9]*")) {
                            report = Utility.getTime() + " PASS - Section 2.2.8 - (I" + k + ") - Valid Group Number Value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            j = k - 1;
                            report = Utility.getTime() + " ERROR - Section 2.2.8 - (I" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid format for Group Number Value - Found Value: " + cellValue;
                            ++errorCount;
                        }
                    } else {
                        j = k - 1;
                        report = Utility.getTime() + " ERROR - Section 2.2.8 - (I" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid format for Group Number Value - Found Value: " + cellValue;
                        ++errorCount;
                    }
                    scan.close();
                    scan2.close();
                } else if (cellValue.equals("N/A")) {
                    report = Utility.getTime() + " WARNING - Section 2.2.8 - (I" + k + ") - Not Applicable - Found Value: " + cellValue;
                    ++warningCount;
                } else {
                    int j = k - 1;
                    report = Utility.getTime() + " ERROR - Section 2.2.8 - (I" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid format for Group Number Value: missing the colon - Found Value: " + cellValue;
                    ++errorCount;
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            hasAMatch = true;
            ReportCreation.writeFile(report);
        }
    }

    private static boolean strengthColumnExists(int sheetNum) throws IOException {
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        String columnValue = Utility.isCellEmpty(sheet.getRow(0).getCell(10), 0);
        return columnValue.equalsIgnoreCase("strength of relationship");
    }

    protected static void strengthValidation(int sheetNum) throws IOException {
        EightHundredRelationshipsTab.strengthColumnExists(sheetNum);
        EightHundredRelationshipsTab.connectExcelAll(sheetNum);
        boolean hasAMatch = false;
        System.out.println("Section 2.2.9");
        for (int i = 1; i < rows; ++i) {
            int k = i + 1;
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), sheet.getRow(i).getCell(7), i, 9);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(10), i);
            String[] arrOfStr = cellValue.split("\\.");
            cellValue = arrOfStr[0];
            if (check && !cellValue.isEmpty()) {
                if (cellValue.matches("[0-9]|[0-1][0]")) {
                    report = Utility.getTime() + " PASS - Section 2.2.9 - (K" + k + ") - Valid Strength Value: " + cellValue;
                    ++passCount;
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.2.9 - (K" + k + ") - Invalid Strength Value must be between 0 and 10. Found value: " + cellValue;
                    ++errorCount;
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            hasAMatch = true;
            ReportCreation.writeFile(report);
        }
    }

    protected static void relationshipsTab() throws Exception {
        for (int i = 1; i <= 19; ++i) {
            rows = 0;
            EightHundredRelationshipsTab.totalRows(i);
            EightHundredRelationshipsTab.cesValidation(i);
            EightHundredRelationshipsTab.rationalValidation(i);
            EightHundredRelationshipsTab.relationshipValidation(i);
            EightHundredRelationshipsTab.referenceDocumentValidation(i);
            EightHundredRelationshipsTab.referenceDescriptorValidation(i);
            EightHundredRelationshipsTab.fullfillValidation(i);
            EightHundredRelationshipsTab.groupValidation(i);
            EightHundredRelationshipsTab.strengthValidation(i);
        }
    }
}

