/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;

public class EscherRecordHolder {
    protected ArrayList escherRecords = new ArrayList();

    public EscherRecordHolder() {
    }

    public EscherRecordHolder(byte[] data, int offset, int size) {
        this.fillEscherRecords(data, offset, size);
    }

    private void fillEscherRecords(byte[] data, int offset, int size) {
        int bytesRead;
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        for (int pos = offset; pos < offset + size; pos += bytesRead + 1) {
            EscherRecord r = recordFactory.createRecord(data, pos);
            this.escherRecords.add(r);
            bytesRead = r.fillFields(data, pos, recordFactory);
        }
    }

    public List getEscherRecords() {
        return this.escherRecords;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        if (this.escherRecords.size() == 0) {
            buffer.append("No Escher Records Decoded" + nl);
        }
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            buffer.append(((Object)r).toString());
        }
        return buffer.toString();
    }

    public EscherContainerRecord getEscherContainer() {
        Iterator it = this.escherRecords.iterator();
        while (it.hasNext()) {
            Object er = it.next();
            if (!(er instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)er;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short id) {
        return this.findFirstWithId(id, this.getEscherRecords());
    }

    private EscherRecord findFirstWithId(short id, List records) {
        EscherRecord r;
        Iterator it = records.iterator();
        while (it.hasNext()) {
            r = (EscherRecord)it.next();
            if (r.getRecordId() != id) continue;
            return r;
        }
        it = records.iterator();
        while (it.hasNext()) {
            EscherRecord found;
            r = (EscherRecord)it.next();
            if (!r.isContainerRecord() || (found = this.findFirstWithId(id, r.getChildRecords())) == null) continue;
            return found;
        }
        return null;
    }
}

