/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class CurrentUserAtom {
    public static final byte[] atomHeader = new byte[]{0, 0, -10, 15};
    public static final byte[] magicNumber = new byte[]{95, -64, -111, -29};
    public static final byte[] ppt97FileVer = new byte[]{8, 0, -13, 3, 3, 0};
    private int docFinalVersionA;
    private int docFinalVersionB;
    private byte docMajorNo;
    private byte docMinorNo;
    private long currentEditOffset;
    private String lastEditUser;
    private long releaseVersion;
    private byte[] _contents;

    public int getDocFinalVersionA() {
        return this.docFinalVersionA;
    }

    public int getDocFinalVersionB() {
        return this.docFinalVersionB;
    }

    public byte getDocMajorNo() {
        return this.docMajorNo;
    }

    public byte getDocMinorNo() {
        return this.docMinorNo;
    }

    public long getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(long rv) {
        this.releaseVersion = rv;
    }

    public long getCurrentEditOffset() {
        return this.currentEditOffset;
    }

    public void setCurrentEditOffset(long id) {
        this.currentEditOffset = id;
    }

    public String getLastEditUsername() {
        return this.lastEditUser;
    }

    public void setLastEditUsername(String u) {
        this.lastEditUser = u;
    }

    public CurrentUserAtom() {
        this._contents = new byte[0];
        throw new RuntimeException("Creation support for Current User Atom not complete");
    }

    public CurrentUserAtom(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public CurrentUserAtom(DirectoryNode dir) throws IOException {
        DocumentEntry docProps = (DocumentEntry)dir.getEntry("Current User");
        this._contents = new byte[docProps.getSize()];
        if (this._contents.length < 28) {
            throw new CorruptPowerPointFileException("The Current User stream must be at least 28 bytes long, but was only " + this._contents.length);
        }
        DocumentInputStream in = dir.createDocumentInputStream("Current User");
        ((InputStream)in).read(this._contents);
        this.init();
    }

    public CurrentUserAtom(byte[] b) {
        this._contents = b;
        this.init();
    }

    private void init() {
        this.currentEditOffset = LittleEndian.getUInt(this._contents, 16);
        this.docFinalVersionA = LittleEndian.getUShort(this._contents, 20);
        this.docFinalVersionB = LittleEndian.getUShort(this._contents, 22);
        this.docMajorNo = this._contents[24];
        this.docMinorNo = this._contents[25];
        long usernameLen = LittleEndian.getUShort(this._contents, 20);
        if (usernameLen > 512L) {
            System.err.println("Warning - invalid username length " + usernameLen + " found, treating as if there was no username set");
            usernameLen = 0L;
        }
        this.releaseVersion = this._contents.length >= 28 + (int)usernameLen + 4 ? LittleEndian.getUInt(this._contents, 28 + (int)usernameLen) : 0L;
        int start = 28 + (int)usernameLen + 4;
        int len = 2 * (int)usernameLen;
        if (this._contents.length >= start + len) {
            byte[] textBytes = new byte[len];
            System.arraycopy(this._contents, start, textBytes, 0, len);
            this.lastEditUser = StringUtil.getFromUnicodeLE(textBytes);
        } else {
            byte[] textBytes = new byte[(int)usernameLen];
            System.arraycopy(this._contents, 28, textBytes, 0, (int)usernameLen);
            this.lastEditUser = StringUtil.getFromCompressedUnicode(textBytes, 0, (int)usernameLen);
        }
    }

    public void writeOut(OutputStream out) throws IOException {
        int size = 32 + 3 * this.lastEditUser.length();
        this._contents = new byte[size];
        System.arraycopy(atomHeader, 0, this._contents, 0, 4);
        int atomSize = 24 + this.lastEditUser.length();
        LittleEndian.putInt(this._contents, 4, atomSize);
        LittleEndian.putInt(this._contents, 8, 20);
        System.arraycopy(magicNumber, 0, this._contents, 12, 4);
        LittleEndian.putInt(this._contents, 16, (int)this.currentEditOffset);
        LittleEndian.putShort(this._contents, 20, (short)this.docFinalVersionA);
        LittleEndian.putShort(this._contents, 22, (short)this.docFinalVersionB);
        this._contents[24] = this.docMajorNo;
        this._contents[25] = this.docMinorNo;
        this._contents[26] = 0;
        this._contents[27] = 0;
        byte[] asciiUN = new byte[this.lastEditUser.length()];
        StringUtil.putCompressedUnicode(this.lastEditUser, asciiUN, 0);
        System.arraycopy(asciiUN, 0, this._contents, 28, asciiUN.length);
        LittleEndian.putInt(this._contents, 28 + asciiUN.length, (int)this.releaseVersion);
        byte[] ucUN = new byte[this.lastEditUser.length() * 2];
        StringUtil.putUnicodeLE(this.lastEditUser, ucUN, 0);
        System.arraycopy(ucUN, 0, this._contents, 28 + asciiUN.length + 4, ucUN.length);
        out.write(this._contents);
    }

    public void writeToFS(POIFSFileSystem fs) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeOut(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        fs.createDocument(bais, "Current User");
    }
}

