/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.util.LittleEndian;

public abstract class Metafile
extends PictureData {
    protected byte[] compress(byte[] bytes, int offset, int length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream(out);
        deflater.write(bytes, offset, length);
        deflater.close();
        return out.toByteArray();
    }

    public static class Header {
        public int wmfsize;
        public Rectangle bounds;
        public Dimension size;
        public int zipsize;
        public int compression;
        public int filter = 254;

        public void read(byte[] data, int offset) {
            int pos = offset;
            this.wmfsize = LittleEndian.getInt(data, pos);
            int left = LittleEndian.getInt(data, pos += 4);
            int top = LittleEndian.getInt(data, pos += 4);
            int right = LittleEndian.getInt(data, pos += 4);
            int bottom = LittleEndian.getInt(data, pos += 4);
            this.bounds = new Rectangle(left, top, right - left, bottom - top);
            int width = LittleEndian.getInt(data, pos += 4);
            int height = LittleEndian.getInt(data, pos += 4);
            this.size = new Dimension(width, height);
            this.zipsize = LittleEndian.getInt(data, pos += 4);
            this.compression = LittleEndian.getUnsignedByte((byte[])data, (int)(pos += 4));
            this.filter = LittleEndian.getUnsignedByte((byte[])data, (int)(++pos));
            ++pos;
        }

        public void write(OutputStream out) throws IOException {
            byte[] header = new byte[34];
            int pos = 0;
            LittleEndian.putInt(header, pos, this.wmfsize);
            LittleEndian.putInt(header, pos += 4, this.bounds.x);
            LittleEndian.putInt(header, pos += 4, this.bounds.y);
            LittleEndian.putInt(header, pos += 4, this.bounds.x + this.bounds.width);
            LittleEndian.putInt(header, pos += 4, this.bounds.y + this.bounds.height);
            LittleEndian.putInt(header, pos += 4, this.size.width);
            LittleEndian.putInt(header, pos += 4, this.size.height);
            LittleEndian.putInt(header, pos += 4, this.zipsize);
            header[pos += 4] = 0;
            header[++pos] = (byte)this.filter;
            ++pos;
            out.write(header);
        }

        public int getSize() {
            return 34;
        }
    }
}

