/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.util.List;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherPropertyFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.UnknownEscherRecord;
import org.apache.poi.hslf.model.AutoShape;
import org.apache.poi.hslf.model.Freeform;
import org.apache.poi.hslf.model.Line;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.model.Picture;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.SimpleShape;
import org.apache.poi.hslf.model.TextBox;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class ShapeFactory {
    protected static POILogger logger = POILogFactory.getLogger(class$org$apache$poi$hslf$model$ShapeFactory == null ? (class$org$apache$poi$hslf$model$ShapeFactory = ShapeFactory.class$("org.apache.poi.hslf.model.ShapeFactory")) : class$org$apache$poi$hslf$model$ShapeFactory);
    static /* synthetic */ Class class$org$apache$poi$hslf$model$ShapeFactory;

    public static Shape createShape(EscherContainerRecord spContainer, Shape parent) {
        if (spContainer.getRecordId() == -4093) {
            return ShapeFactory.createShapeGroup(spContainer, parent);
        }
        return ShapeFactory.createSimpeShape(spContainer, parent);
    }

    public static ShapeGroup createShapeGroup(EscherContainerRecord spContainer, Shape parent) {
        ShapeGroup group;
        block5: {
            group = null;
            UnknownEscherRecord opt = (UnknownEscherRecord)Shape.getEscherChild((EscherContainerRecord)spContainer.getChild(0), -3806);
            if (opt != null) {
                try {
                    EscherPropertyFactory f = new EscherPropertyFactory();
                    List<EscherProperty> props = f.createProperties(opt.getData(), 0, opt.getInstance());
                    EscherSimpleProperty p = (EscherSimpleProperty)props.get(0);
                    if (p.getPropertyNumber() == 927 && p.getPropertyValue() == 1) {
                        group = new ShapeGroup(spContainer, parent);
                        break block5;
                    }
                    group = new ShapeGroup(spContainer, parent);
                }
                catch (Exception e) {
                    logger.log(5, e.getMessage());
                    group = new ShapeGroup(spContainer, parent);
                }
            } else {
                group = new ShapeGroup(spContainer, parent);
            }
        }
        return group;
    }

    public static Shape createSimpeShape(EscherContainerRecord spContainer, Shape parent) {
        SimpleShape shape;
        Object spRecord = spContainer.getChildById((short)-4086);
        int type = ((EscherRecord)spRecord).getOptions() >> 4;
        switch (type) {
            case 202: {
                shape = new TextBox(spContainer, parent);
                break;
            }
            case 75: 
            case 201: {
                EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(spContainer, -4085);
                EscherProperty prop = Shape.getEscherProperty(opt, 267);
                if (prop != null) {
                    shape = new OLEShape(spContainer, parent);
                    break;
                }
                shape = new Picture(spContainer, parent);
                break;
            }
            case 20: {
                shape = new Line(spContainer, parent);
                break;
            }
            case 0: {
                EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(spContainer, -4085);
                EscherProperty prop = Shape.getEscherProperty(opt, 325);
                if (prop != null) {
                    shape = new Freeform(spContainer, parent);
                    break;
                }
                logger.log(5, "Creating AutoShape for a NotPrimitive shape");
                shape = new AutoShape(spContainer, parent);
                break;
            }
            default: {
                shape = new AutoShape(spContainer, parent);
            }
        }
        return shape;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

