/*
 * Decompiled with CFR 0.152.
 */
package com.IR8278;

import com.IR8278.CSFRelationshipsTab;
import com.IR8278.Document;
import com.IR8278.DocumentPrep;
import com.IR8278.EightHundredRelationshipsTab;
import com.IR8278.OneEightyOne;
import com.IR8278.ReportCreation;
import com.IR8278.RevFive;
import com.IR8278.TwoThirteenA;
import com.IR8278.Utility;
import java.io.IOException;
import java.util.Date;
import org.apache.poi.ss.format.CellDateFormatter;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class ValidationTests
extends DocumentPrep {
    static int failCount;
    static String report;
    static int errorCount;
    static int warningCount;
    static int passCount;
    static String cellValue;

    protected static String decideDocuType(String docType) throws Exception {
        if (docType.equals("CSF 1.1")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("PF")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("800-53")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            EightHundredRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("IoT")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("800-53 Rev 5")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            RevFive.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("800-171 Rev 2")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("NISTIR 8259B")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("SSDF")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("NIST SP 800-213A")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            TwoThirteenA.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("ConsumerIoT")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("800-181 Complete")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            OneEightyOne.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        } else if (docType.equals("SP800-221A")) {
            ValidationTests.generalTabRe();
            report = Utility.getTime() + " INFO - Begin Relationship Tab Testing\n";
            System.out.println(report);
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.relationshipsTab();
            report = Utility.getTime() + " INFO - Total Number of Passes: " + passCount + " Errors: " + errorCount + " and Warnings: " + warningCount + ".";
            ReportCreation.writeFile(report);
            System.out.println(report);
            System.out.println(Utility.getTime() + " INFO - Program is complete.");
        }
        return docType;
    }

    protected static void generalTab() throws IOException {
        DocumentPrep.connectExcelFirst();
        failCount = 0;
        int d = DocumentPrep.totalGeneralRows();
        System.out.println("Number of Rows: " + d);
        int shouldHave = 18;
        if (shouldHave != d) {
            ++failCount;
            report = Utility.getTime() + " " + DocumentPrep.totalGeneralRows() + " ERROR - There are missing required rows in the General Tab. Please check to make sure that you are using the correct version of the template. You can download the current version of the template at: https://www.nist.gov/file/421906.";
            ++errorCount;
            System.out.println(report);
            ReportCreation.writeFile(report);
        } else {
            cellValue = sheet.getRow(2).getCell(1).toString();
            System.out.println("Section 2.1.1");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.1 - (B3) - Informative Reference Name value not present - Found Value: " + cellValue;
                ++errorCount;
                ++failCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.1 - (B3) - Informative Reference Name value present - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(3).getCell(1).toString();
            System.out.println("Section 2.1.2");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value not present - Found Value: " + cellValue;
                ++errorCount;
                ++failCount;
            } else if (cellValue.matches("([0-9]*)\\.([0-9]*)\\.([0-9]*)")) {
                report = Utility.getTime() + " PASS - Section 2.1.2 - (B4) - Reference Version value present - Found Value: " + cellValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value is malformed - Found Value: " + cellValue;
                ++errorCount;
                ++failCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(4).getCell(1).toString();
            System.out.println("Section 2.1.3");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.3 - (B5) - Web Address not included - Found Value: " + cellValue;
                ++errorCount;
            } else if (Utility.isValid(cellValue)) {
                report = Utility.getTime() + " PASS - Section 2.1.3 - (B5) - Valid Web Address - Found Value: " + cellValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.3 - (B5) - Invalid Web Address - Found Value: " + cellValue;
                ++errorCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(5).getCell(1).toString();
            System.out.println("Section 2.1.4");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(0).toString() + " isn't present - Found Value: " + cellValue;
                ++errorCount;
            } else if (cellValue.matches("([0-1]*)\\.([0-1]*)")) {
                report = Utility.getTime() + " PASS - Section 2.1.4 - (B6) - Valid Focal Document: " + sheet.getRow(5).getCell(0).toString() + " - Found Value: " + cellValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(0).toString() + " is maleformed - Found Value: " + cellValue;
                ++errorCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(6).getCell(1).toString();
            System.out.println("Section 2.1.5");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.5 - (B7) - Missing Summary - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.5 - (B7) - Summary Found - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(7).getCell(1).toString();
            System.out.println("Section 2.1.6");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.6 - (B8) - Missing Target Audience - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.6 - (B8) - Target Audience Found - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(8).getCell(1).toString();
            System.out.println("Section 2.1.7");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.7 - (B9) - Missing Comprehensive Value - Found Value: " + cellValue;
                ++errorCount;
            } else if (cellValue.equals("Yes") || cellValue.equals("No") || cellValue.equals("Y") || cellValue.equals("N")) {
                report = Utility.getTime() + " PASS - Section 2.1.7 - (B9) - Valid Comprehensive Value";
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.7 - (B9) - Malformed Comprehensive Value";
                ++errorCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(9).getCell(1).toString();
            System.out.println("Section 2.1.8");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.8 - (B10) - Missing Reference Document Author";
                ++errorCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.8 - (B10) - Reference Document Author Found";
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(10).getCell(1).toString();
            System.out.println("Section 2.1.9");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.9 = (B11) - Missing Reference Document - Found Value: " + cellValue;
                ++errorCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.9 = (B11) - Reference Document Found - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(11).getCell(1).toString();
            if (cellValue.matches("[0-1][0-9]\\/[0][0]\\/[1-2][0-9][0-9][0-9]")) {
                System.out.println("Section 2.1.10");
                if (cellValue.isEmpty()) {
                    report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: " + cellValue;
                    ++errorCount;
                } else if (cellValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                    report = Utility.getTime() + " PASS - Section 2.1.10 = (B12) - Reference Document Date Found - Found Value: " + cellValue;
                    ++passCount;
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Malformed Reference Document Date - Found Value: " + cellValue + " expected MM/DD/YYYY.";
                    ++errorCount;
                }
                System.out.println(report);
            } else {
                XSSFCell dateValue = sheet.getRow(11).getCell(1);
                Date dv = dateValue.getDateCellValue();
                String df = dateValue.getCellStyle().getDataFormatString();
                String strValue = new CellDateFormatter(df).format(dv);
                if (strValue.contains(";")) {
                    String[] sv = strValue.split(";");
                    strValue = sv[0];
                }
                System.out.println("Section 2.1.10");
                if (strValue.isEmpty()) {
                    report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: " + strValue;
                    ++errorCount;
                } else if (strValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                    report = Utility.getTime() + " PASS - Section 2.1.10 = (B12) - Reference Document Date Found - Found Value: " + strValue;
                    ++passCount;
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Malformed Reference Document Date - Found Value: " + strValue + " expected MM/DD/YYYY.";
                    ++errorCount;
                }
                System.out.println(report);
            }
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(12).getCell(1).toString();
            System.out.println("Section 2.1.11");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.11 - (B13) - Missing Reference Document URL - Found Value: " + cellValue;
                ++warningCount;
            } else if (Utility.isValid(cellValue)) {
                report = Utility.getTime() + " PASS - Section 2.1.11 - (B13) - Valid Reference Document URL - Found Value: " + cellValue.replaceAll(" ", "%20");
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.11 - (B13) - Invalid Reference Document URL - Found Value: " + cellValue;
                ++errorCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(13).getCell(1).toString();
            System.out.println("Section 2.1.12");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.12 - (B14) - Missing Reference Developer - Found Value: " + cellValue;
                ++errorCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.12 - (B14) - Reference Developer Found - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(14).getCell(1).toString();
            System.out.println("Section 2.1.13");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.13 - (B15) - No comments - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.13 - (B15) - Comments Found  - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(15).getCell(1).toString();
            System.out.println("Section 2.1.14");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.14 - (B16) - Missing Point of Contact - Found Value: " + cellValue;
                ++errorCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.14 - (B16) - Point of Contact Found  - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(16).getCell(1).toString();
            System.out.println("Section 2.1.15");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.15 - (B17) - Dependency/Requirement Empty - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.15 - (B17) - Dependency/Requirement Found  - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(17).getCell(1).toString();
            System.out.println("Section 2.1.16");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.16 - (B18) - Citations are Empty - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.16 - (B18) - Citations Found  - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    protected static String returnDoc(int d) {
        String docType = new String();
        for (int i = 0; i < d; ++i) {
            String cellValue = sheet.getRow(i).getCell(1).toString();
            if (cellValue.equals("SP 800-53 Rev. 4")) {
                docType = Document.EightHundred();
                continue;
            }
            if (cellValue.equals("Privacy Framework v1.0")) {
                docType = Document.PF();
                continue;
            }
            if (cellValue.equals("Cybersecurity Framework v1.1")) {
                docType = Document.CSF();
                continue;
            }
            if (cellValue.equals("IoT Device Cybersecurity Capability Core Baseline")) {
                docType = Document.IoT();
                continue;
            }
            if (cellValue.equals("800-53 Rev. 5")) {
                docType = Document.Rev5();
                continue;
            }
            if (cellValue.equals("NIST SP800-171 Revision 2")) {
                docType = Document.OneSeventyOneRev2();
                continue;
            }
            if (cellValue.equals("IoT Non-Technical Supporting Capability Core Baseline")) {
                docType = Document.EightyTwoFiftyNineB();
                continue;
            }
            if (cellValue.equals("SP 800-218 Secure Software Development Framework (SSDF) Version 1.1:\nRecommendations for Mitigating the Risk of Software Vulnerabilities")) {
                docType = Document.SSDF();
                continue;
            }
            if (cellValue.equals("NIST SP 800-213A")) {
                docType = Document.Two13A();
                continue;
            }
            if (cellValue.equals("Profile of the IoT Core Baseline for Consumer IoT Products ")) {
                docType = Document.ConsumerIoT();
                continue;
            }
            if (cellValue.equals("SP 800-181 (2017)")) {
                docType = Document.OneEightyOneComplete();
                continue;
            }
            if (!cellValue.equals("SP800-221A")) continue;
            docType = Document.TwoTwentyOneA();
        }
        return docType;
    }

    protected static void generalTabRe() throws Exception {
        DocumentPrep.connectExcelFirst();
        failCount = 0;
        int d = DocumentPrep.totalGeneralRows();
        System.out.println("Number of Rows: " + d);
        int shouldHave = 0;
        String docuType = ValidationTests.returnDoc(d);
        if (docuType.equals("800-53") && d == 19) {
            shouldHave = 19;
            ValidationTests.ehgen(shouldHave);
        } else if (docuType.equals("800-53 Rev 5") && d == 19) {
            shouldHave = 19;
            ValidationTests.ehgen(shouldHave);
        } else if (docuType.equals("PF") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("800-171 Rev 2") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("IoT") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("NISTIR 8259B") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("SSDF") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("NIST SP 800-213A") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("ConsumerIoT") && d == 17) {
            shouldHave = 17;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("800-181 Complete") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("SP800-221A") && d == 18) {
            shouldHave = 18;
            ValidationTests.csfYpfGen(shouldHave);
        } else if (docuType.equals("CSF 1.1")) {
            if (d == 19) {
                shouldHave = 18;
                ValidationTests.csfYpfGen(shouldHave);
            } else if (d == 18) {
                shouldHave = 18;
                ValidationTests.csfOldGen(shouldHave);
            } else {
                ++failCount;
                report = Utility.getTime() + " " + DocumentPrep.totalGeneralRows() + " ERROR - There are missing required rows in the General Tab. Please check to make sure that you are using the correct version of the template.";
                ++errorCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
            }
        } else {
            ++failCount;
            report = Utility.getTime() + " " + DocumentPrep.totalGeneralRows() + " ERROR - There are missing required rows in the General Tab. Please check to make sure that you are using the correct version of the template.";
            ++errorCount;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    private static void csfOldGen(int shouldHave) throws IOException {
        cellValue = sheet.getRow(2).getCell(1).toString();
        System.out.println("Section 2.1.1");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.1 - (B3) - Informative Reference Name value not present - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.1 - (B3) - Informative Reference Name value present - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(3).getCell(1).toString();
        System.out.println("Section 2.1.2");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value not present - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        } else if (cellValue.matches("([0-9]*)\\.([0-9]*)\\.([0-9]*)")) {
            report = Utility.getTime() + " PASS - Section 2.1.2 - (B4) - Reference Version value present - Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value is malformed - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(4).getCell(1).toString();
        System.out.println("Section 2.1.3");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.3 - (B5) - Web Address not included - Found Value: " + cellValue;
            ++errorCount;
        } else if (Utility.isValid(cellValue)) {
            report = Utility.getTime() + " PASS - Section 2.1.3 - (B5) - Valid Web Address - Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.3 - (B5) - Invalid Web Address - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(5).getCell(1).toString();
        System.out.println("Section 2.1.4");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(1).toString() + " isn't present - Found Value: " + cellValue;
            ++errorCount;
        } else if (cellValue.equals("Cybersecurity Framework v1.1") || cellValue.equals("Privacy Framework v1.0") || cellValue.equals("SP 800-53 Rev. 4") || cellValue.trim().equals("IoT Device Cybersecurity Capability Core Baseline") || cellValue.trim().equals("IoT Non-Technical Supporting Capability Core Baseline") || cellValue.trim().equals("NIST SP 800-213A") || cellValue.trim().equals("SP 800-218 Secure Software Development Framework (SSDF) Version 1.1:\nRecommendations for Mitigating the Risk of Software Vulnerabilities") || cellValue.trim().equals("Recommended Criteria for Cybersecurity Labeling for Consumer Internet of Things (IoT) Products")) {
            report = Utility.getTime() + " PASS - Section 2.1.4 - (B6) - Valid Focal Document: " + sheet.getRow(5).getCell(1).toString() + " - Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(1).toString() + " is maleformed - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(6).getCell(1).toString();
        System.out.println("Section 2.1.5");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.5 - (B7) - Missing Summary - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.5 - (B7) - Summary Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(7).getCell(1).toString();
        System.out.println("Section 2.1.6");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.6 - (B8) - Missing Target Audience - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.6 - (B8) - Target Audience Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(8).getCell(1).toString();
        System.out.println("Section 2.1.7");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.7 - (B9) - Missing Comprehensive Value - Found Value: " + cellValue;
            ++errorCount;
        } else if (cellValue.equals("Yes") || cellValue.equals("No") || cellValue.equals("Y") || cellValue.equals("N")) {
            report = Utility.getTime() + " PASS - Section 2.1.7 - (B9) - Valid Comprehensive Value";
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.7 - (B9) - Malformed Comprehensive Value";
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(9).getCell(1).toString();
        System.out.println("Section 2.1.8");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.8 - (B10) - Missing Reference Document Author";
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.8 - (B10) - Reference Document Author Found";
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(10).getCell(1).toString();
        System.out.println("Section 2.1.9");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.9 = (B11) - Missing Reference Document - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.9 = (B11) - Reference Document Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(11).getCell(1).toString();
        System.out.println(cellValue);
        if (cellValue.matches("[0-1]?[0-9]\\/[0][0]\\/[1-2][0-9][0-9][0-9]")) {
            System.out.println("Section 2.1.10");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: " + cellValue;
                ++errorCount;
            } else if (cellValue.matches("[0][1]\\/[0][1]\\/[1][9][0][4]")) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: ";
                ++errorCount;
            } else if (cellValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                report = Utility.getTime() + " PASS - Section 2.1.10 = (B12) - Reference Document Date Found - Found Value: " + cellValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Malformed Reference Document Date - Found Value: " + cellValue + " expected MM/DD/YYYY.";
                ++errorCount;
            }
            System.out.println(report);
        } else {
            XSSFCell dateValue = sheet.getRow(11).getCell(1);
            Date dv = dateValue.getDateCellValue();
            String df = dateValue.getCellStyle().getDataFormatString();
            String strValue = new CellDateFormatter(df).format(dv);
            if (strValue.contains(";")) {
                String[] sv = strValue.split(";");
                strValue = sv[0];
            }
            System.out.println("Section 2.1.10");
            if (strValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: " + strValue;
                ++errorCount;
            } else if (strValue.matches("[0][1]\\/[0][1]\\/[1][9][0][4]")) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: ";
                ++errorCount;
            } else if (strValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                report = Utility.getTime() + " PASS - Section 2.1.10 = (B12) - Reference Document Date Found - Found Value: " + strValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Malformed Reference Document Date - Found Value: " + strValue + " expected MM/DD/YYYY.";
                ++errorCount;
            }
            System.out.println(report);
        }
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(12).getCell(1).toString();
        System.out.println("Section 2.1.11");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.11 - (B13) - Missing Reference Document URL - Found Value: " + cellValue;
            ++warningCount;
        } else if (Utility.isValid(cellValue)) {
            report = Utility.getTime() + " PASS - Section 2.1.11 - (B13) - Valid Reference Document URL - Found Value: " + cellValue.replaceAll(" ", "%20");
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.11 - (B13) - Invalid Reference Document URL - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(13).getCell(1).toString();
        System.out.println("Section 2.1.12");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.12 - (B14) - Missing Reference Developer - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.12 - (B14) - Reference Developer Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(14).getCell(1).toString();
        System.out.println("Section 2.1.13");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.13 - (B15) - No comments - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.13 - (B15) - Comments Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(15).getCell(1).toString();
        System.out.println("Section 2.1.14");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.14 - (B16) - Missing Point of Contact - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.14 - (B16) - Point of Contact Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(16).getCell(1).toString();
        System.out.println("Section 2.1.15");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.15 - (B17) - Dependency/Requirement Empty - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.15 - (B17) - Dependency/Requirement Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(17).getCell(1).toString();
        System.out.println("Section 2.1.16");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.16 - (B18) - Citations are Empty - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.16 - (B18) - Citations Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
    }

    private static void csfYpfGen(int shouldHave) throws IOException {
        cellValue = sheet.getRow(2).getCell(1).toString();
        System.out.println("Section 2.1.1");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.1 - (B3) - Informative Reference Name value not present - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.1 - (B3) - Informative Reference Name value present - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(3).getCell(1).toString();
        System.out.println("Section 2.1.2");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value not present - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        } else if (cellValue.matches("([0-9]*)\\.([0-9]*)\\.([0-9]*)")) {
            report = Utility.getTime() + " PASS - Section 2.1.2 - (B4) - Reference Version value present - Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value is malformed - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(4).getCell(1).toString();
        System.out.println("Section 2.1.3");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.3 - (B5) - Web Address not included - Found Value: " + cellValue;
            ++errorCount;
        } else if (Utility.isValid(cellValue)) {
            report = Utility.getTime() + " PASS - Section 2.1.3 - (B5) - Valid Web Address - Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.3 - (B5) - Invalid Web Address - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(5).getCell(1).toString();
        System.out.println("Section 2.1.4");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(0).toString() + " isn't present - Found Value: " + cellValue;
            ++errorCount;
        } else if (cellValue.equals("Cybersecurity Framework v1.1") || cellValue.equals("Privacy Framework v1.0") || cellValue.equals("SP 800-53 Rev. 4") || cellValue.equals("IoT Device Cybersecurity Capability Core Baseline") || cellValue.equals("NIST SP800-171 Revision 2") || cellValue.equals("IoT Non-Technical Supporting Capability Core Baseline") || cellValue.trim().equals("NIST SP 800-213A") || cellValue.trim().equals("SP 800-218 Secure Software Development Framework (SSDF) Version 1.1:\nRecommendations for Mitigating the Risk of Software Vulnerabilities") || cellValue.trim().equals("Recommended Criteria for Cybersecurity Labeling for Consumer Internet of Things (IoT) Products") || cellValue.equals("SP 800-181 (2017)") || cellValue.equals("SP800-221A")) {
            report = Utility.getTime() + " PASS - Section 2.1.4 - (B6) - Valid Focal Document. Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(0).toString() + " is maleformed - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(6).getCell(1).toString();
        System.out.println("Section 2.1.5");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.5 - (B7) - Missing Summary - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.5 - (B7) - Summary Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(7).getCell(1).toString();
        System.out.println("Section 2.1.6");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.6 - (B8) - Missing Target Audience - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.6 - (B8) - Target Audience Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(8).getCell(1).toString();
        System.out.println("Section 2.1.7");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.7 - (B9) - Missing Comprehensive Value - Found Value: " + cellValue;
            ++errorCount;
        } else if (cellValue.equals("Yes") || cellValue.equals("No") || cellValue.equals("Y") || cellValue.equals("N")) {
            report = Utility.getTime() + " PASS - Section 2.1.7 - (B9) - Valid Comprehensive Value";
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.7 - (B9) - Malformed Comprehensive Value";
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(9).getCell(1).toString();
        System.out.println("Section 2.1.8");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.8 - (B10) - Missing Reference Document Author";
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.8 - (B10) - Reference Document Author Found";
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(10).getCell(1).toString();
        System.out.println("Section 2.1.9");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.9 = (B11) - Missing Reference Document - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.9 = (B11) - Reference Document Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(11).getCell(1).toString();
        if (cellValue.matches("[0-1][0-9]\\/[0][0]\\/[1-2][0-9][0-9][0-9]")) {
            System.out.println("Section 2.1.10");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: " + cellValue;
                ++errorCount;
            } else if (cellValue.matches("[0][1]\\/[0][1]\\/[1][9][0][4]")) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: ";
                ++errorCount;
            } else if (cellValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                report = Utility.getTime() + " PASS - Section 2.1.10 = (B12) - Reference Document Date Found - Found Value: " + cellValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Malformed Reference Document Date - Found Value: " + cellValue + " expected MM/DD/YYYY.";
                ++errorCount;
            }
            System.out.println(report);
        } else {
            String strValue;
            XSSFCell dateValue = sheet.getRow(11).getCell(1);
            if (((Object)dateValue).toString().matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                strValue = ((Object)dateValue).toString();
            } else {
                String df = dateValue.getCellStyle().getDataFormatString();
                Date dv = dateValue.getDateCellValue();
                strValue = new CellDateFormatter(df).format(dv);
            }
            if (strValue.contains(";")) {
                String[] sv = strValue.split(";");
                strValue = sv[0];
            }
            System.out.println("Section 2.1.10");
            if (strValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: " + strValue;
                ++errorCount;
            } else if (strValue.matches("[0][1]\\/[0][1]\\/[1][9][0][4]")) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Missing Reference Document Date - Found Value: ";
                ++errorCount;
            } else if (strValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                report = Utility.getTime() + " PASS - Section 2.1.10 = (B12) - Reference Document Date Found - Found Value: " + strValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B12) - Malformed Reference Document Date - Found Value: " + strValue + " expected MM/DD/YYYY.";
                ++errorCount;
            }
            System.out.println(report);
        }
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(12).getCell(1).toString();
        System.out.println("Section 2.1.11");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.11 - (B13) - Missing Reference Document URL - Found Value: " + cellValue;
            ++errorCount;
        } else if (Utility.isValid(cellValue)) {
            report = Utility.getTime() + " PASS - Section 2.1.11 - (B13) - Valid Reference Document URL - Found Value: " + cellValue.replaceAll(" ", "%20");
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.11 - (B13) - Invalid Reference Document URL - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(13).getCell(1).toString();
        System.out.println("Section 2.1.12");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.12 - (B14) - Missing Reference Developer - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.12 - (B14) - Reference Developer Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(14).getCell(1).toString();
        System.out.println("Section 2.1.13");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.13 - (B15) - No comments - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.13 - (B15) - Comments Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(15).getCell(1).toString();
        System.out.println("Section 2.1.14");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.14 - (B16) - Missing Point of Contact - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.14 - (B16) - Point of Contact Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        if (!sheet.getRow(5).getCell(1).toString().equals("Profile of the IoT Core Baseline for Consumer IoT Products ")) {
            cellValue = sheet.getRow(16).getCell(1).toString();
            System.out.println("Section 2.1.15");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.15 - (B17) - Dependency/Requirement Empty - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.15 - (B17) - Dependency/Requirement Found  - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
            cellValue = sheet.getRow(17).getCell(1).toString();
            System.out.println("Section 2.1.16");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.16 - (B18) - Citations are Empty - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.16 - (B18) - Citations Found  - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
        } else {
            cellValue = sheet.getRow(16).getCell(1).toString();
            System.out.println("Section 2.1.16");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " WARNING - Section 2.1.16 - (B18) - Citations are Empty - Found Value: " + cellValue;
                ++warningCount;
            } else {
                report = Utility.getTime() + " PASS - Section 2.1.16 - (B18) - Citations Found  - Found Value: " + cellValue;
                ++passCount;
            }
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    private static void ehgen(int shouldHave) throws IOException {
        cellValue = sheet.getRow(2).getCell(1).toString();
        System.out.println("Section 2.1.1");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.1 - (B3) - Informative Reference Name value not present - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.1 - (B3) - Informative Reference Name value present - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(3).getCell(1).toString();
        System.out.println("Section 2.1.2");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value not present - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        } else if (cellValue.matches("([0-9]*)\\.([0-9]*)\\.([0-9]*)")) {
            report = Utility.getTime() + " PASS - Section 2.1.2 - (B4) - Reference Version value present - Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.2 - (B4) - Reference Version value is malformed - Found Value: " + cellValue;
            ++errorCount;
            ++failCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(4).getCell(1).toString();
        System.out.println("Section 2.1.3");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.3 - (B5) - Web Address not included - Found Value: " + cellValue;
            ++warningCount;
        } else if (Utility.isValid(cellValue)) {
            report = Utility.getTime() + " PASS - Section 2.1.3 - (B5) - Valid Web Address - Found Value: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.3 - (B5) - Invalid Web Address - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(5).getCell(1).toString();
        System.out.println("Section 2.1.4");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(1).toString() + " isn't present - Found Value: " + cellValue;
            ++errorCount;
        } else if (cellValue.equals("Cybersecurity Framework v1.1") || cellValue.equals("Privacy Framework v1.0") || cellValue.equals("SP 800-53 Rev. 4") || cellValue.equals("800-53 Rev. 5") || cellValue.equals("IoT Device Cybersecurity Capability Core Baseline") || cellValue.equals("IoT Non-Technical Supporting Capability Core Baseline") || cellValue.trim().equals("SP 800-218 Secure Software Development Framework (SSDF) Version 1.1:\nRecommendations for Mitigating the Risk of Software Vulnerabilities") || cellValue.trim().equals("NIST SP 800-213A") || cellValue.trim().equals("Recommended Criteria for Cybersecurity Labeling for Consumer Internet of Things (IoT) Products")) {
            report = Utility.getTime() + " PASS - Section 2.1.4 - (B6) - Valid Focal Document: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.4 - (B6) - Focal Document: " + sheet.getRow(5).getCell(1).toString() + " is maleformed - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(6).getCell(1).toString();
        System.out.println("Section 2.1.4.1");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.? - (B7) - Security Control Baseline: " + sheet.getRow(6).getCell(0).toString() + " isn't present - Found Value: " + cellValue;
            ++errorCount;
        } else if (cellValue.equals("Low") || cellValue.equals("Moderate") || cellValue.equals("High") || cellValue.equals("Not Associated")) {
            report = Utility.getTime() + " PASS - Section 2.1.? - (B7) - Valid Security Conrol Baseline: " + cellValue;
            ++passCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.? - (B7) - Valid Security Control Baseline: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(7).getCell(1).toString();
        System.out.println("Section 2.1.5");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.5 - (B8) - Missing Summary - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.5 - (B8) - Summary Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(8).getCell(1).toString();
        System.out.println("Section 2.1.6");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.6 - (B9) - Missing Target Audience - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = cellValue.length() < 80 ? Utility.getTime() + " PASS - Section 2.1.6 - (B9) - Target Audience Found - Found Value: " + cellValue : Utility.getTime() + " PASS - Section 2.1.6 - (B9) - Target Audience Found - Found Value: " + cellValue.substring(0, 80);
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(9).getCell(1).toString();
        System.out.println("Section 2.1.7");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.7 - (B10) - Missing Comprehensive Value - Found Value: " + cellValue;
            ++errorCount;
        } else if (cellValue.equals("Yes") || cellValue.equals("No") || cellValue.equals("Y") || cellValue.equals("N")) {
            report = Utility.getTime() + " PASS - Section 2.1.7 - (B10) - Valid Comprehensive Value";
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.7 - (B10) - Malformed Comprehensive Value";
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(10).getCell(1).toString();
        System.out.println("Section 2.1.8");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.8 - (B11) - Missing Reference Document Author";
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.8 - (B11) - Reference Document Author Found";
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(11).getCell(1).toString();
        System.out.println("Section 2.1.9");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.9 = (B12) - Missing Reference Document - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.9 = (B12) - Reference Document Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(12).getCell(1).toString();
        if (cellValue.matches("[0-1][0-9]\\/[0][0]\\/[1-2][0-9][0-9][0-9]")) {
            System.out.println("Section 2.1.10");
            if (cellValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B13) - Missing Reference Document Date - Found Value: " + cellValue;
                ++errorCount;
            } else if (cellValue.matches("[0][1]\\/[0][1]\\/[1][9][0][4]")) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B13) - Missing Reference Document Date - Found Value: ";
                ++errorCount;
            } else if (cellValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                report = Utility.getTime() + " PASS - Section 2.1.10 = (B13) - Reference Document Date Found - Found Value: " + cellValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B13) - Malformed Reference Document Date - Found Value: " + cellValue + " expected MM/DD/YYYY.";
                ++errorCount;
            }
            System.out.println(report);
        } else {
            XSSFCell dateValue = sheet.getRow(12).getCell(1);
            Date dv = dateValue.getDateCellValue();
            String df = dateValue.getCellStyle().getDataFormatString();
            String strValue = new CellDateFormatter(df).format(dv);
            if (strValue.contains(";")) {
                String[] sv = strValue.split(";");
                strValue = sv[0];
            }
            System.out.println("Section 2.1.10");
            if (strValue.isEmpty()) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B13) - Missing Reference Document Date - Found Value: " + strValue;
                ++errorCount;
            } else if (strValue.matches("[0][1]\\/[0][1]\\/[1][9][0][4]")) {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B13) - Missing Reference Document Date - Found Value: ";
                ++errorCount;
            } else if (strValue.matches("[0-1][0-9]\\/[0-3][0-9]\\/[1-2][0-9][0-9][0-9]")) {
                report = Utility.getTime() + " PASS - Section 2.1.10 = (B13) - Reference Document Date Found - Found Value: " + strValue;
                ++passCount;
            } else {
                report = Utility.getTime() + " ERROR - Section 2.1.10 = (B13) - Malformed Reference Document Date - Found Value: " + strValue + " expected MM/DD/YYYY.";
                ++errorCount;
            }
            System.out.println(report);
        }
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(13).getCell(1).toString();
        System.out.println("Section 2.1.11");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.11 - (B14) - Missing Reference Document URL - Found Value: " + cellValue;
            ++warningCount;
        } else if (Utility.isValid(cellValue)) {
            report = Utility.getTime() + " PASS - Section 2.1.11 - (B14) - Valid Reference Document URL - Found Value: " + cellValue.replaceAll(" ", "%20");
            ++passCount;
        } else {
            report = Utility.getTime() + " ERROR - Section 2.1.11 - (B14) - Invalid Reference Document URL - Found Value: " + cellValue;
            ++errorCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(14).getCell(1).toString();
        System.out.println("Section 2.1.12");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.12 - (B15) - Missing Reference Developer - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.12 - (B15) - Reference Developer Found - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(15).getCell(1).toString();
        System.out.println("Section 2.1.13");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.13 - (B16) - No comments - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.13 - (B16) - Comments Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(16).getCell(1).toString();
        System.out.println("Section 2.1.14");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " ERROR - Section 2.1.14 - (B17) - Missing Point of Contact - Found Value: " + cellValue;
            ++errorCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.14 - (B17) - Point of Contact Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(17).getCell(1).toString();
        System.out.println("Section 2.1.15");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.15 - (B18) - Dependency/Requirement Empty - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.15 - (B18) - Dependency/Requirement Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
        cellValue = sheet.getRow(18).getCell(1).toString();
        System.out.println("Section 2.1.16");
        if (cellValue.isEmpty()) {
            report = Utility.getTime() + " WARNING - Section 2.1.16 - (B19) - Citations are Empty - Found Value: " + cellValue;
            ++warningCount;
        } else {
            report = Utility.getTime() + " PASS - Section 2.1.16 - (B19) - Citations Found  - Found Value: " + cellValue;
            ++passCount;
        }
        System.out.println(report);
        ReportCreation.writeFile(report);
    }
}

