/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class ExControlAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private int _id;

    protected ExControlAtom() {
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, 4);
    }

    protected ExControlAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._id = LittleEndian.getInt(source, start + 8);
    }

    public int getSlideId() {
        return this._id;
    }

    public long getRecordType() {
        return RecordTypes.ExControlAtom.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        byte[] data = new byte[4];
        LittleEndian.putInt((byte[])data, (int)this._id);
        out.write(data);
    }
}

