/*
 * Decompiled with CFR 0.152.
 */
package com.IR8278;

import com.IR8278.App;
import com.IR8278.ReportCreation;
import com.IR8278.Utility;
import com.IR8278.ValidationTests;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class CSFRelationshipsTab
extends ValidationTests {
    static List<String> fed = new ArrayList<String>();
    static List<String> fe = new ArrayList<String>();
    private static boolean hasAMatch = false;
    private static boolean fullFlag = false;

    protected static void focalElementList() throws IOException {
        String file;
        InputStream is = null;
        if (CSFRelationshipsTab.whatDocuType().equals("CSF 1.1")) {
            file = "resources/frameworkElement.txt";
            is = App.class.getResourceAsStream("/frameworkElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("PF")) {
            file = "resources/privacyFrameworkElement.txt";
            is = App.class.getResourceAsStream("/privacyFrameworkElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("IoT")) {
            file = "resources/IoTElement.txt";
            is = App.class.getResourceAsStream("/IoTElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("800-171 Rev 2")) {
            file = "resources/800-171R2Element.txt";
            is = App.class.getResourceAsStream("/800-171R2Element.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("NISTIR 8259B")) {
            file = "resources/8259BElement.txt";
            is = App.class.getResourceAsStream("/8259BElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("SSDF")) {
            file = "resources/SSDFptElement.txt";
            is = App.class.getResourceAsStream("/SSDFptElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("ConsumerIoT")) {
            file = "resources/ConIoTElement.txt";
            is = App.class.getResourceAsStream("/ConIoTElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("SP800-221A")) {
            file = "resources/221AElement.txt";
            is = App.class.getResourceAsStream("/221AElement.txt");
        }
        CSFRelationshipsTab.connectExcelSecond();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        line = reader.readLine();
        boolean trueCount = false;
        while (line != null) {
            fe.add(line);
            line = reader.readLine();
        }
        reader.close();
    }

    protected static void focalEleDescList() throws IOException {
        String file;
        InputStream is = null;
        if (CSFRelationshipsTab.whatDocuType().equals("CSF 1.1")) {
            file = "resources/frameworkElementDescription.txt";
            is = App.class.getResourceAsStream("/frameworkElementDescription.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("PF")) {
            file = "resources/privacyFrameworkElementDescription.txt";
            is = App.class.getResourceAsStream("/privacyFrameworkElementDescription.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("IoT")) {
            file = "resources/IoTDescription.txt";
            is = App.class.getResourceAsStream("/IoTDescription.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("800-171 Rev 2")) {
            file = "resources/800-171R2Description.txt";
            is = App.class.getResourceAsStream("/800-171R2Description.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("NISTIR 8259B")) {
            file = "resources/8259BDescription.txt";
            is = App.class.getResourceAsStream("/8259BDescription.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("SSDF")) {
            file = "resources/SSDFptDesc.txt";
            is = App.class.getResourceAsStream("/SSDFptDesc.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("ConsumerIoT")) {
            file = "resources/ConIoTDesc.txt";
            is = App.class.getResourceAsStream("/ConIoTDesc.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("SP800-221A")) {
            file = "resources/221ADesc.txt";
            is = App.class.getResourceAsStream("/221ADesc.txt");
        }
        CSFRelationshipsTab.connectExcelSecond();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Object matchValue = null;
        String line = reader.readLine().trim();
        String noSpace = "";
        boolean fail = false;
        boolean trueCount = false;
        while (line != null) {
            fed.add(line);
            line = reader.readLine();
        }
        reader.close();
    }

    protected static void focalDocEleYDesc() throws IOException {
        CSFRelationshipsTab.focalElementList();
        CSFRelationshipsTab.focalEleDescList();
        String focalDescrip = null;
        boolean failFED = false;
        boolean failFE = false;
        System.out.println("Section 2.2.1 and 2.2.2");
        report = "Section 2.2.1 and 2.2.2" + System.getProperty("line.separator") + "Validating the columns A and B";
        ReportCreation.writeFile(report);
        ReportCreation.writeFile2(report);
        for (int j = 1; j < rows; ++j) {
            int trueCount = 0;
            hasAMatch = false;
            String focalElement = Utility.isCellEmpty(sheet.getRow(j).getCell(0), j);
            for (int k = 0; k < fe.size(); ++k) {
                if (fe.get(k).equals(focalElement)) {
                    hasAMatch = true;
                    ++trueCount;
                    focalDescrip = Utility.isCellEmpty(sheet.getRow(j).getCell(1), j);
                    focalDescrip = focalDescrip.replaceAll("(^\\h*)|(\\h*$)", "").trim();
                    focalDescrip = focalDescrip.replaceAll("[^\\x00-\\x7F]", "").trim();
                    focalDescrip = focalDescrip.replaceAll("\u00ed", "\u2019").replace("/n", "").replace("/r", "").replaceAll("\\t", "").replace(System.getProperty("line.separator"), "");
                    focalDescrip = CSFRelationshipsTab.cleanTextContent(focalDescrip);
                    String testFocalDesc = CSFRelationshipsTab.cleanTextContent(fed.get(k).trim());
                    if ((testFocalDesc = testFocalDesc.replace("/n", "").replace("/r", "").replace(System.getProperty("line.separator"), "").replaceAll("\\t", "")).equals(focalDescrip)) {
                        hasAMatch = true;
                        ++trueCount;
                        continue;
                    }
                    System.out.println("In description else false.");
                    System.out.println("P value: " + focalDescrip);
                    System.out.println("Description Array Value: " + focalDescrip);
                    System.out.println("M value: " + testFocalDesc);
                    System.out.println("Description Value in Template: " + testFocalDesc);
                    hasAMatch = false;
                    failFED = true;
                    continue;
                }
                hasAMatch = false;
                failFE = true;
            }
            int t = j + 1;
            if (trueCount >= 1) {
                report = Utility.getTime() + " PASS - Section 2.2.1 - (A" + t + ") - Valid Focal Document Element value - Found Value: " + focalElement;
                report = report.concat(System.getProperty("line.separator"));
                ++passCount;
                if (!failFED) {
                    report = report.concat(" PASS - Section 2.2.2 - (B" + t + ") - Valid Focal Document Element Description value - Found Value: " + focalDescrip);
                    report = report.concat(System.getProperty("line.separator"));
                    ++passCount;
                } else {
                    report = report.concat(" ERROR - Section 2.2.2 - (B" + t + ") - Invalid Focal Document Element Description value - Found Value: " + focalDescrip);
                    report = report.concat(System.getProperty("line.separator"));
                    ++errorCount;
                }
                System.out.println(report);
                ReportCreation.writeFile(report);
            } else if (Utility.notRelated(sheet.getRow(j).getCell(3)).equalsIgnoreCase("true")) {
                report = Utility.getTime() + " PASS - Section 2.2.1 and 2.2.2 - (A" + t + ") - Relationship Value is Not Related To";
                ++passCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
            } else if (trueCount == 0 && rows >= t) {
                report = Utility.getTime() + " ERROR - Section 2.2.1 - (A" + t + ") - Invalid Focal Document Element value - Found Value: " + focalElement + ".";
                report = report.concat(System.getProperty("line.separator"));
                ++errorCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
            } else if (Utility.notRelated(sheet.getRow(j).getCell(3)).equalsIgnoreCase("extra") && rows >= t) {
                report = Utility.getTime() + " PASS - Section 2.2.1 - (A" + t + ") - Relationship Value is Not Related To";
                ++passCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
            } else if (rows >= t) {
                report = Utility.getTime() + " ERROR - Section 2.2.1 - (A" + t + ") - Invalid Focal Document Element value - Found Value: " + focalElement + ".";
                report = report.concat(System.getProperty("line.separator"));
                ++errorCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
            }
            failFE = false;
            failFED = false;
        }
    }

    protected static void rationalValidation() throws IOException {
        CSFRelationshipsTab.connectExcelSecond();
        System.out.println("Section 2.2.3");
        for (int j = 1; j < rows; ++j) {
            int k = j + 1;
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(j).getCell(0), sheet.getRow(j).getCell(1), sheet.getRow(j).getCell(2), sheet.getRow(j).getCell(3), sheet.getRow(j).getCell(4), sheet.getRow(j).getCell(6), null, j, 2);
            cellValue = Utility.isCellEmpty(sheet.getRow(j).getCell(2), j);
            if (check) {
                if (!cellValue.isEmpty()) {
                    if (cellValue.equalsIgnoreCase("Functional")) {
                        report = Utility.getTime() + " PASS - Section 2.2.3 - (C" + k + ") - Valid Rationale Value - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equalsIgnoreCase("Semantic")) {
                        report = Utility.getTime() + " PASS - Section 2.2.3 - (C" + k + ") - Valid Rationale Value - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equalsIgnoreCase("Syntactic")) {
                        report = Utility.getTime() + " PASS - Section 2.2.3 - (C" + k + ") - Valid Rationale Value - Found Value: " + cellValue;
                        ++passCount;
                    } else if (!("Functional".equals(cellValue) && "Semantic".equals(cellValue) && "Syntactic".equals(cellValue) || cellValue.trim().length() == 0)) {
                        report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid rationale value - Found Value: " + cellValue;
                        ++errorCount;
                    } else if (!("functional".equals(cellValue) && "semantic".equals(cellValue) && "syntactic".equals(cellValue) || cellValue.trim().length() == 0)) {
                        report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid rationale value - Found Value: " + cellValue;
                        ++errorCount;
                    } else {
                        report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Rationale value missing - Found Value: " + cellValue;
                        ++errorCount;
                    }
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Rationale value missing - Found Value: " + cellValue;
                    ++errorCount;
                }
            } else if (!check && !cellValue.isEmpty()) {
                if (cellValue.equalsIgnoreCase("Functional")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                } else if (cellValue.equalsIgnoreCase("Semantic")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                } else if (cellValue.equalsIgnoreCase("Syntactic")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                } else if (!("Functional".equals(cellValue) && "Semantic".equals(cellValue) && "Syntactic".equals(cellValue) || cellValue.trim().length() == 0)) {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid rationale value - Found Value: " + cellValue;
                    ++errorCount;
                } else if (!("functional".equals(cellValue) && "semantic".equals(cellValue) && "syntactic".equals(cellValue) || cellValue.trim().length() == 0)) {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid rationale value - Found Value: " + cellValue;
                    ++errorCount;
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.2.3 - (C" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Rationale value missing - Found Value: " + cellValue;
                    ++errorCount;
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    protected static void relationshipValidation() throws IOException {
        CSFRelationshipsTab.connectExcelSecond();
        System.out.println("Section 2.2.4");
        for (int j = 1; j < rows; ++j) {
            String fullfilValue;
            int k = j + 1;
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(j).getCell(0), sheet.getRow(j).getCell(1), sheet.getRow(j).getCell(2), sheet.getRow(j).getCell(3), sheet.getRow(j).getCell(4), sheet.getRow(j).getCell(6), null, j, 3);
            cellValue = Utility.isCellEmpty(sheet.getRow(j).getCell(3), j);
            if (check) {
                if (!cellValue.isEmpty()) {
                    String group;
                    if (cellValue.equalsIgnoreCase("subset of")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(6), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        System.out.println("This is the 2.2.4 Section Group: " + group);
                        if (fullfilValue.equalsIgnoreCase("Y") || fullfilValue.equalsIgnoreCase("Yes")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            fullFlag = true;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Subset of' then Fulfills Value must be 'Y' - Found Value: " + cellValue;
                            fullFlag = false;
                            ++errorCount;
                        }
                    } else if (cellValue.equalsIgnoreCase("intersects with")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(6), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        System.out.println("This is the 2.2.4 Section Group: " + group);
                        if (group.equals("") && fullfilValue.equalsIgnoreCase("N")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            fullFlag = false;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Intersects With' then Fulfills Value must be 'N' unless there is a Group Identifier - Found Value: " + cellValue;
                            fullFlag = true;
                            ++errorCount;
                        }
                    } else if (cellValue.equalsIgnoreCase("equal to") || cellValue.equalsIgnoreCase("equal")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(6), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        System.out.println("This is the 2.2.4 Section Group: " + group);
                        if (fullfilValue.equalsIgnoreCase("Y") || fullfilValue.equalsIgnoreCase("Yes")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            fullFlag = true;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Equal' then Fulfills Value must be 'Y' - Found Value: " + cellValue;
                            fullFlag = false;
                            ++errorCount;
                        }
                    } else if (cellValue.equalsIgnoreCase("superset of")) {
                        String fulfillValue = Utility.isCellEmpty(sheet.getRow(j).getCell(6), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        System.out.println("This is the 2.2.4 Section Group: " + group);
                        if (group.equals("") && fulfillValue.equalsIgnoreCase("N")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            fullFlag = false;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Superset Of' then Fulfills Value must be 'N' unless there is a Group Identifier - Found Value: " + cellValue;
                            fullFlag = true;
                            ++errorCount;
                        }
                    } else if (cellValue.equalsIgnoreCase("not related to")) {
                        fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(6), j);
                        group = Utility.isCellEmpty(sheet.getRow(j).getCell(7), j);
                        System.out.println("This is the 2.2.4 Section Group: " + group);
                        if (fullfilValue.equalsIgnoreCase("N") || fullfilValue.equalsIgnoreCase("No")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            fullFlag = false;
                            ++passCount;
                        } else if (!group.equalsIgnoreCase("")) {
                            report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Not Related To' then Fulfills Value must be 'No' or 'N' - Found Value: " + cellValue;
                            fullFlag = true;
                            ++errorCount;
                        }
                    } else if (cellValue.equalsIgnoreCase("")) {
                        report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Relationship Element missing - Found Value: " + cellValue;
                        ++errorCount;
                    } else {
                        report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid Relationship Element value - Found Value: " + cellValue;
                        ++errorCount;
                    }
                } else if (cellValue.trim().length() != 0) {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - Relationship Element missing - Found Value: " + cellValue;
                    ++errorCount;
                }
            } else if (cellValue.equalsIgnoreCase("not related to")) {
                fullfilValue = Utility.isCellEmpty(sheet.getRow(j).getCell(6), j);
                if (fullfilValue.equalsIgnoreCase("N") || fullfilValue.equalsIgnoreCase("No")) {
                    report = Utility.getTime() + " PASS - Section 2.2.4 - (D" + k + ") - Valid Relationship Element value - Found Value: " + cellValue;
                    fullFlag = false;
                    ++passCount;
                } else {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (D" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - If Relationship Element Value is 'Not Related To' then Fulfills Value must be 'No' or 'N' - Found Value: " + cellValue;
                    fullFlag = true;
                    ++errorCount;
                }
            } else if (!check && !cellValue.isEmpty()) {
                if (cellValue.equals("subset of")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                } else if (cellValue.equals("intersects with")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                } else if (cellValue.equalsIgnoreCase("equal to") || cellValue.equalsIgnoreCase("equal")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                } else if (cellValue.equals("superset of")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                } else if (cellValue.equals("not related to")) {
                    report = Utility.getTime() + " ERROR - Section 2.2.4 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " Row Number: " + k + " - Missing required columns - Found Value: " + cellValue;
                    ++errorCount;
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    protected static void referenceDocumentValidation() throws IOException {
        CSFRelationshipsTab.connectExcelSecond();
        System.out.println("Section 2.2.5");
        for (int i = 1; i < rows; ++i) {
            int j;
            String pattern = "([a-zA-Z0-9]*\\.)*([0-9]*)";
            String pattern2 = "([a-zA-Z0-9]*\\-)*([0-9]*)";
            int k = i + 1;
            report = Utility.reportClear();
            boolean checks = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), null, i, 1);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(4), i);
            if (checks) {
                if (!cellValue.isEmpty()) {
                    report = Utility.getTime() + " PASS - Section 2.2.5 - (E" + k + ") - Populated Reference Element Value - Found Value: " + cellValue;
                    ++passCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                    continue;
                }
                j = k - 1;
                report = Utility.getTime() + " ERROR - Section 2.2.5 - (E" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Missing Reference Element Value - Found Value: " + cellValue;
                ++errorCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
                continue;
            }
            if (!checks && !Utility.isCellEmpty(sheet.getRow(i).getCell(4), i).isEmpty()) {
                if (!cellValue.isEmpty()) {
                    report = Utility.getTime() + " PASS - Section 2.2.5 - (E" + k + ") - Populated Reference Element Value - Found Value: " + cellValue;
                    ++passCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                    continue;
                }
                j = k - 1;
                report = Utility.getTime() + " ERROR - Section 2.2.5 - (E" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Missing Reference Element Value - Found Value: " + cellValue;
                ++errorCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
                continue;
            }
            if (Utility.notRelated(sheet.getRow(i).getCell(3)).equalsIgnoreCase("true")) {
                report = Utility.getTime() + " PASS - Section 2.2.5 - (E" + k + ") - Relationship Value is Not Related To";
                ++passCount;
                System.out.println(report);
                ReportCreation.writeFile(report);
                continue;
            }
            if (!Utility.notRelated(sheet.getRow(i).getCell(3)).equalsIgnoreCase("extra")) continue;
        }
    }

    protected static void referenceDescriptorValidation() throws IOException {
        CSFRelationshipsTab.connectExcelSecond();
        System.out.println("Section 2.2.6");
        for (int i = 1; i < rows; ++i) {
            int j;
            int k = i + 1;
            report = Utility.reportClear();
            boolean refDoc = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), null, i, 1);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(5), i);
            if (refDoc) {
                if (cellValue.isEmpty()) {
                    j = k - 1;
                    report = Utility.getTime() + " WARNING - Section 2.2.6 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - No Descriptor Value";
                    ++warningCount;
                } else if (cellValue.equalsIgnoreCase("No mapping")) {
                    j = k - 1;
                    report = Utility.getTime() + " WARNING - Section 2.2.6 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - No Descriptor Value";
                    ++warningCount;
                } else {
                    report = Utility.getTime() + " PASS - Section 2.2.6 - (F" + k + ") - Description Exists";
                    ++passCount;
                }
            } else if (!refDoc && !Utility.isCellEmpty(sheet.getRow(i).getCell(4), i).isEmpty()) {
                if (!cellValue.isEmpty()) {
                    report = Utility.getTime() + " PASS - Section 2.2.5 - (E" + k + ") - Populated Reference Element Value - Found Value: " + cellValue;
                    ++passCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                } else {
                    j = k - 1;
                    report = Utility.getTime() + " ERROR - Section 2.2.5 - (E" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Missing Reference Element Value - Found Value: " + cellValue;
                    ++errorCount;
                    System.out.println(report);
                    ReportCreation.writeFile(report);
                }
            } else if (cellValue.equalsIgnoreCase("No mapping")) {
                j = k - 1;
                report = Utility.getTime() + " WARNING - Section 2.2.6 - (F" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - No Descriptor Value";
                ++warningCount;
            } else if (cellValue.isEmpty() && Utility.notRelated(sheet.getRow(i).getCell(3)).equalsIgnoreCase("true")) {
                j = k - 1;
                report = Utility.getTime() + " PASS - Section 2.2.6 - (F" + k + ") - Found \"Not Related To\" in the Relationship Column";
                ++passCount;
            } else if (!cellValue.isEmpty() || !Utility.notRelated(sheet.getRow(i).getCell(3)).equalsIgnoreCase("extra")) {
                if (cellValue.isEmpty()) {
                    j = k - 1;
                    report = Utility.getTime() + " WARNING - Section 2.2.6 - (F" + k + ") - Relationship Value is Not Related To.";
                    ++warningCount;
                } else if (Utility.notRelated(sheet.getRow(i).getCell(3)).equalsIgnoreCase("true")) {
                    report = Utility.getTime() + " PASS - Section 2.2.6 - (F" + k + ") - Relationship Value is Not Related To.";
                    ++passCount;
                } else if (Utility.notRelated(sheet.getRow(i).getCell(3)).equalsIgnoreCase("extra")) {
                    // empty if block
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    protected static void fullfillValidation() throws Exception, NullPointerException {
        CSFRelationshipsTab.connectExcelSecond();
        System.out.println("Section 2.2.7");
        for (int i = 1; i < rows; ++i) {
            String nrt;
            int k = i + 1;
            report = Utility.reportClear();
            String relationshipValue = Utility.isCellEmpty(sheet.getRow(i).getCell(3), i);
            String groupValue = Utility.isCellEmpty(sheet.getRow(i).getCell(7), i);
            boolean check = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), null, i, 5);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(6), i);
            if (check) {
                if (!cellValue.isEmpty()) {
                    if (cellValue.equalsIgnoreCase("Y") && (relationshipValue.equalsIgnoreCase("subset of") || relationshipValue.equalsIgnoreCase("equal to") || relationshipValue.equalsIgnoreCase("equal"))) {
                        report = Utility.getTime() + " PASS - Section 2.2.7 - (G" + k + ") - Valid Fulfills - Found Value: " + cellValue;
                        ++passCount;
                    } else if (!groupValue.isEmpty()) {
                        report = Utility.getTime() + " PASS - Section 2.2.7 - (G" + k + ") - Valid Fulfills due to Group Id - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equalsIgnoreCase("N") && (relationshipValue.equalsIgnoreCase("intersects with") || relationshipValue.equalsIgnoreCase("not related to") || relationshipValue.equalsIgnoreCase("superset of"))) {
                        report = Utility.getTime() + " PASS - Section 2.2.7 - (G" + k + ") - Valid Fulfills - Found Value: " + cellValue;
                        ++passCount;
                    } else if (cellValue.equals("")) {
                        int j = k - 1;
                        report = Utility.getTime() + " ERROR - Section 2.2.7 - (G" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Missing Fulfills value - Found Value: " + cellValue;
                        ++errorCount;
                    } else {
                        int j = k - 1;
                        report = Utility.getTime() + " ERROR - Section 2.2.7 - (G" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid Fulfills value - Found Value: " + cellValue;
                        ++errorCount;
                    }
                } else {
                    int j = k - 1;
                    report = Utility.getTime() + " ERROR - Section 2.2.7 - (G" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Fulfills value missing - Found Value: " + cellValue;
                    ++errorCount;
                }
            } else if (cellValue.trim().length() != 0 && (nrt = Utility.isCellEmpty(sheet.getRow(i).getCell(3), i)).equalsIgnoreCase("not related to")) {
                int j = k - 1;
                report = Utility.getTime() + " WARNING - Section 2.2.7 - (G" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Found \"Not Related To\" in the Relationship Column in Row: " + k + "  - Found Fulfills Value: " + cellValue;
                ++warningCount;
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            ReportCreation.writeFile(report);
        }
    }

    public static void groupValidation() throws IOException {
        String file;
        InputStream is = null;
        if (CSFRelationshipsTab.whatDocuType().equals("CSF 1.1")) {
            file = "resources/frameworkElement.txt";
            is = App.class.getResourceAsStream("/frameworkElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("PF")) {
            file = "resources/privacyFrameworkElement.txt";
            is = App.class.getResourceAsStream("/privacyFrameworkElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("IoT")) {
            file = "resources/IoTElement.txt";
            is = App.class.getResourceAsStream("/IoTElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("800-171 Rev 2")) {
            file = "resources/800-171R2Element.txt";
            is = App.class.getResourceAsStream("/800-171R2Element.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("NISTIR 8259B")) {
            file = "resources/8259BElement.txt";
            is = App.class.getResourceAsStream("/8259BElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("SSDF")) {
            file = "resources/SSDFptElement.txt";
            is = App.class.getResourceAsStream("/SSDFptElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("ConsumerIoT")) {
            file = "resources/ConIoTElement.txt";
            is = App.class.getResourceAsStream("/ConIoTElement.txt");
        } else if (CSFRelationshipsTab.whatDocuType().equals("SP800-221A")) {
            file = "resources/221AElement.txt";
            is = App.class.getResourceAsStream("/221AElement.txt");
        }
        CSFRelationshipsTab.connectExcelSecond();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> fe = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            fe.add(line);
            line = reader.readLine();
        }
        reader.close();
        int count = 0;
        System.out.println("Section 2.2.8");
        for (int i = 1; i < rows; ++i) {
            int k = i + 1;
            report = Utility.reportClear();
            boolean check = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), null, i, 1);
            XSSFRow row = sheet.getRow(i);
            XSSFCell cell = row.getCell(7);
            cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(7), i);
            if (!check) continue;
            if (!cellValue.equalsIgnoreCase("") && cell.getCellTypeEnum() == CellType.FORMULA) {
                switch (cell.getCachedFormulaResultTypeEnum()) {
                    case BOOLEAN: {
                        System.out.println("Group Boolean Value:  " + cell.getBooleanCellValue());
                        break;
                    }
                    case NUMERIC: {
                        System.out.println("Group Numeric Value:  " + cell.getNumericCellValue());
                        break;
                    }
                    case STRING: {
                        cellValue = String.valueOf(cell.getRichStringCellValue());
                    }
                }
            }
            if (!cellValue.isEmpty()) {
                if (cellValue.contains(":")) {
                    int j;
                    Scanner scan = new Scanner(cellValue);
                    Scanner scan2 = new Scanner(cellValue).useDelimiter(":");
                    String frameElement = scan2.next();
                    System.out.println("frame element: " + frameElement);
                    String group = scan2.next();
                    for (j = 2; j <= rows; ++j) {
                        count = 0;
                        for (int p = 0; p < fe.size(); ++p) {
                            if (!((String)fe.get(p)).equals(frameElement)) continue;
                            ++count;
                        }
                        hasAMatch = count >= 1;
                    }
                    if (hasAMatch) {
                        if (group.matches("[G][0-9]*")) {
                            report = Utility.getTime() + " PASS - Section 2.2.8 - (H" + k + ") - Valid Group Number Value - Found Value: " + cellValue;
                            ++passCount;
                        } else {
                            j = k - 1;
                            report = Utility.getTime() + " ERROR - Section 2.2.8 - (H" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid format for Group Number Value - Found Value: " + cellValue;
                            ++errorCount;
                        }
                    } else {
                        j = k - 1;
                        report = Utility.getTime() + " ERROR - Section 2.2.8 - (H" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid format for Group Number Value - Found Value: " + cellValue;
                        ++errorCount;
                    }
                    scan.close();
                    scan2.close();
                } else if (cellValue.equals("N/A")) {
                    report = Utility.getTime() + " WARNING - Section 2.2.8 - (H" + k + ") - Not Applicable - Found Value: " + cellValue;
                    ++warningCount;
                } else {
                    int j = k - 1;
                    report = Utility.getTime() + " ERROR - Section 2.2.8 - (H" + k + ") - Focal Document Element: " + Utility.isCellEmpty(sheet.getRow(j).getCell(0), j) + " - Invalid format for Group Number Value: missing the colon - Found Value: " + cellValue;
                    ++errorCount;
                }
            }
            if (report.trim().length() == 0) continue;
            System.out.println(report);
            hasAMatch = true;
            ReportCreation.writeFile(report);
        }
    }

    private static boolean strengthColumnExists() throws IOException {
        CSFRelationshipsTab.connectExcelSecond();
        String columnValue = Utility.isCellEmpty(sheet.getRow(1).getCell(9), 0);
        return columnValue.equalsIgnoreCase("strength of relationship");
    }

    protected static void strengthValidation() throws IOException {
        if (CSFRelationshipsTab.strengthColumnExists()) {
            CSFRelationshipsTab.connectExcelSecond();
            System.out.println("Section 2.2.9");
            for (int i = 1; i < rows; ++i) {
                int k = i + 1;
                report = Utility.reportClear();
                boolean check = Utility.isPopulated(sheet.getRow(i).getCell(0), sheet.getRow(i).getCell(1), sheet.getRow(i).getCell(2), sheet.getRow(i).getCell(3), sheet.getRow(i).getCell(4), sheet.getRow(i).getCell(6), null, i, 1);
                cellValue = Utility.isCellEmpty(sheet.getRow(i).getCell(9), i);
                String[] arrOfStr = cellValue.split("\\.");
                cellValue = arrOfStr[0];
                if (check && !cellValue.isEmpty()) {
                    if (cellValue.matches("[0-9]|[0-1][0]")) {
                        report = Utility.getTime() + " PASS - Section 2.2.9 - (J" + k + ") - Valid Strength Value: " + cellValue;
                        ++passCount;
                    } else {
                        report = Utility.getTime() + " ERROR - Section 2.2.9 - (J" + k + ") - Invalid Strength Value must be between 0 and 10. Found value: " + cellValue;
                        ++errorCount;
                    }
                }
                if (report.trim().length() == 0) continue;
                System.out.println(report);
                hasAMatch = true;
                ReportCreation.writeFile(report);
            }
        } else {
            System.out.println("Strength column doesnt exist.");
        }
    }

    public static void relationshipsTab() throws Exception {
        report = Utility.getTime() + " INFO - Testing Section 2.2.1 and 2.2.2";
        ReportCreation.writeFile(report);
        CSFRelationshipsTab.focalDocEleYDesc();
        report = Utility.getTime() + " INFO - Testing Section 2.2.4";
        ReportCreation.writeFile(report);
        CSFRelationshipsTab.rationalValidation();
        report = Utility.getTime() + " INFO - Testing Section 2.2.5";
        ReportCreation.writeFile(report);
        CSFRelationshipsTab.relationshipValidation();
        report = Utility.getTime() + " INFO - Testing Section 2.2.6";
        ReportCreation.writeFile(report);
        CSFRelationshipsTab.referenceDocumentValidation();
        report = Utility.getTime() + " INFO - Testing Section 2.2.7";
        ReportCreation.writeFile(report);
        CSFRelationshipsTab.referenceDescriptorValidation();
        report = Utility.getTime() + " INFO - Testing Section 2.2.8";
        ReportCreation.writeFile(report);
        CSFRelationshipsTab.fullfillValidation();
        report = Utility.getTime() + " INFO - Testing Section 2.2.9";
        ReportCreation.writeFile(report);
        CSFRelationshipsTab.groupValidation();
        if (CSFRelationshipsTab.strengthColumnExists()) {
            report = Utility.getTime() + " INFO - Testing Section 2.2.10";
            ReportCreation.writeFile(report);
            CSFRelationshipsTab.strengthValidation();
        }
    }
}

