// $Id: Contest.hh 374 2007-09-04 16:59:24Z dflater $

#ifndef CONTEST_HEADER
#define CONTEST_HEADER

#include <vector>
#include <string>
#include "parser.hh"

struct Contest {
  unsigned long id;
  std::string description;
  unsigned long N;
  unsigned long W;
  unsigned long firstChoice;
  unsigned long lastChoice;
  TGParser::Contest::Level level;
  TGParser::Contest::Logic logic;
  TGParser::Contest::Distribution distribution;
  unsigned long districtOrPrecinct;

  // tallies is used to track the number of votes generated for each
  // choice in deterministic tests.  In random tests it is unused.
  // tallies[0] is firstChoice.
  std::vector<unsigned long> tallies;

  // Scale up Triangle distribution depending on the number of votes
  // available.
  unsigned long triangleMultiplier;

  Contest (const TGParser::Contest &contest_in,
	   unsigned long districtOrPrecinct_in,
	   unsigned long &contestSerial,
	   unsigned long &choiceSerial);
};

typedef std::vector<Contest> ContestVector;

bool pertinent (const Contest &contest,
		unsigned long district,
		unsigned long precinct);

#endif
