// $Id: Exceptions.hh 220 2007-07-03 18:32:57Z dflater $

#include <exception>
#include <string>


class DatabaseException: public std::exception {
protected:
  std::string sqlerrmc;
public:
  DatabaseException() throw();        // Implemented in BorderLogic.pgcc.
  ~DatabaseException() throw() {}
  const char* what() const throw() {
    return sqlerrmc.c_str();
  }
};


class NoDataException: public DatabaseException {};


class StrftimeFailed: public std::exception {
public:
  const char* what() const throw() {
    return "strftime failed";
  }
};


class NegativeCount: public std::exception {
public:
  const char* what() const throw() {
    return "a count returned by the database was less than zero";
  }
};


class NoTallies: public std::exception {
public:
  const char* what() const throw() {
    return "no tallies";
  }
};


class UnexpectedBallotExhaustion: public std::exception {
public:
  const char* what() const throw() {
    return "unexpected ballot exhaustion";
  }
};


class PreconditionViolation: public std::exception {
protected:
  std::string whatMsg;
public:
  PreconditionViolation (constString complaint) throw() {
    whatMsg = (complaint ? complaint : "NULL");
  }
  ~PreconditionViolation() throw() {}
  const char* what() const throw() {
    return whatMsg.c_str();
  }
};
