\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-StraightParty-WriteIns.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small straight party + 1-of-M contest with write-ins.'
\echo 'Ballot styles:  1'
\echo 'Reporting contexts:  1'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1');

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Straight party, vote for at most 1', 'Straight party selection', 1, 0, false),
  (2, 'President, vote for at most 1', 'N-of-M', 1, 1, false);

insert into Choice (ChoiceId, ContestId, Name, Affiliation, IsWriteIn) values
  (0,  2, 'Nada Zayro',       NULL,               false),
  (1,  2, 'Oona Won',         'Bipartisan Party', false),
  (2,  2, 'Beeso Tu',         'Moderate Party',   false),
  (3,  2, 'Tayra Tree',       NULL,               true),
  (4,  2, 'Car Tay Fower',    NULL,               false),
  (5,  1, 'Bipartisan Party', NULL,               false),
  (6,  1, 'Moderate Party',   NULL,               false);

insert into Endorsement (Party, ChoiceId, Value) values
  ('Bipartisan Party', 1, 1),
  ('Moderate Party',   2, 1);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10, 1, true),
  (11, 1, true),
  (12, 1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 5, 1),
  (2, 2, 1),
  (3, 6, 1),
  (4, 3, 1),
  (5, 3, 1),
  (6, 3, 1),
  (7, 4, 1),
  (8, 4, 1),
  (9, 4, 1),
  (10, 4, 1),
  (11, 0, 1),
  (11, 1, 1),
  (12, 5, 1),
  (12, 6, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
