\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-SplitPrecinct-StraightParty.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Like SplitPrecinct-2 except with straight party voting.'

\i Infrastructure-VoteSchema.sql

copy ReportingContext from stdin CSV;
Precinct 1
Precinct 2
Precinct 3
District 1
District 2
Jurisdiction
\.

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

copy Contest from stdin CSV;
1,"Straight party, vote for at most 1",Straight party selection,1,0,false
2,Contest #1,N-of-M,1,0,false
3,Contest #2 (specific to District 1),N-of-M,1,0,false
4,Contest #3 (specific to District 2),N-of-M,1,0,false
\.

copy Choice from stdin CSV;
1,2,Choice #1 contest #2,Bipartisan Party,false
2,2,Choice #2 contest #2,Moderate Party,false
3,2,Choice #3 contest #2,,false
4,2,Choice #4 contest #2,,false
5,3,Choice #1 contest #3,,false
6,3,Choice #2 contest #3,Bipartisan Party,false
7,3,Choice #3 contest #3,Moderate Party,false
8,3,Choice #4 contest #3,,false
9,4,Choice #1 contest #4,,false
10,4,Choice #2 contest #4,,false
11,4,Choice #3 contest #4,Bipartisan Party,false
12,4,Choice #4 contest #4,Moderate Party,false
13,1,Bipartisan Party,,false
14,1,Moderate Party,,false
\.

insert into Endorsement (Party, ChoiceId, Value) values
  ('Bipartisan Party', 1, 1),
  ('Bipartisan Party', 6, 1),
  ('Bipartisan Party', 11, 1),
  ('Moderate Party',   2, 1),
  ('Moderate Party',   7, 1),
  ('Moderate Party',   12, 1);

copy BallotStyle from stdin CSV;
1,Precinct 1 style
2,Precinct 2/D1 style
3,Precinct 2/D2 style
4,Precinct 3 style
\.

copy BallotStyleContestAssociation from stdin CSV;
1,1
1,2
1,3
2,1
2,2
2,3
3,1
3,2
3,4
4,1
4,2
4,4
\.

copy BallotStyleReportingContextAssociation from stdin CSV;
1,Precinct 1
1,District 1
1,Jurisdiction
2,Precinct 2
2,District 1
2,Jurisdiction
3,Precinct 2
3,District 2
3,Jurisdiction
4,Precinct 3
4,District 2
4,Jurisdiction
\.

copy Ballot from stdin CSV;
1,3,true
2,3,true
3,4,true
4,2,true
5,1,true
6,3,true
7,4,true
8,4,true
9,1,true
10,3,true
11,3,true
12,4,true
13,4,true
14,4,true
15,3,true
16,1,true
17,4,true
18,2,true
19,1,true
20,1,true
21,1,true
22,3,true
23,2,true
24,2,true
25,3,true
26,1,true
27,3,true
28,3,true
29,4,true
30,2,true
31,2,true
32,2,true
33,1,true
34,2,true
35,1,true
36,2,true
37,4,true
38,1,true
39,4,true
40,1,true
\.

copy VoterInput from stdin CSV;
1,4,1
1,12,1
2,4,1
2,12,1
3,4,1
3,11,1
4,4,1
4,8,1
5,3,1
5,8,1
6,4,1
6,12,1
7,3,1
7,11,1
8,4,1
8,12,1
9,3,1
9,7,1
10,4,1
10,10,1
11,3,1
11,11,1
12,4,1
12,12,1
13,2,1
13,10,1
14,3,1
14,11,1
15,4,1
15,12,1
16,2,1
16,8,1
17,3,1
17,9,1
18,4,1
18,7,1
19,2,1
19,8,1
20,3,1
20,6,1
21,4,1
21,7,1
22,2,1
22,10,1
23,3,1
23,8,1
24,4,1
24,6,1
25,13,1
26,14,1
27,3,1
27,12,1
28,4,1
28,9,1
29,1,1
29,10,1
30,2,1
30,8,1
31,3,1
31,5,1
32,4,1
32,6,1
33,1,1
33,7,1
34,2,1
34,8,1
35,3,1
35,5,1
36,4,1
36,6,1
37,13,1
38,14,1
39,3,1
39,12,1
40,4,1
40,8,1
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "Precinct 2" "Precinct 3" "District 1" "District 2" "Jurisdiction"
\i Infrastructure-TestFooter.sql
