\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-NofM-WriteIns.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small 2-of-M contest with write-ins, no aliasing.'
\echo '(Note that MaxWriteIns = 1 while N = 2)'
\echo 'Ballot styles:  1'
\echo 'Reporting contexts:  1'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Parking Committee, vote for at most 2', 'N-of-M', 2, 1, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false),
  (5,  1, 'Wu Fife', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10, 1, true),
  (11, 1, true),
  (12, 1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (2, 2, 1),
  (2, 5, 1),
  (3, 2, 1),
  (3, 5, 1),
  (4, 3, 1),
  (4, 5, 1),
  (5, 3, 1),
  (6, 3, 1),
  (6, 5, 1),
  (7, 4, 1),
  (7, 5, 1),
  (8, 4, 1),
  (9, 4, 1),
  (10, 4, 1);

-- Add the write-ins.  This is not really different from including them
-- above.  It does not become interesting until we have aliases.

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (1,  1, 'Oona Won', true),
  (6,  1, 'Lu Sigs', true);
insert into VoterInput (BallotId, ChoiceId, Value) values
  (0, 1, 1),
  (5, 6, 1),
  (8, 6, 1),
  (9, 6, 1),
  (10, 6, 1),
  (11, 6, 1),
  (12, 6, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
