\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-Cumulative-NofM.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small cumulative voting contest plus small N-of-M contest,'
\echo 'no write-ins, no rejected ballots.'
\echo 'Ballot styles:  1'
\echo 'Reporting contexts:  1'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Leadership Coalition, cast at most 2 votes', 'Cumulative', 2, 0, false),
  (2, 'Parking Committee, vote for at most 2', 'N-of-M', 2, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (1,  1, 'Oona Won', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false),
  (5,  2, 'Nada Zayro', false),
  (6,  2, 'Oona Won', false),
  (7,  2, 'Beeso Tu', false),
  (8,  2, 'Tayra Tree', false),
  (9,  2, 'Car Tay Fower', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (0, 5, 1),
  (0, 6, 1),
  (0, 7, 1),
  (1, 1, 1),
  (1, 4, 1),
  (1, 6, 1),
  (2, 2, 2),
  (2, 7, 1),
  (2, 8, 1),
  (3, 3, 2),
  (3, 7, 1),
  (3, 8, 1),
  (4, 3, 1),
  (4, 4, 1),
  (4, 8, 1),
  (4, 9, 1),
  (5, 4, 2),
  (5, 9, 1),
  (6, 1, 1),
  (6, 2, 1),
  (6, 3, 1),
  (6, 9, 1),
  (7, 0, 2),
  (7, 2, 1),
  (7, 9, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
