\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-AbsenteeBySpecialPrecinct-Yes-or-No.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small Yes-or-No contest with absentee ballots via a special precinct'
\echo 'and ballot style.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1'),
  ('Absentee Precinct'),
  ('Jurisdiction');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Property Tax Decrease Proposal', 'N-of-M', 1, 0, false),
  (2, 'Sales Tax Increase Proposal', 'N-of-M',  1, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Yes (2)', false),
  (1,  1, 'No (4)', false),
  (2,  2, 'Yes (3)', false),
  (3,  2, 'No (5)', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style'),
  (2, 'Absentee Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2),
  (2, 1),
  (2, 2);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Jurisdiction'),
  (2, 'Absentee Precinct'),
  (2, 'Jurisdiction');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 2, true),
  (2, 1, true),
  (3, 2, true),
  (4, 1, true),
  (5, 2, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10, 1, true),
  (11, 1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 0, 1),
  (2, 1, 1),
  (2, 3, 1),
  (3, 1, 1),
  (4, 1, 1),
  (4, 2, 1),
  (5, 1, 1),
  (5, 2, 1),
  (6, 2, 1),
  (7, 0, 1),
  (7, 3, 1),
  (8, 3, 1),
  (9, 3, 1),
  (10, 3, 1),
  (11, 0, 1),
  (11, 1, 1);


\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "Absentee Precinct" "Jurisdiction"
\i Infrastructure-TestFooter.sql
