\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-AbsenteeBySpecialPrecinct-Cumulative.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small Cumulative contest, N=3, with absentee ballots via a special precinct'
\echo 'and ballot style, no write-in, no rejected ballots.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1'),
  ('Absentee Precinct'),
  ('Jurisdiction');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Parking Committee, cast at most 3 votes', 'Cumulative', 3, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (1,  1, 'Oona Won', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false),
  (5,  1, 'Joe Nahyn', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style'),
  (2, 'Absentee Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (2, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Jurisdiction'),
  (2, 'Absentee Precinct'),
  (2, 'Jurisdiction');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 2, true),
  (2, 1, true),
  (3, 2, true),
  (4, 1, true),
  (5, 2, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true);
  

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 1, 1),
  (1, 5, 1),
  (2, 2, 1),
  (2, 3, 1),
  (3, 5, 2),
  (4, 3, 1),
  (4, 4, 1),
  (5, 5, 3),
  (6, 4, 1),
  (6, 5, 1),
  (7, 4, 1),
  (7, 5, 2),
  (8, 0, 1),
  (8, 1, 1),
  (8, 2, 1),
  (8, 3, 1),
  (9, 2, 1),
  (9, 3, 1),
  (9, 4, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "Absentee Precinct" "Jurisdiction"
\i Infrastructure-TestFooter.sql
