%{

// $Id: parser_l.ll 374 2007-09-04 16:59:24Z dflater $

#include "parser.hh"
#include "parser_y.h"
#include <iostream>
#include <sstream>
#include <stdlib.h>
#include <assert.h>
#include <string.h>


static unsigned lineno = 1;

static void barf (char const * const reason) {
  std::cerr << reason << " at line " << lineno << " of input\n";
  exit (-1);
}

static unsigned linecount (char const *s) {
  assert (s);
  unsigned count (0);
  for (; *s; ++s)
    if (*s == '\n')
      ++count;
  return count;
}

%}

%%

\n                 ++lineno;
[ \f\r\t\v]+       ;
"//".*             ;

"/*"((\*[^/])|[^*])*"*/" { lineno += linecount(yytext); }

[=()]              { return yytext[0]; }

"ballots"              { return BALLOTS; }
"districts"            { return DISTRICTS; }
"precincts"            { return PRECINCTS; }
"N"                    { return NTOKEN; }
"M"                    { return MTOKEN; }
"W"                    { return WTOKEN; }
"level"                { return LEVEL; }
"logic"                { return LOGIC; }
"distribution"         { return DISTRIBUTION; }
"ballotDistribution"   { return BALLOTDISTRIBUTION; }
"precinctDistribution" { return PRECINCTDISTRIBUTION; }

"D"                { return D; }
"P"                { return P; }
"S"                { return S; }
"C"                { return C; }
"R"                { return R; }
"UniformRandom"    { return UNIFORMRANDOM; }
"Triangle"         { return TRIANGLE; }
"Even"             { return EVEN; }

[0-9]+ {
  std::istringstream(yytext) >> yylval.number;
  return NUMBER;
}

 /* Dead end */
. { barf ("Unrecognized token"); }

%%

int yywrap() {
  return 1;
}

void yyerror (const char *unusedParameter) {
  std::cerr << "Syntax error at line " << lineno << " of input\n";
  exit (-1);
}
