// $Id: BorderLogic.hh 268 2007-07-18 17:34:35Z dflater $

#ifndef BorderLogic_HH
#define BorderLogic_HH

#include "Types.hh"

void connectDatabase    ();
void disconnectDatabase ();

bool reportingContextValid (constString contextName);

// Replace views with temporary tables to improve performance on large
// scenarios.  Must be invoked prior to any of the fetch... functions.
void materializeViews ();

void fetchTotalBallotCounts (constString contextName,
			     BallotCount &ballotCount_out);
void fetchBallotCountsByCategory (constString contextName,
				  BallotCountVector &ballotCounts_out);
void fetchBlankBallotCounts (constString contextName,
			     BallotCount &ballotCount_out);
void fetchBallotCountsByConfiguration (
	                            constString contextName,
				    StyleBallotCountVector &ballotCounts_out);
void fetchBallotCountsByCategoryAndConfiguration (
	                                  constString contextName,
					  styleId_t   style,
				          BallotCountVector &ballotCounts_out);

// Returns true if there are blank ballots to report.  Otherwise,
// count is invalid.
bool fetchBlankBallotCountsByConfiguration (constString contextName,
					    styleId_t   style,
			                    BallotCount &ballotCount_out);

void fetchNonRankedContestsInContext (constString contextName,
				      ContestStructVector &contests_out);
void fetchChoicesInContest (contestId_t contest,
			    ChoiceDescriptionMap &choices_out);

// Tallies are returned sorted into descending order.
void fetchTalliesInContest (constString contextName,
			    contestId_t contest,
			    TallyVector &tallies_out);

long fetchOvervotes          (constString contextName, contestId_t contest);
long fetchUndervotes         (constString contextName, contestId_t contest);
long fetchContestBallotCount (constString contextName, contestId_t contest);
long fetchBalance            (constString contextName, contestId_t contest);

void fetchRankedOrderContestsInContext (constString contextName,
					ContestStructVector &contests_out);

// Does not include votes from provisionals that are not accepted.
void fetchRankedOrderVotes (contestId_t contestId_in,
                            constString contextName,
                            ScaledROVoteMap &votes_out);

#endif
