-- $Id: Infrastructure-Features.sql 462 2008-01-14 20:51:46Z dflater $

create table Features (
  Test                           Text     primary key,

  PrimaryElections               Boolean  not null default false,
  AbsenteeVoting                 Boolean  not null default false,
  AbsenteeByCategories           Boolean  not null default false,
  SplitPrecincts                 Boolean  not null default false,
  BallotRotation                 Boolean  not null default false,
  WriteIns                       Boolean  not null default false,
  CumulativeVoting               Boolean  not null default false,
  NofMVoting                     Boolean  not null default false,
  RankedOrderVoting              Boolean  not null default false,
  ProvisionalChallengedBallots   Boolean  not null default false,
  StraightPartyVoting            Boolean  not null default false,
  CrossPartyEndorsement          Boolean  not null default false

  check (StraightPartyVoting or not CrossPartyEndorsement),
  check (AbsenteeVoting or not AbsenteeByCategories)
);

copy Features (Test) from stdin CSV;
1-basic-1ofM.sql
1-basic-AbsenteeByCategory-CrossPartyEndorsement.sql
1-basic-AbsenteeByCategory-Cumulative.sql
1-basic-AbsenteeByCategory-NofM.sql
1-basic-AbsenteeByCategory-Provisional.sql
1-basic-AbsenteeByCategory-RankedOrder.sql
1-basic-AbsenteeByCategory-StraightParty.sql
1-basic-AbsenteeByCategory-WriteIns.sql
1-basic-AbsenteeByCategory.sql
1-basic-AbsenteeBySpecialPrecinct-CrossPartyEndorsement.sql
1-basic-AbsenteeBySpecialPrecinct-Cumulative.sql
1-basic-AbsenteeBySpecialPrecinct-NofM-Provisional.sql
1-basic-AbsenteeBySpecialPrecinct-NofM.sql
1-basic-AbsenteeBySpecialPrecinct-Provisional.sql
1-basic-AbsenteeBySpecialPrecinct-RankedOrder.sql
1-basic-AbsenteeBySpecialPrecinct-SplitPrecinct.sql
1-basic-AbsenteeBySpecialPrecinct-StraightParty.sql
1-basic-AbsenteeBySpecialPrecinct-WriteIns.sql
1-basic-AbsenteeBySpecialPrecinct-Yes-or-No.sql
1-basic-AbsenteeBySpecialPrecinct.sql
1-basic-BallotRotation-AbsenteeByCategory.sql
1-basic-BallotRotation-AbsenteeBySpecialPrecinct.sql
1-basic-BallotRotation-CrossPartyEndorsement.sql
1-basic-BallotRotation-Cumulative.sql
1-basic-BallotRotation-NofM.sql
1-basic-BallotRotation-Provisional.sql
1-basic-BallotRotation-RankedOrder.sql
1-basic-BallotRotation-StraightParty.sql
1-basic-BallotRotation-WriteInsAliases.sql
1-basic-BallotRotation.sql
1-basic-CrossPartyEndorsement-Cumulative.sql
1-basic-CrossPartyEndorsement-NofM.sql
1-basic-CrossPartyEndorsement-Provisional.sql
1-basic-CrossPartyEndorsement-WriteIns.sql
1-basic-CrossPartyEndorsement.sql
1-basic-Cumulative-NofM.sql
1-basic-Cumulative-Provisional.sql
1-basic-Cumulative-RankedOrder.sql
1-basic-Cumulative.sql
1-basic-NoBallots-1ofM.sql
1-basic-NoBallots-RankedOrder.sql
1-basic-NoChoices-1ofM.sql
1-basic-NoChoicesNoBallots-1ofM.sql
1-basic-NofM-Provisional.sql
1-basic-NofM-WriteIns.sql
1-basic-NofM.sql
1-basic-Primary-AbsenteeByCategory.sql
1-basic-Primary-AbsenteeBySpecialPrecinct.sql
1-basic-Primary-BallotRotation.sql
1-basic-Primary-CrossPartyEndorsement.sql
1-basic-Primary-Cumulative.sql
1-basic-Primary-NofM.sql
1-basic-Primary-Provisional.sql
1-basic-Primary-RankedOrder.sql
1-basic-Primary-SplitPrecinct.sql
1-basic-Primary-StraightParty.sql
1-basic-Primary-WriteIns.sql
1-basic-Primary.sql
1-basic-Provisional.sql
1-basic-RankedOrder-1.sql
1-basic-RankedOrder-2.sql
1-basic-RankedOrder-NofM.sql
1-basic-RankedOrder-Provisional.sql
1-basic-RankedOrder-WriteIns.sql
1-basic-SplitPrecinct-1.sql
1-basic-SplitPrecinct-2.sql
1-basic-SplitPrecinct-AbsenteeByCategory.sql
1-basic-SplitPrecinct-BallotRotation.sql
1-basic-SplitPrecinct-CrossPartyEndorsement.sql
1-basic-SplitPrecinct-Cumulative.sql
1-basic-SplitPrecinct-NofM.sql
1-basic-SplitPrecinct-Provisional.sql
1-basic-SplitPrecinct-RankedOrder.sql
1-basic-SplitPrecinct-StraightParty.sql
1-basic-SplitPrecinct-WriteIns.sql
1-basic-StraightParty-Cumulative.sql
1-basic-StraightParty-NofM.sql
1-basic-StraightParty-Provisional.sql
1-basic-StraightParty-RankedOrder.sql
1-basic-StraightParty-WriteIns.sql
1-basic-StraightParty.sql
1-basic-WriteIns.sql
1-basic-WriteInsAliases-AbsenteeByCategory.sql
1-basic-WriteInsAliases-AbsenteeBySpecialPrecinct.sql
1-basic-WriteInsAliases-Cumulative.sql
1-basic-WriteInsAliases-NofM.sql
1-basic-WriteInsAliases-Provisional.sql
1-basic-WriteInsAliases.sql
1-basic-Yes-or-No.sql
1-basic-samples-AlleganyGeneral2004.sql
1-basic-samples-CecilRPrimary1998.sql
1-basic-samples-FairfaxGeneral2004.sql
\.

update Features set PrimaryElections = true     where Test ~* 'Primary';
update Features set AbsenteeVoting = true       where Test ~* 'Absentee';
update Features set AbsenteeByCategories = true where Test ~* 'Category';
update Features set SplitPrecincts = true       where Test ~* 'SplitPrecinct';
update Features set BallotRotation = true       where Test ~* 'BallotRotation';
update Features set WriteIns = true
  where Test ~* 'WriteIns' or Test ~* 'NoChoices';
update Features set CumulativeVoting = true     where Test ~* 'Cumulative';
update Features set NofMVoting = true           where Test ~* 'NofM';
update Features set RankedOrderVoting = true    where Test ~* 'RankedOrder';
update Features set ProvisionalChallengedBallots = true
  where Test ~* 'Provisional';
update Features set StraightPartyVoting = true  where Test ~* 'StraightParty';
update Features set StraightPartyVoting = true, CrossPartyEndorsement = true
  where Test ~* 'CrossPartyEndorsement';

update Features set NofMVoting = true, WriteIns = true
  where Test = '1-basic-samples-AlleganyGeneral2004.sql';
update Features set NofMVoting = true, PrimaryElections = true
  where Test = '1-basic-samples-CecilRPrimary1998.sql';
update Features set WriteIns = true
  where Test = '1-basic-samples-FairfaxGeneral2004.sql';
