\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-samples-FairfaxGeneral2004.sql 464 2008-01-14 22:11:53Z dflater $'
\echo
\echo 'Customized TestGenerator-generated test.  Test spec follows:'
\echo
\echo '  // Test spec based on Fairfax County, VA sample ballot for 8th'
\echo '  // district, general election, 2004-11-02.'
\echo '  // http://vote.nist.gov/ballots/Sample Ballot 8th-2004.pdf'
\echo '  '
\echo '  districts=3'
\echo '  '
\echo '  // As of 2006-05, Congressional districts 8/10/11 had 69/52/106 precincts'
\echo '  precincts=5'
\echo '  precinctDistribution=Even'
\echo '  '
\echo '  ballots=100'
\echo '  '
\echo '  (N=1 M=5 W=1 distribution=Triangle)          // President and VP'
\echo '  (level=D N=1 M=4 W=1 distribution=Triangle)  // House of Representatives'
\echo '  (N=1 M=2 distribution=Triangle)  // Constitutional Amendment Question 1'
\echo '  (N=1 M=2)  // Constitutional Amendment Question 2'
\echo '  (N=1 M=2)  // Human Services Facilities Bonds'
\echo '  (N=1 M=2)  // Public Library Facilities Bonds'
\echo '  (N=1 M=2)  // Parks and Park Facilities Bonds'
\echo '  (N=1 M=2)  // Transportation Improvements and Facilities Bonds'
\echo
\echo 'Contest and candidate names were copied in from the sample ballot but'
\echo 'the vote totals are synthetic and have no relationship to the actual'
\echo 'election results.'

\i Infrastructure-VoteSchema.sql

copy ReportingContext from stdin CSV;
Precinct 1
Precinct 2
Precinct 3
Precinct 4
Precinct 5
District 8
District 10
District 11
Jurisdiction
\.

copy Contest from stdin CSV;
1,PRESIDENT and VICE PRESIDENT (Vote for not more than one),N-of-M,1,1,false
2,MEMBER HOUSE OF REPRESENTATIVES 8TH DISTRICT (Vote for not more than one),N-of-M,1,1,false
3,MEMBER HOUSE OF REPRESENTATIVES 10TH DISTRICT (Vote for not more than one),N-of-M,1,1,false
4,MEMBER HOUSE OF REPRESENTATIVES 11TH DISTRICT (Vote for not more than one),N-of-M,1,1,false
5,PROPOSED CONSTITUTIONAL AMENDMENTS QUESTION 1,N-of-M,1,0,false
6,PROPOSED CONSTITUTIONAL AMENDMENTS QUESTION 2,N-of-M,1,0,false
7,HUMAN SERVICES FACILITIES BONDS,N-of-M,1,0,false
8,PUBLIC LIBRARY FACILITIES BONDS,N-of-M,1,0,false
9,PARKS AND PARK FACILITIES BONDS,N-of-M,1,0,false
10,TRANSPORTATION IMPROVEMENTS AND FACILITIES BONDS,N-of-M,1,0,false
\.

copy Choice from stdin CSV;
1,1,Write-in President and VP,,true
2,1,"DEMOCRATIC PARTY Electors for John F. Kerry, President; John Edwards, Vice President",,false
3,1,"REPUBLICAN PARTY Electors for George W. Bush, President; Dick Cheney, Vice President",,false
4,1,"CONSTITUTION PARTY Electors for Michael A. Peroutka, President; Chuck Baldwin, Vice President",,false
5,1,"LIBERTARIAN PARTY Electors for Michael Badnarik, President; Richard Campagna, Vice President",,false
6,2,8th District Write-in Representative,,true
7,2,"James P. Moran, Jr. - D",,false
8,2,Lisa Marie Cheney - R,,false
9,2,James T. Hurysz - I,,false
10,3,10th District Write-in Representative,,true
11,3,10th District Representative #2,,false
12,3,10th District Representative #3,,false
13,3,10th District Representative #4,,false
14,4,11th District Write-in Representative,,true
15,4,11th District Representative #2,,false
16,4,11th District Representative #3,,false
17,4,11th District Representative #4,,false
18,5,Yes,,false
19,5,No,,false
20,6,Yes,,false
21,6,No,,false
22,7,Yes,,false
23,7,No,,false
24,8,Yes,,false
25,8,No,,false
26,9,Yes,,false
27,9,No,,false
28,10,Yes,,false
29,10,No,,false
\.

copy BallotStyle from stdin CSV;
1,Precinct 1 style
2,Precinct 2 style
3,Precinct 3 style
4,Precinct 4 style
5,Precinct 5 style
\.

copy BallotStyleContestAssociation from stdin CSV;
1,1
1,2
1,5
1,6
1,7
1,8
1,9
1,10
2,1
2,3
2,5
2,6
2,7
2,8
2,9
2,10
3,1
3,3
3,5
3,6
3,7
3,8
3,9
3,10
4,1
4,4
4,5
4,6
4,7
4,8
4,9
4,10
5,1
5,4
5,5
5,6
5,7
5,8
5,9
5,10
\.

copy BallotStyleReportingContextAssociation from stdin CSV;
1,Precinct 1
1,District 8
1,Jurisdiction
2,Precinct 2
2,District 10
2,Jurisdiction
3,Precinct 3
3,District 10
3,Jurisdiction
4,Precinct 4
4,District 11
4,Jurisdiction
5,Precinct 5
5,District 11
5,Jurisdiction
\.

copy Ballot from stdin CSV;
1,1,true
2,5,true
3,1,true
4,2,true
5,1,true
6,2,true
7,5,true
8,4,true
9,2,true
10,4,true
11,2,true
12,4,true
13,5,true
14,4,true
15,5,true
16,2,true
17,1,true
18,1,true
19,3,true
20,2,true
21,1,true
22,1,true
23,1,true
24,4,true
25,4,true
26,2,true
27,5,true
28,1,true
29,5,true
30,2,true
31,2,true
32,3,true
33,1,true
34,4,true
35,5,true
36,4,true
37,4,true
38,1,true
39,3,true
40,4,true
41,5,true
42,4,true
43,2,true
44,2,true
45,4,true
46,5,true
47,4,true
48,3,true
49,4,true
50,4,true
51,5,true
52,1,true
53,4,true
54,2,true
55,1,true
56,2,true
57,3,true
58,3,true
59,5,true
60,1,true
61,5,true
62,1,true
63,4,true
64,2,true
65,1,true
66,5,true
67,2,true
68,3,true
69,4,true
70,2,true
71,2,true
72,3,true
73,1,true
74,5,true
75,2,true
76,1,true
77,2,true
78,1,true
79,3,true
80,5,true
81,3,true
82,2,true
83,4,true
84,2,true
85,1,true
86,5,true
87,5,true
88,5,true
89,4,true
90,5,true
91,5,true
92,3,true
93,3,true
94,1,true
95,4,true
96,5,true
97,3,true
98,5,true
99,2,true
100,3,true
\.

copy VoterInput from stdin CSV;
1,5,1
1,9,1
1,19,1
1,20,1
1,22,1
1,25,1
1,26,1
1,29,1
2,5,1
2,17,1
2,19,1
2,21,1
2,22,1
2,24,1
2,27,1
2,28,1
3,5,1
3,9,1
3,19,1
3,21,1
3,22,1
3,25,1
3,27,1
3,29,1
4,5,1
4,13,1
4,19,1
4,20,1
4,23,1
4,25,1
4,27,1
4,28,1
5,5,1
5,8,1
5,19,1
5,21,1
5,23,1
5,25,1
5,26,1
5,28,1
6,5,1
6,13,1
6,19,1
6,21,1
6,22,1
6,24,1
6,27,1
6,28,1
7,4,1
7,17,1
7,19,1
7,21,1
7,23,1
7,25,1
7,26,1
7,28,1
8,5,1
8,17,1
8,19,1
8,21,1
8,22,1
8,25,1
8,27,1
8,29,1
9,4,1
9,13,1
9,19,1
9,21,1
9,22,1
9,24,1
9,26,1
9,29,1
10,5,1
10,17,1
10,19,1
10,20,1
10,22,1
10,25,1
10,27,1
10,29,1
11,4,1
11,12,1
11,19,1
11,20,1
11,23,1
11,24,1
11,26,1
11,29,1
12,5,1
12,16,1
12,19,1
12,21,1
12,23,1
12,24,1
12,26,1
12,28,1
13,4,1
13,17,1
13,19,1
13,21,1
13,23,1
13,25,1
13,26,1
13,28,1
14,5,1
14,16,1
14,19,1
14,21,1
14,23,1
14,25,1
14,27,1
14,29,1
15,4,1
15,17,1
15,19,1
15,21,1
15,23,1
15,25,1
15,27,1
15,29,1
16,5,1
16,13,1
16,19,1
16,21,1
16,23,1
16,25,1
16,26,1
16,28,1
17,4,1
17,9,1
17,19,1
17,20,1
17,22,1
17,25,1
17,27,1
17,28,1
18,5,1
18,8,1
18,19,1
18,20,1
18,23,1
18,24,1
18,27,1
18,29,1
19,3,1
19,12,1
19,19,1
19,21,1
19,22,1
19,25,1
19,27,1
19,28,1
20,4,1
20,13,1
20,19,1
20,21,1
20,23,1
20,24,1
20,26,1
20,29,1
21,5,1
21,9,1
21,19,1
21,20,1
21,23,1
21,24,1
21,27,1
21,28,1
22,3,1
22,7,1
22,19,1
22,21,1
22,22,1
22,25,1
22,27,1
22,28,1
23,4,1
23,8,1
23,19,1
23,20,1
23,22,1
23,24,1
23,26,1
23,29,1
24,5,1
24,16,1
24,19,1
24,20,1
24,23,1
24,24,1
24,27,1
24,29,1
25,3,1
25,17,1
25,19,1
25,20,1
25,23,1
25,24,1
25,26,1
25,29,1
26,4,1
26,12,1
26,19,1
26,20,1
26,22,1
26,25,1
26,26,1
26,29,1
27,5,1
27,16,1
27,19,1
27,21,1
27,23,1
27,24,1
27,26,1
27,28,1
28,3,1
28,9,1
28,19,1
28,21,1
28,22,1
28,24,1
28,27,1
28,28,1
29,4,1
29,17,1
29,19,1
29,21,1
29,23,1
29,24,1
29,26,1
29,29,1
30,5,1
30,13,1
30,19,1
30,21,1
30,23,1
30,24,1
30,26,1
30,28,1
31,3,1
31,11,1
31,19,1
31,20,1
31,22,1
31,25,1
31,26,1
31,29,1
32,4,1
32,12,1
32,19,1
32,21,1
32,23,1
32,24,1
32,27,1
32,28,1
33,5,1
33,7,1
33,19,1
33,20,1
33,22,1
33,25,1
33,27,1
33,29,1
34,3,1
34,15,1
34,18,1
34,20,1
34,22,1
34,25,1
34,27,1
34,29,1
35,4,1
35,16,1
35,19,1
35,20,1
35,23,1
35,25,1
35,27,1
35,28,1
36,5,1
36,17,1
36,18,1
36,20,1
36,22,1
36,25,1
36,27,1
36,28,1
37,2,1
37,15,1
37,19,1
37,21,1
37,22,1
37,24,1
37,27,1
37,29,1
38,3,1
38,8,1
38,18,1
38,20,1
38,22,1
38,24,1
38,26,1
38,28,1
39,4,1
39,13,1
39,19,1
39,20,1
39,22,1
39,25,1
39,26,1
39,28,1
40,5,1
40,16,1
40,18,1
40,21,1
40,23,1
40,24,1
40,27,1
40,28,1
41,2,1
41,17,1
41,19,1
41,20,1
41,23,1
41,25,1
41,27,1
41,29,1
42,3,1
42,15,1
42,18,1
42,20,1
42,22,1
42,24,1
42,26,1
42,29,1
43,4,1
43,11,1
43,19,1
43,21,1
43,22,1
43,24,1
43,27,1
43,28,1
44,5,1
44,12,1
44,18,1
44,20,1
44,22,1
44,24,1
44,27,1
44,29,1
45,2,1
45,16,1
45,19,1
45,21,1
45,23,1
45,24,1
45,27,1
45,28,1
46,3,1
46,17,1
46,18,1
46,20,1
46,23,1
46,25,1
46,27,1
46,28,1
47,4,1
47,15,1
47,19,1
47,21,1
47,22,1
47,24,1
47,26,1
47,28,1
48,5,1
48,13,1
48,18,1
48,20,1
48,22,1
48,25,1
48,26,1
48,29,1
49,2,1
49,16,1
49,19,1
49,21,1
49,22,1
49,24,1
49,26,1
49,29,1
50,3,1
50,17,1
50,18,1
50,20,1
50,22,1
50,24,1
50,27,1
50,28,1
51,4,1
51,14,1
51,19,1
51,20,1
51,22,1
51,24,1
51,27,1
51,29,1
52,5,1
52,9,1
52,18,1
52,20,1
52,22,1
52,24,1
52,26,1
52,29,1
53,2,1
53,15,1
53,19,1
53,20,1
53,22,1
53,24,1
53,26,1
53,29,1
54,3,1
54,11,1
54,18,1
54,20,1
54,22,1
54,25,1
54,26,1
54,29,1
55,4,1
55,6,1
55,19,1
55,20,1
55,22,1
55,25,1
55,26,1
55,29,1
56,5,1
56,12,1
56,18,1
56,20,1
56,22,1
56,25,1
56,26,1
56,29,1
57,2,1
57,13,1
57,19,1
57,20,1
57,22,1
57,25,1
57,26,1
57,29,1
58,3,1
58,10,1
58,18,1
58,20,1
58,23,1
58,24,1
58,27,1
58,28,1
59,4,1
59,16,1
59,19,1
59,21,1
59,22,1
59,24,1
59,26,1
59,29,1
60,5,1
60,7,1
60,18,1
60,21,1
60,23,1
60,24,1
60,27,1
60,29,1
61,1,1
61,17,1
61,19,1
61,20,1
61,22,1
61,25,1
61,27,1
61,29,1
62,2,1
62,8,1
62,18,1
62,20,1
62,22,1
62,24,1
62,27,1
62,28,1
63,3,1
63,14,1
63,19,1
63,20,1
63,23,1
63,25,1
63,26,1
63,29,1
64,4,1
64,11,1
64,18,1
64,20,1
64,23,1
64,25,1
64,27,1
64,28,1
65,5,1
65,9,1
65,19,1
65,21,1
65,23,1
65,24,1
65,26,1
65,29,1
66,1,1
66,15,1
66,18,1
66,20,1
66,23,1
66,25,1
66,27,1
66,29,1
67,2,1
67,12,1
67,19,1
67,20,1
67,22,1
67,24,1
67,26,1
67,29,1
68,3,1
68,13,1
68,18,1
68,20,1
68,22,1
68,24,1
68,27,1
68,28,1
69,4,1
69,16,1
69,19,1
69,21,1
69,22,1
69,24,1
69,27,1
69,28,1
70,5,1
70,10,1
70,18,1
70,20,1
70,22,1
70,24,1
70,27,1
70,29,1
71,1,1
71,11,1
71,19,1
71,21,1
71,22,1
71,24,1
71,27,1
71,29,1
72,2,1
72,12,1
72,18,1
72,21,1
72,22,1
72,24,1
72,26,1
72,28,1
73,3,1
73,6,1
73,19,1
73,20,1
73,23,1
73,24,1
73,26,1
73,28,1
74,4,1
74,17,1
74,18,1
74,20,1
74,22,1
74,25,1
74,26,1
74,28,1
75,5,1
75,13,1
75,19,1
75,21,1
75,23,1
75,24,1
75,26,1
75,28,1
76,1,1
76,7,1
76,18,1
76,20,1
76,23,1
76,24,1
76,26,1
76,28,1
77,2,1
77,10,1
77,19,1
77,21,1
77,22,1
77,24,1
77,26,1
77,29,1
78,3,1
78,8,1
78,18,1
78,21,1
78,22,1
78,24,1
78,26,1
78,29,1
79,4,1
79,11,1
79,19,1
79,20,1
79,23,1
79,24,1
79,27,1
79,29,1
80,5,1
80,14,1
80,18,1
80,21,1
80,22,1
80,25,1
80,27,1
80,28,1
81,1,1
81,12,1
81,19,1
81,20,1
81,22,1
81,25,1
81,27,1
81,29,1
82,2,1
82,13,1
82,18,1
82,20,1
82,23,1
82,24,1
82,26,1
82,29,1
83,3,1
83,15,1
83,19,1
83,20,1
83,23,1
83,25,1
83,27,1
83,29,1
84,4,1
84,18,1
84,21,1
84,23,1
84,24,1
84,26,1
84,28,1
85,5,1
85,9,1
85,19,1
85,21,1
85,23,1
85,24,1
85,27,1
85,29,1
86,1,1
86,16,1
86,18,1
86,21,1
86,23,1
86,24,1
86,26,1
86,29,1
87,2,1
87,17,1
87,19,1
87,21,1
87,23,1
87,24,1
87,26,1
87,29,1
88,3,1
88,14,1
88,18,1
88,21,1
88,23,1
88,24,1
88,27,1
88,28,1
89,4,1
89,15,1
89,19,1
89,20,1
89,23,1
89,25,1
89,26,1
89,28,1
90,5,1
90,16,1
90,18,1
90,20,1
90,23,1
90,25,1
90,26,1
90,28,1
91,17,1
91,19,1
91,21,1
91,23,1
91,24,1
91,27,1
91,29,1
92,18,1
92,20,1
92,22,1
92,25,1
92,27,1
92,28,1
93,19,1
93,20,1
93,22,1
93,24,1
93,26,1
93,28,1
94,18,1
94,20,1
94,23,1
94,24,1
94,26,1
94,29,1
95,19,1
95,21,1
95,22,1
95,25,1
95,27,1
95,29,1
96,18,1
96,21,1
96,23,1
96,25,1
96,27,1
96,29,1
97,19,1
97,21,1
97,23,1
97,25,1
97,27,1
97,29,1
98,18,1
98,20,1
98,23,1
98,24,1
98,27,1
98,28,1
99,19,1
99,21,1
99,23,1
99,25,1
99,27,1
99,29,1
100,20,1
100,23,1
100,25,1
100,26,1
100,28,1
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "Precinct 2" "Precinct 3" "Precinct 4" "Precinct 5" "District 8" "District 10" "District 11" "Jurisdiction"
\i Infrastructure-TestFooter.sql
