\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-Primary-RankedOrder.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small primary election with ranked order voting, no write-ins,'
\echo 'no rejected ballots.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into ReportingContext values
  ('Precinct 1'),
  ('Precinct 1 Bipartisan Party'),
  ('Precinct 1 Moderate Party');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Nonpartisan committee, rank in order of preference', 'Ranked order', 2, 0, false),
  (2, 'Bipartisan Party subcommittee, rank in order of preference', 'Ranked order', 3, 0, false),
  (3, 'Moderate Party subcommittee, rank in order of preference', 'Ranked order', 3, 0, false);

copy Choice from stdin CSV;
1,1,Choice #1 nonpartisan committee,,false
2,1,Choice #2 nonpartisan committee,,false
3,1,Choice #3 nonpartisan committee,,false
4,1,Choice #4 nonpartisan committee,,false
5,2,Choice #1 Bipartisan Party subcommittee,,false
6,2,Choice #2 Bipartisan Party subcommittee,,false
7,2,Choice #3 Bipartisan Party subcommittee,,false
8,2,Choice #4 Bipartisan Party subcommittee,,false
9,2,Choice #5 Bipartisan Party subcommittee,,false
10,3,Choice #1 Moderate Party subcommittee,,false
11,3,Choice #2 Moderate Party subcommittee,,false
12,3,Choice #3 Moderate Party subcommittee,,false
13,3,Choice #4 Moderate Party subcommittee,,false
14,3,Choice #5 Moderate Party subcommittee,,false
\.

insert into BallotStyle (StyleId, Name) values
  (1, 'Bipartisan Party Style'),
  (2, 'Moderate Party Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2),
  (2, 1),
  (2, 3);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Precinct 1 Bipartisan Party'),
  (2, 'Precinct 1'),
  (2, 'Precinct 1 Moderate Party');

copy Ballot from stdin CSV;
1,1,true
2,2,true
3,1,true
4,1,true
5,2,true
6,2,true
7,2,true
8,2,true
9,2,true
10,2,true
11,2,true
12,1,true
13,1,true
14,2,true
15,2,true
16,2,true
17,1,true
18,1,true
19,1,true
20,2,true
21,2,true
22,1,true
23,1,true
24,2,true
25,1,true
\.

copy VoterInput from stdin CSV;
1,2,1
1,4,2
1,1,3
1,3,4
1,7,1
1,8,2
1,9,3
1,6,4
1,5,5
2,1,1
2,4,2
2,3,3
2,2,4
2,12,1
2,13,2
2,14,3
2,11,4
2,10,5
3,3,1
3,4,2
3,1,3
3,2,4
3,9,1
3,5,2
3,8,3
3,6,4
3,7,5
4,4,1
4,3,2
4,2,3
4,1,4
4,9,1
4,5,2
4,6,3
4,8,4
4,7,5
5,2,1
5,4,2
5,3,3
5,1,4
5,12,1
5,10,2
5,13,3
5,14,4
5,11,5
6,1,1
6,2,2
6,3,3
6,4,4
6,12,1
6,10,2
6,14,3
6,11,4
6,13,5
7,1,1
7,3,2
7,2,3
7,4,4
7,11,1
7,14,2
7,12,3
7,10,4
7,13,5
8,2,1
8,4,2
8,1,3
8,3,4
8,11,1
8,13,2
8,14,3
8,10,4
8,12,5
9,2,1
9,3,2
9,4,3
9,1,4
9,11,1
9,13,2
9,12,3
9,10,4
9,14,5
10,4,1
10,1,2
10,3,3
10,2,4
10,11,1
10,12,2
10,10,3
10,13,4
10,14,5
11,4,1
11,1,2
11,3,3
11,2,4
11,11,1
11,10,2
11,12,3
11,14,4
11,13,5
12,2,1
12,3,2
12,4,3
12,1,4
12,9,1
12,6,2
12,8,3
12,7,4
12,5,5
13,2,1
13,3,2
13,4,3
13,1,4
13,7,1
13,5,2
13,8,3
13,9,4
13,6,5
14,3,1
14,1,2
14,2,3
14,4,4
14,14,1
14,12,2
14,13,3
14,10,4
14,11,5
15,4,1
15,3,2
15,1,3
15,2,4
15,12,1
15,14,2
15,13,3
15,11,4
15,10,5
16,2,1
16,4,2
16,3,3
16,1,4
16,11,1
16,12,2
16,10,3
16,13,4
16,14,5
17,4,1
17,3,2
17,2,3
17,1,4
17,7,1
17,9,2
17,8,3
17,5,4
17,6,5
18,2,1
18,1,2
18,3,3
18,4,4
18,7,1
18,6,2
18,9,3
18,8,4
18,5,5
19,2,1
19,3,2
19,4,3
19,1,4
19,7,1
19,9,2
19,6,3
19,8,4
19,5,5
20,4,1
20,1,2
20,3,3
20,2,4
20,13,1
20,10,2
20,14,3
20,11,4
20,12,5
21,3,1
21,4,2
21,1,3
21,2,4
21,13,1
21,12,2
21,10,3
21,11,4
21,14,5
22,2,1
22,4,2
22,1,3
22,3,4
22,7,1
22,5,2
22,8,3
22,6,4
22,9,5
23,1,1
23,2,2
23,3,3
23,4,4
23,7,1
23,8,2
23,9,3
23,5,4
23,6,5
24,1,1
24,4,2
24,2,3
24,3,4
24,13,1
24,14,2
24,10,3
24,12,4
24,11,5
25,2,1
25,4,2
25,1,3
25,3,4
25,7,1
25,5,2
25,6,3
25,8,4
25,9,5
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
