\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-Primary-NofM.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small primary election with N-of-M voting, no write-ins, no rejected ballots.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into ReportingContext values
  ('Precinct 1'),
  ('Precinct 1 Bipartisan Party'),
  ('Precinct 1 Moderate Party');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Nonpartisan committee, vote for at most 2', 'N-of-M', 2, 0, false),
  (2, 'Bipartisan Party subcommittee, vote for at most 3', 'N-of-M', 3, 0, false),
  (3, 'Moderate Party subcommittee, vote for at most 3', 'N-of-M', 3, 0, false);

copy Choice from stdin CSV;
1,1,Choice #1 nonpartisan committee,,false
2,1,Choice #2 nonpartisan committee,,false
3,1,Choice #3 nonpartisan committee,,false
4,1,Choice #4 nonpartisan committee,,false
5,2,Choice #1 Bipartisan Party subcommittee,,false
6,2,Choice #2 Bipartisan Party subcommittee,,false
7,2,Choice #3 Bipartisan Party subcommittee,,false
8,2,Choice #4 Bipartisan Party subcommittee,,false
9,2,Choice #5 Bipartisan Party subcommittee,,false
10,3,Choice #1 Moderate Party subcommittee,,false
11,3,Choice #2 Moderate Party subcommittee,,false
12,3,Choice #3 Moderate Party subcommittee,,false
13,3,Choice #4 Moderate Party subcommittee,,false
14,3,Choice #5 Moderate Party subcommittee,,false
\.

insert into BallotStyle (StyleId, Name) values
  (1, 'Bipartisan Party Style'),
  (2, 'Moderate Party Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2),
  (2, 1),
  (2, 3);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Precinct 1 Bipartisan Party'),
  (2, 'Precinct 1'),
  (2, 'Precinct 1 Moderate Party');

copy Ballot from stdin CSV;
1,2,true
2,1,true
3,2,true
4,1,true
5,2,true
6,1,true
7,2,true
8,2,true
9,2,true
10,1,true
11,1,true
12,1,true
13,2,true
14,2,true
15,2,true
16,2,true
17,1,true
18,2,true
19,2,true
20,2,true
21,1,true
22,1,true
23,2,true
24,1,true
25,2,true
\.

copy VoterInput from stdin CSV;
1,3,1
1,4,1
1,12,1
1,13,1
1,14,1
2,3,1
2,4,1
2,7,1
2,8,1
2,9,1
3,3,1
3,4,1
3,12,1
3,13,1
3,14,1
4,3,1
4,4,1
4,7,1
4,8,1
4,9,1
5,3,1
5,4,1
5,12,1
5,13,1
5,14,1
6,2,1
6,4,1
6,6,1
6,8,1
6,9,1
7,3,1
7,4,1
7,11,1
7,13,1
7,14,1
8,2,1
8,4,1
8,12,1
8,13,1
8,14,1
9,3,1
9,4,1
9,11,1
9,13,1
9,14,1
10,2,1
10,4,1
10,7,1
10,8,1
10,9,1
11,3,1
11,4,1
11,6,1
11,8,1
11,9,1
12,2,1
12,4,1
12,7,1
12,8,1
12,9,1
13,3,1
13,4,1
13,12,1
13,13,1
13,14,1
14,2,1
14,4,1
14,11,1
14,13,1
14,14,1
15,3,1
15,4,1
15,12,1
15,13,1
15,14,1
16,1,1
16,2,1
16,10,1
16,11,1
16,14,1
17,3,1
17,4,1
17,5,1
17,6,1
17,9,1
18,1,1
18,2,1
18,12,1
18,13,1
18,14,1
19,3,1
19,4,1
19,10,1
19,11,1
19,14,1
20,1,1
20,2,1
20,12,1
20,13,1
20,14,1
21,3,1
21,4,1
21,7,1
21,8,1
21,9,1
22,1,1
22,2,1
22,5,1
22,6,1
22,9,1
23,3,1
23,4,1
23,10,1
23,11,1
23,14,1
24,1,1
24,2,1
24,7,1
24,8,1
24,9,1
25,3,1
25,4,1
25,12,1
25,13,1
25,14,1
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
