\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-Primary-Cumulative.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small primary election with cumulative voting, no write-ins, no'
\echo 'rejected ballots.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into ReportingContext values
  ('Precinct 1'),
  ('Precinct 1 Bipartisan Party'),
  ('Precinct 1 Moderate Party');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Nonpartisan office, vote for at most 1', 'N-of-M', 1, 0, false),
  (2, 'Nominee of the Bipartisan Party, vote for at most 2', 'N-of-M', 2, 0, false),
  (3, 'Nominee of the Moderate Party, cast at most 2 votes', 'Cumulative', 2, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  3, 'Nada Zayro', false),
  (1,  2, 'Oona Won', false),
  (2,  2, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false),
  (5,  3, 'Wu Fife', false),
  (6,  3, 'Lu Sigs', false),
  (7,  3, 'Chi Sefen', false),
  (8,  2, 'Bah Eyt', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Bipartisan Party Style'),
  (2, 'Moderate Party Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2),
  (2, 1),
  (2, 3);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Precinct 1 Bipartisan Party'),
  (2, 'Precinct 1'),
  (2, 'Precinct 1 Moderate Party');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 2, true),
  (6, 2, true),
  (7, 2, true),
  (8, 2, true),
  (9, 2, true),
  (10, 2, true),
  (11, 2, true),
  (12, 2, true),
  (13, 2, true),
  (14, 2, true),
  (15, 2, true),
  (16, 2, true),
  (17, 2, true),
  (18, 1, true),
  (19, 1, true),
  (20, 1, true),
  (21, 1, true),
  (22, 1, true),
  (23, 1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (0, 8, 1),
  (1, 3, 1),
  (1, 1, 1),
  (2, 4, 1),
  (2, 2, 1),
  (3, 4, 1),
  (3, 2, 1),
  (4, 3, 1),
  (4, 8, 1),
  (5, 4, 1),
  (6, 4, 1),
  (7, 3, 1),
  (8, 3, 1),
  (8, 4, 1),
  (9, 5, 2),
  (10, 5, 2),
  (11, 5, 1),
  (11, 7, 1),
  (12, 6, 2),
  (13, 6, 2),
  (14, 6, 2),
  (15, 7, 2),
  (16, 7, 2),
  (17, 7, 2),
  (18, 8, 1),
  (19, 8, 1),
  (20, 8, 1),
  (21, 8, 1),
  (22, 8, 1),
  (23, 8, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
