\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-AbsenteeBySpecialPrecinct-RankedOrder.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small ranked order contest with absentee ballots via a special precinct'
\echo 'and ballot style.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1'),
  ('Absentee Precinct'),
  ('Jurisdiction');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'President, rank in order of preference', 'Ranked order', 1, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (1,  1, 'Nada Zayro', false),
  (2,  1, 'Oona Won', false),
  (3,  1, 'Beeso Tu', false),
  (4,  1, 'Tayra Tree', false),
  (5,  1, 'Car Tay Fower', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style'),
  (2, 'Absentee Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (2, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Jurisdiction'),
  (2, 'Absentee Precinct'),
  (2, 'Jurisdiction');

insert into Ballot (BallotId, StyleId, Accepted) values
  (1, 2, true),
  (2, 1, true),
  (3, 2, true),
  (4, 1, true),
  (5, 2, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10, 1, true),
  (11, 1, true),
  (12, 1, true);

copy VoterInput from stdin CSV;
1,2,1
1,3,2
1,1,3
1,4,4
1,5,5
2,2,1
2,5,2
2,1,3
2,3,4
2,4,5
3,5,1
3,4,2
3,3,3
3,1,4
3,2,5
4,5,1
4,2,2
4,1,3
4,4,4
4,3,5
5,5,1
5,4,2
5,1,3
5,2,4
5,3,5
6,1,1
6,5,2
6,3,3
6,2,4
6,4,5
7,3,1
7,5,2
7,4,3
7,1,4
7,2,5
8,1,1
8,3,2
8,4,3
8,2,4
8,5,5
9,2,1
9,5,2
9,3,3
9,4,4
9,1,5
10,5,1
10,4,2
10,3,3
10,1,4
10,2,5
11,5,1
11,3,2
11,2,3
11,1,4
11,4,5
12,5,1
12,3,2
12,2,3
12,1,4
12,4,5
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Jurisdiction"
\i Infrastructure-TestFooter.sql
