\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-AbsenteeByCategory-Cumulative.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small Cumulative contest, N=3, no write-ins, no rejected ballots, three'
\echo 'absentee ballots via categories.'
\echo 'Ballot styles:  1'
\echo 'Reporting contexts:  1'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Parking Committee, cast at most 3 votes', 'Cumulative', 3, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (1,  1, 'Oona Won', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false),
  (5,  1, 'Joe Nahyn', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 1, 1),
  (2, 2, 1),
  (2, 3, 1),
  (3, 5, 3),
  (4, 3, 1),
  (4, 4, 1),
  (5, 5, 3),
  (6, 4, 1),
  (6, 5, 1),
  (7, 4, 1),
  (7, 5, 2),
  (8, 0, 1),
  (8, 1, 1),
  (8, 2, 1),
  (8, 3, 1),
  (9, 2, 1),
  (9, 3, 1),
  (9, 4, 1);

insert into BallotCategoryAssociation (BallotId, Category) values
  (1, 'Absentee'),
  (3, 'Absentee'),
  (5, 'Absentee');

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
