// $Id: parser.hh 374 2007-09-04 16:59:24Z dflater $

#ifndef TGParserHeader
#define TGParserHeader


#include <stdio.h>
#include <string>
#include <vector>


namespace TGParser {

  struct Contest {
    enum Level        {systemExtent, district, precinct};
    enum Logic        {NofM, cumulative, rankedOrder};
    enum Distribution {uniformRandom, triangle};

    unsigned long N;
    unsigned long M;
    unsigned long W;
    Level level;
    Logic logic;
    Distribution distribution;

    Contest(): N(0), M(0), W(0), level(systemExtent), logic(NofM),
      distribution(uniformRandom) {};
  };

  typedef std::vector<Contest> ContestVector;

  struct Election {
    enum Distribution {uniformRandom, even};

    unsigned long ballots;
    unsigned long districts;
    unsigned long precincts;
    ContestVector contests;
    Distribution ballotDistribution;
    Distribution precinctDistribution;

    Election(): ballots(0), districts(0), precincts(0),
      ballotDistribution(uniformRandom), precinctDistribution(uniformRandom)
      {};
  };

}


extern TGParser::Election election;
extern FILE *yyin;
int yyparse();

// ECHO is defined by /usr/include/asm/termbits.h; we don't want that.
#undef ECHO
#define ECHO  /* Don't echo error text */


#endif
