// $Id: Contest.cc 374 2007-09-04 16:59:24Z dflater $

#include <assert.h>
#include "Contest.hh"
#include "misc.hh"


Contest::Contest (const TGParser::Contest &contest_in,
		  unsigned long districtOrPrecinct_in,
		  unsigned long &contestSerial,
		  unsigned long &choiceSerial):
  id(contestSerial++),
  N(contest_in.N),
  W(contest_in.W),
  firstChoice(choiceSerial),
  level(contest_in.level),
  logic(contest_in.logic),
  distribution(contest_in.distribution),
  districtOrPrecinct(districtOrPrecinct_in) {

  description = "Contest #" + stringify(id);
  switch (level) {
  case TGParser::Contest::systemExtent:
    break;
  case TGParser::Contest::district:
  case TGParser::Contest::precinct:
    description += std::string(" (specific to ")
		   + (level == TGParser::Contest::district ? "District"
		      : "Precinct")
		   + ' ' + stringify(districtOrPrecinct) + ')';
    break;
  default:
    assert (false);
  }
  choiceSerial += contest_in.M;
  lastChoice = choiceSerial - 1;
  tallies.resize (contest_in.M, 0);
}


bool pertinent (const Contest &contest,
		unsigned long district,
		unsigned long precinct) {
  return (contest.level == TGParser::Contest::systemExtent ||
	   (contest.level == TGParser::Contest::district &&
            contest.districtOrPrecinct == district) ||
	   (contest.level == TGParser::Contest::precinct &&
            contest.districtOrPrecinct == precinct));
}
