\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-samples-CecilRPrimary1998.sql 467 2008-01-15 15:17:45Z dflater $'
\echo
\echo 'Customized TestGenerator-generated test.  Test spec follows:'
\echo
\echo '  // Test spec based on Cecil County, MD sample ballot for Republican'
\echo '  // primary election, 1st congressional district, legislative district'
\echo '  // 35, 1998-09-15.'
\echo '  // http://vote.nist.gov/ballots_n/MD_cecil19980915primrep.pdf'
\echo '  '
\echo '  // This sample is noteworthy for unopposed candidates, including a'
\echo '  // 7-of-7 contest.'
\echo '  '
\echo '  // The generated test does not include anything specific to primary'
\echo '  // elections.'
\echo '  '
\echo '  // This test does not attempt to replicate the reporting structure.'
\echo '  districts=3'
\echo '  precincts=5'
\echo '  precinctDistribution=Even'
\echo '  '
\echo '  ballots=100'
\echo '  '
\echo '  (N=1 M=2 distribution=Triangle)  // Governor / Lt. Governor'
\echo '  (N=1 M=6 distribution=Triangle)  // Comptroller'
\echo '  (N=1 M=1)                        // Attorney General (unopposed)'
\echo '  (N=1 M=10 distribution=Triangle) // U.S. Senator'
\echo '  (level=D N=1 M=1)                // Representative in Congress (unopposed)'
\echo '  (level=D N=1 M=2 distribution=Triangle)  // State Senator'
\echo '  (level=P N=1 M=1)                // House of Delegates (unopposed)'
\echo '  (N=1 M=1)                        // County Commissioner District 1 (unopposed)'
\echo '  (N=1 M=3 distribution=Triangle)  // County Commissioner District 2'
\echo '  (N=1 M=1)                        // County Commissioner District 3 (unopposed)'
\echo '  (N=1 M=7 distribution=Triangle)  // Judge of the Circuit Court'
\echo '  (N=1 M=2 distribution=Triangle)  // Treasurer'
\echo '  (N=1 M=1)                        // State''s Attorney (unopposed)'
\echo '  (N=1 M=1)                        // Register of Wills (unopposed)'
\echo '  (N=1 M=1)                        // Sheriff (unopposed)'
\echo '  (N=7 M=7 distribution=Triangle)  // Republican Central Committee (unopposed)'
\echo
\echo 'Contest and candidate names were copied in from the sample ballot but'
\echo 'the vote totals are synthetic and have no relationship to the actual'
\echo 'election results.  In addition, the county commissioner contests were'
\echo 'all reproduced in every ballot style instead of being assigned to'
\echo 'districts.'

\i Infrastructure-VoteSchema.sql

copy ReportingContext from stdin CSV;
Legislative Sub District 35B
Legislative Sub District 2
Legislative Sub District 3
Legislative Sub District 4
Legislative Sub District 5
Congressional District 1
Congressional District 2
Congressional District 3
Jurisdiction
\.

copy Contest from stdin CSV;
1,"GOVERNOR/LT. GOVERNOR
VOTE FOR ONE PAIR",N-of-M,1,0,false
2,"COMPTROLLER
VOTE FOR ONE",N-of-M,1,0,false
3,"ATTORNEY GENERAL
VOTE FOR ONE",N-of-M,1,0,false
4,"U.S. SENATOR
VOTE FOR ONE",N-of-M,1,0,false
5,"REPRESENTATIVE IN CONGRESS, 1ST CONGRESSIONAL DISTRICT
VOTE FOR ONE",N-of-M,1,0,false
6,"REPRESENTATIVE IN CONGRESS, 2ND CONGRESSIONAL DISTRICT
VOTE FOR ONE",N-of-M,1,0,false
7,"REPRESENTATIVE IN CONGRESS, 3RD CONGRESSIONAL DISTRICT
VOTE FOR ONE",N-of-M,1,0,false
8,"STATE SENATOR LEGISLATIVE DISTRICT 35
VOTE FOR ONE",N-of-M,1,0,false
9,"STATE SENATOR LEGISLATIVE DISTRICT 2
VOTE FOR ONE",N-of-M,1,0,false
10,"STATE SENATOR LEGISLATIVE DISTRICT 3
VOTE FOR ONE",N-of-M,1,0,false
11,"HOUSE OF DELEGATES LEGISLATIVE SUB DISTRICT 35B
VOTE FOR ONE",N-of-M,1,0,false
12,"HOUSE OF DELEGATES LEGISLATIVE SUB DISTRICT 2
VOTE FOR ONE",N-of-M,1,0,false
13,"HOUSE OF DELEGATES LEGISLATIVE SUB DISTRICT 3
VOTE FOR ONE",N-of-M,1,0,false
14,"HOUSE OF DELEGATES LEGISLATIVE SUB DISTRICT 4
VOTE FOR ONE",N-of-M,1,0,false
15,"HOUSE OF DELEGATES LEGISLATIVE SUB DISTRICT 5
VOTE FOR ONE",N-of-M,1,0,false
16,"COUNTY COMMISSIONER DISTRICT 1
VOTE FOR ONE",N-of-M,1,0,false
17,"COUNTY COMMISSIONER DISTRICT 2
VOTE FOR ONE",N-of-M,1,0,false
18,"COUNTY COMMISSIONER DISTRICT 3
VOTE FOR ONE",N-of-M,1,0,false
19,"JUDGE OF THE CIRCUIT COURT JUDICIAL CIRCUIT 2
VOTE FOR ONE",N-of-M,1,0,false
20,"TREASURER
VOTE FOR ONE",N-of-M,1,0,false
21,"STATE'S ATTORNEY
VOTE FOR ONE",N-of-M,1,0,false
22,"REGISTER OF WILLS
VOTE FOR ONE",N-of-M,1,0,false
23,"SHERIFF
VOTE FOR ONE",N-of-M,1,0,false
24,"REPUBLICAN CENTRAL COMMITTEE
VOTE FOR NO MORE THAN SEVEN",N-of-M,7,0,false
\.

copy Choice from stdin CSV;
1,1,CHARLES I. ECKER Howard County BARBARA WINDSOR Frederick County,,false
2,1,ELLEN R. SAUERBREY Baltimore County RICHARD D. BENNETT Baltimore County,,false
3,2,ARDATH M. CADE Anne Arundel County,,false
4,2,LARRY MARK EPSTEIN Baltimore County,,false
5,2,ROBERT W. KEARNS Queen Anne's County,,false
6,2,TIMOTHY R. MAYBERRY Washington County,,false
7,2,MICHAEL STEELE Prince George's County,,false
8,2,EUGENE ROBERT ZARWELL Anne Arundel County,,false
9,3,PAUL H. RAPPAPORT Howard County (UNOPPOSED),,false
10,4,BARRY STEVE ASBURY Baltimore County,,false
11,4,MICHAEL GLOTH Carroll County,,false
12,4,HOWARD DAVID GREYBER Montgomery County,,false
13,4,GEORGE LIEBMANN Baltimore City,,false
14,4,BRADLYN McCLANAHAN Anne Arundel County,,false
15,4,ROSS Z. PIERPONT Baltimore County,,false
16,4,THOMAS SCOTT Baltimore County,,false
17,4,JOHN STAFFORD Howard County,,false
18,4,JOHN TAYLOR Anne Arundel County,,false
19,4,KENNETH WAYMAN Carroll County,,false
20,5,WAYNE T. GILCHREST Kent County (UNOPPOSED),,false
21,6,District 2 Representative (UNOPPOSED),,false
22,7,District 3 Representative (UNOPPOSED),,false
23,8,GWENDALYNNE G. CORKRAN Harford County,,false
24,8,J. ROBERT HOOPER Harford County,,false
25,9,District 2 State Senator #1,,false
26,9,District 2 State Senator #2,,false
27,10,District 3 State Senator #1,,false
28,10,District 3 State Senator #2,,false
29,11,ROBERT H. WARD (UNOPPOSED),,false
30,12,Sub District 2 Delegate (UNOPPOSED),,false
31,13,Sub District 3 Delegate (UNOPPOSED),,false
32,14,Sub District 4 Delegate (UNOPPOSED),,false
33,15,Sub District 5 Delegate (UNOPPOSED),,false
34,16,JOHN W. McCARLEY JR. (UNOPPOSED),,false
35,17,GEORGE F. FITZROY,,false
36,17,HARRY HEPBRON,,false
37,17,WILLIAM M. KNARR,,false
38,18,DIANE D. CARABETTA (UNOPPOSED),,false
39,19,KEITH A. BAYNES,,false
40,19,RICHARD ELI JACKSON,,false
41,19,O. ROBERT LIDUMS,,false
42,19,JOSEPH J. MAHONEY,,false
43,19,FINDLAY M. McCOOL,,false
44,19,DAVID H. PARRACK,,false
45,19,DWIGHT E. THOMEY,,false
46,20,LARRY L. TRUSLOW JR.,,false
47,20,CRAIG W. WHITEFORD,,false
48,21,KARL H. FOCKLER (UNOPPOSED),,false
49,22,ADRIENNE L. BOYD (UNOPPOSED),,false
50,23,WILLIAM J. KILLOUGH (UNOPPOSED),,false
51,24,CLARA E. CAMPBELL (UNOPPOSED),,false
52,24,RANDALL F. LANE JR. (UNOPPOSED),,false
53,24,JOHN W. McCARLEY JR.(UNOPPOSED),,false
54,24,VIRGINIA H. SANDERS (UNOPPOSED),,false
55,24,LARRY L. TRUSLOW JR. (UNOPPOSED),,false
56,24,JOHN B. UPP (UNOPPOSED),,false
57,24,INGO ZEISE (UNOPPOSED),,false
\.

copy BallotStyle from stdin CSV;
1,Legislative Sub District 35B style
2,Legislative Sub District 2 style
3,Legislative Sub District 3 style
4,Legislative Sub District 4 style
5,Legislative Sub District 5 style
\.

copy BallotStyleContestAssociation from stdin CSV;
1,1
1,2
1,3
1,4
1,5
1,8
1,11
1,16
1,17
1,18
1,19
1,20
1,21
1,22
1,23
1,24
2,1
2,2
2,3
2,4
2,6
2,9
2,12
2,16
2,17
2,18
2,19
2,20
2,21
2,22
2,23
2,24
3,1
3,2
3,3
3,4
3,6
3,9
3,13
3,16
3,17
3,18
3,19
3,20
3,21
3,22
3,23
3,24
4,1
4,2
4,3
4,4
4,7
4,10
4,14
4,16
4,17
4,18
4,19
4,20
4,21
4,22
4,23
4,24
5,1
5,2
5,3
5,4
5,7
5,10
5,15
5,16
5,17
5,18
5,19
5,20
5,21
5,22
5,23
5,24
\.

copy BallotStyleReportingContextAssociation from stdin CSV;
1,Legislative Sub District 35B
1,Congressional District 1
1,Jurisdiction
2,Legislative Sub District 2
2,Congressional District 2
2,Jurisdiction
3,Legislative Sub District 3
3,Congressional District 2
3,Jurisdiction
4,Legislative Sub District 4
4,Congressional District 3
4,Jurisdiction
5,Legislative Sub District 5
5,Congressional District 3
5,Jurisdiction
\.

copy Ballot from stdin CSV;
1,1,true
2,5,true
3,4,true
4,3,true
5,1,true
6,5,true
7,4,true
8,5,true
9,5,true
10,4,true
11,5,true
12,5,true
13,1,true
14,5,true
15,4,true
16,5,true
17,4,true
18,2,true
19,2,true
20,3,true
21,4,true
22,1,true
23,5,true
24,3,true
25,3,true
26,5,true
27,1,true
28,3,true
29,5,true
30,3,true
31,4,true
32,2,true
33,3,true
34,3,true
35,4,true
36,1,true
37,2,true
38,4,true
39,3,true
40,5,true
41,1,true
42,2,true
43,5,true
44,4,true
45,3,true
46,1,true
47,2,true
48,1,true
49,1,true
50,5,true
51,1,true
52,5,true
53,2,true
54,5,true
55,3,true
56,2,true
57,2,true
58,3,true
59,5,true
60,1,true
61,1,true
62,2,true
63,3,true
64,2,true
65,3,true
66,3,true
67,1,true
68,5,true
69,3,true
70,1,true
71,4,true
72,1,true
73,2,true
74,4,true
75,3,true
76,1,true
77,5,true
78,1,true
79,2,true
80,2,true
81,2,true
82,2,true
83,3,true
84,2,true
85,2,true
86,2,true
87,1,true
88,1,true
89,1,true
90,1,true
91,4,true
92,3,true
93,2,true
94,4,true
95,2,true
96,4,true
97,4,true
98,4,true
99,3,true
100,2,true
\.

copy VoterInput from stdin CSV;
1,2,1
1,8,1
1,9,1
1,19,1
1,20,1
1,24,1
1,29,1
1,34,1
1,37,1
1,38,1
1,45,1
1,47,1
1,48,1
1,49,1
1,50,1
1,51,1
1,52,1
1,53,1
1,54,1
1,55,1
1,56,1
1,57,1
2,2,1
2,8,1
2,9,1
2,18,1
2,22,1
2,28,1
2,33,1
2,34,1
2,37,1
2,38,1
2,45,1
2,47,1
2,48,1
2,49,1
2,50,1
2,51,1
2,52,1
2,53,1
2,54,1
2,55,1
2,56,1
2,57,1
3,2,1
3,8,1
3,9,1
3,19,1
3,22,1
3,28,1
3,32,1
3,34,1
3,37,1
3,38,1
3,45,1
3,47,1
3,48,1
3,49,1
3,50,1
3,51,1
3,52,1
3,53,1
3,54,1
3,55,1
3,56,1
3,57,1
4,2,1
4,8,1
4,9,1
4,17,1
4,21,1
4,26,1
4,31,1
4,34,1
4,37,1
4,38,1
4,44,1
4,47,1
4,48,1
4,49,1
4,50,1
4,51,1
4,52,1
4,53,1
4,54,1
4,55,1
4,56,1
4,57,1
5,2,1
5,7,1
5,9,1
5,18,1
5,20,1
5,24,1
5,29,1
5,34,1
5,37,1
5,38,1
5,45,1
5,47,1
5,48,1
5,49,1
5,50,1
5,51,1
5,52,1
5,53,1
5,54,1
5,55,1
5,56,1
5,57,1
6,2,1
6,8,1
6,9,1
6,19,1
6,22,1
6,28,1
6,33,1
6,34,1
6,37,1
6,38,1
6,44,1
6,47,1
6,48,1
6,49,1
6,50,1
6,51,1
6,52,1
6,53,1
6,54,1
6,55,1
6,56,1
6,57,1
7,2,1
7,7,1
7,9,1
7,16,1
7,22,1
7,28,1
7,32,1
7,34,1
7,37,1
7,38,1
7,45,1
7,47,1
7,48,1
7,49,1
7,50,1
7,51,1
7,52,1
7,53,1
7,54,1
7,55,1
7,56,1
7,57,1
8,2,1
8,8,1
8,9,1
8,17,1
8,22,1
8,28,1
8,33,1
8,34,1
8,37,1
8,38,1
8,44,1
8,47,1
8,48,1
8,49,1
8,50,1
8,51,1
8,52,1
8,53,1
8,54,1
8,55,1
8,56,1
8,57,1
9,2,1
9,7,1
9,9,1
9,18,1
9,22,1
9,28,1
9,33,1
9,34,1
9,37,1
9,38,1
9,45,1
9,47,1
9,48,1
9,49,1
9,50,1
9,51,1
9,52,1
9,53,1
9,54,1
9,55,1
9,56,1
9,57,1
10,2,1
10,8,1
10,9,1
10,19,1
10,22,1
10,28,1
10,32,1
10,34,1
10,37,1
10,38,1
10,43,1
10,47,1
10,48,1
10,49,1
10,50,1
10,51,1
10,52,1
10,53,1
10,54,1
10,55,1
10,56,1
10,57,1
11,2,1
11,7,1
11,9,1
11,15,1
11,22,1
11,28,1
11,33,1
11,34,1
11,37,1
11,38,1
11,44,1
11,47,1
11,48,1
11,49,1
11,50,1
11,51,1
11,52,1
11,53,1
11,54,1
11,55,1
11,56,1
11,57,1
12,2,1
12,8,1
12,9,1
12,16,1
12,22,1
12,28,1
12,33,1
12,34,1
12,37,1
12,38,1
12,45,1
12,47,1
12,48,1
12,49,1
12,50,1
12,51,1
12,52,1
12,53,1
12,54,1
12,55,1
12,56,1
12,57,1
13,2,1
13,6,1
13,9,1
13,17,1
13,20,1
13,24,1
13,29,1
13,34,1
13,37,1
13,38,1
13,43,1
13,47,1
13,48,1
13,49,1
13,50,1
13,51,1
13,52,1
13,53,1
13,54,1
13,55,1
13,56,1
13,57,1
14,2,1
14,7,1
14,9,1
14,18,1
14,22,1
14,28,1
14,33,1
14,34,1
14,37,1
14,38,1
14,44,1
14,47,1
14,48,1
14,49,1
14,50,1
14,51,1
14,52,1
14,53,1
14,54,1
14,55,1
14,56,1
14,57,1
15,2,1
15,8,1
15,9,1
15,19,1
15,22,1
15,28,1
15,32,1
15,34,1
15,37,1
15,38,1
15,45,1
15,47,1
15,48,1
15,49,1
15,50,1
15,52,1
15,53,1
15,54,1
15,55,1
15,56,1
15,57,1
16,2,1
16,6,1
16,9,1
16,14,1
16,22,1
16,28,1
16,33,1
16,34,1
16,37,1
16,38,1
16,43,1
16,47,1
16,48,1
16,49,1
16,50,1
16,52,1
16,53,1
16,54,1
16,55,1
16,56,1
16,57,1
17,2,1
17,7,1
17,9,1
17,15,1
17,22,1
17,27,1
17,32,1
17,34,1
17,36,1
17,38,1
17,44,1
17,47,1
17,48,1
17,49,1
17,50,1
17,52,1
17,53,1
17,54,1
17,55,1
17,56,1
17,57,1
18,2,1
18,8,1
18,9,1
18,16,1
18,21,1
18,26,1
18,30,1
18,34,1
18,37,1
18,38,1
18,45,1
18,47,1
18,48,1
18,49,1
18,50,1
18,52,1
18,53,1
18,54,1
18,55,1
18,56,1
18,57,1
19,2,1
19,6,1
19,9,1
19,17,1
19,21,1
19,26,1
19,30,1
19,34,1
19,36,1
19,38,1
19,42,1
19,47,1
19,48,1
19,49,1
19,50,1
19,52,1
19,53,1
19,54,1
19,55,1
19,56,1
19,57,1
20,2,1
20,7,1
20,9,1
20,18,1
20,21,1
20,26,1
20,31,1
20,34,1
20,37,1
20,38,1
20,43,1
20,47,1
20,48,1
20,49,1
20,50,1
20,52,1
20,53,1
20,54,1
20,55,1
20,56,1
20,57,1
21,2,1
21,8,1
21,9,1
21,19,1
21,22,1
21,28,1
21,32,1
21,34,1
21,36,1
21,38,1
21,44,1
21,47,1
21,48,1
21,49,1
21,50,1
21,52,1
21,53,1
21,54,1
21,55,1
21,56,1
21,57,1
22,2,1
22,6,1
22,9,1
22,13,1
22,20,1
22,24,1
22,29,1
22,34,1
22,37,1
22,38,1
22,45,1
22,47,1
22,48,1
22,49,1
22,50,1
22,52,1
22,53,1
22,54,1
22,55,1
22,56,1
22,57,1
23,2,1
23,7,1
23,9,1
23,14,1
23,22,1
23,27,1
23,33,1
23,34,1
23,36,1
23,38,1
23,42,1
23,47,1
23,48,1
23,49,1
23,50,1
23,52,1
23,53,1
23,54,1
23,55,1
23,56,1
23,57,1
24,2,1
24,8,1
24,9,1
24,15,1
24,21,1
24,26,1
24,31,1
24,34,1
24,37,1
24,38,1
24,43,1
24,47,1
24,48,1
24,49,1
24,50,1
24,52,1
24,53,1
24,54,1
24,55,1
24,56,1
24,57,1
25,2,1
25,5,1
25,9,1
25,16,1
25,21,1
25,26,1
25,31,1
25,34,1
25,36,1
25,38,1
25,44,1
25,47,1
25,48,1
25,49,1
25,50,1
25,52,1
25,53,1
25,54,1
25,55,1
25,56,1
25,57,1
26,2,1
26,6,1
26,9,1
26,17,1
26,22,1
26,28,1
26,33,1
26,34,1
26,37,1
26,38,1
26,45,1
26,47,1
26,48,1
26,49,1
26,50,1
26,52,1
26,53,1
26,54,1
26,55,1
26,56,1
26,57,1
27,2,1
27,7,1
27,9,1
27,18,1
27,20,1
27,24,1
27,29,1
27,34,1
27,36,1
27,38,1
27,42,1
27,47,1
27,48,1
27,49,1
27,50,1
27,52,1
27,53,1
27,54,1
27,55,1
27,56,1
27,57,1
28,2,1
28,8,1
28,9,1
28,19,1
28,21,1
28,26,1
28,31,1
28,34,1
28,37,1
28,38,1
28,43,1
28,47,1
28,48,1
28,49,1
28,50,1
28,52,1
28,53,1
28,54,1
28,55,1
28,56,1
28,57,1
29,2,1
29,5,1
29,9,1
29,12,1
29,22,1
29,27,1
29,33,1
29,34,1
29,36,1
29,38,1
29,44,1
29,47,1
29,48,1
29,49,1
29,50,1
29,53,1
29,54,1
29,55,1
29,56,1
29,57,1
30,2,1
30,6,1
30,9,1
30,13,1
30,21,1
30,26,1
30,31,1
30,34,1
30,37,1
30,38,1
30,45,1
30,47,1
30,48,1
30,49,1
30,50,1
30,53,1
30,54,1
30,55,1
30,56,1
30,57,1
31,2,1
31,7,1
31,9,1
31,14,1
31,22,1
31,28,1
31,32,1
31,34,1
31,36,1
31,38,1
31,41,1
31,47,1
31,48,1
31,49,1
31,50,1
31,53,1
31,54,1
31,55,1
31,56,1
31,57,1
32,2,1
32,8,1
32,9,1
32,15,1
32,21,1
32,26,1
32,30,1
32,34,1
32,37,1
32,38,1
32,42,1
32,47,1
32,48,1
32,49,1
32,50,1
32,53,1
32,54,1
32,55,1
32,56,1
32,57,1
33,2,1
33,5,1
33,9,1
33,16,1
33,21,1
33,26,1
33,31,1
33,34,1
33,36,1
33,38,1
33,43,1
33,47,1
33,48,1
33,49,1
33,50,1
33,53,1
33,54,1
33,55,1
33,56,1
33,57,1
34,1,1
34,6,1
34,9,1
34,17,1
34,21,1
34,26,1
34,31,1
34,34,1
34,37,1
34,38,1
34,44,1
34,46,1
34,48,1
34,49,1
34,50,1
34,53,1
34,54,1
34,55,1
34,56,1
34,57,1
35,2,1
35,7,1
35,9,1
35,18,1
35,22,1
35,27,1
35,32,1
35,34,1
35,36,1
35,38,1
35,45,1
35,47,1
35,48,1
35,49,1
35,50,1
35,53,1
35,54,1
35,55,1
35,56,1
35,57,1
36,1,1
36,8,1
36,9,1
36,19,1
36,20,1
36,24,1
36,29,1
36,34,1
36,37,1
36,38,1
36,41,1
36,46,1
36,48,1
36,49,1
36,50,1
36,53,1
36,54,1
36,55,1
36,56,1
36,57,1
37,2,1
37,5,1
37,9,1
37,11,1
37,21,1
37,26,1
37,30,1
37,34,1
37,36,1
37,38,1
37,42,1
37,47,1
37,48,1
37,49,1
37,50,1
37,53,1
37,54,1
37,55,1
37,56,1
37,57,1
38,1,1
38,6,1
38,9,1
38,12,1
38,22,1
38,28,1
38,32,1
38,34,1
38,37,1
38,38,1
38,43,1
38,46,1
38,48,1
38,49,1
38,50,1
38,53,1
38,54,1
38,55,1
38,56,1
38,57,1
39,2,1
39,7,1
39,9,1
39,13,1
39,21,1
39,26,1
39,31,1
39,34,1
39,36,1
39,38,1
39,44,1
39,47,1
39,48,1
39,49,1
39,50,1
39,53,1
39,54,1
39,55,1
39,56,1
39,57,1
40,1,1
40,8,1
40,9,1
40,14,1
40,22,1
40,27,1
40,33,1
40,34,1
40,37,1
40,38,1
40,45,1
40,46,1
40,48,1
40,49,1
40,50,1
40,53,1
40,54,1
40,55,1
40,56,1
40,57,1
41,2,1
41,4,1
41,9,1
41,15,1
41,20,1
41,24,1
41,29,1
41,34,1
41,36,1
41,38,1
41,41,1
41,47,1
41,48,1
41,49,1
41,50,1
41,53,1
41,54,1
41,55,1
41,56,1
41,57,1
42,1,1
42,5,1
42,9,1
42,16,1
42,21,1
42,26,1
42,30,1
42,34,1
42,37,1
42,38,1
42,42,1
42,46,1
42,48,1
42,49,1
42,50,1
42,53,1
42,54,1
42,55,1
42,56,1
42,57,1
43,2,1
43,6,1
43,9,1
43,17,1
43,22,1
43,28,1
43,33,1
43,34,1
43,36,1
43,38,1
43,43,1
43,47,1
43,48,1
43,49,1
43,50,1
43,54,1
43,55,1
43,56,1
43,57,1
44,1,1
44,7,1
44,9,1
44,18,1
44,22,1
44,27,1
44,32,1
44,34,1
44,37,1
44,38,1
44,44,1
44,46,1
44,48,1
44,49,1
44,50,1
44,54,1
44,55,1
44,56,1
44,57,1
45,2,1
45,8,1
45,9,1
45,19,1
45,21,1
45,25,1
45,31,1
45,34,1
45,36,1
45,38,1
45,45,1
45,47,1
45,48,1
45,49,1
45,50,1
45,54,1
45,55,1
45,56,1
45,57,1
46,1,1
46,4,1
46,9,1
46,10,1
46,20,1
46,23,1
46,29,1
46,34,1
46,37,1
46,38,1
46,40,1
46,46,1
46,48,1
46,49,1
46,50,1
46,54,1
46,55,1
46,56,1
46,57,1
47,2,1
47,5,1
47,9,1
47,11,1
47,21,1
47,26,1
47,30,1
47,34,1
47,36,1
47,38,1
47,41,1
47,47,1
47,48,1
47,49,1
47,50,1
47,54,1
47,55,1
47,56,1
47,57,1
48,1,1
48,6,1
48,9,1
48,12,1
48,20,1
48,24,1
48,29,1
48,34,1
48,37,1
48,38,1
48,42,1
48,46,1
48,48,1
48,49,1
48,50,1
48,54,1
48,55,1
48,56,1
48,57,1
49,2,1
49,7,1
49,9,1
49,13,1
49,20,1
49,23,1
49,29,1
49,34,1
49,35,1
49,38,1
49,43,1
49,47,1
49,48,1
49,49,1
49,50,1
49,54,1
49,55,1
49,56,1
49,57,1
50,1,1
50,8,1
50,9,1
50,14,1
50,22,1
50,28,1
50,33,1
50,34,1
50,36,1
50,38,1
50,44,1
50,46,1
50,48,1
50,49,1
50,50,1
50,54,1
50,55,1
50,56,1
50,57,1
51,2,1
51,4,1
51,9,1
51,15,1
51,20,1
51,24,1
51,29,1
51,34,1
51,37,1
51,38,1
51,45,1
51,47,1
51,48,1
51,49,1
51,50,1
51,54,1
51,55,1
51,56,1
51,57,1
52,1,1
52,5,1
52,9,1
52,16,1
52,22,1
52,27,1
52,33,1
52,34,1
52,35,1
52,38,1
52,40,1
52,46,1
52,48,1
52,49,1
52,50,1
52,54,1
52,55,1
52,56,1
52,57,1
53,2,1
53,6,1
53,9,1
53,17,1
53,21,1
53,25,1
53,30,1
53,34,1
53,36,1
53,38,1
53,41,1
53,47,1
53,48,1
53,49,1
53,50,1
53,54,1
53,55,1
53,56,1
53,57,1
54,1,1
54,7,1
54,9,1
54,18,1
54,22,1
54,28,1
54,33,1
54,34,1
54,37,1
54,38,1
54,42,1
54,46,1
54,48,1
54,49,1
54,50,1
54,54,1
54,55,1
54,56,1
54,57,1
55,2,1
55,8,1
55,9,1
55,19,1
55,21,1
55,26,1
55,31,1
55,34,1
55,35,1
55,38,1
55,43,1
55,47,1
55,48,1
55,49,1
55,50,1
55,54,1
55,55,1
55,56,1
55,57,1
56,1,1
56,4,1
56,9,1
56,21,1
56,25,1
56,30,1
56,34,1
56,36,1
56,38,1
56,44,1
56,46,1
56,48,1
56,49,1
56,50,1
56,54,1
56,55,1
56,56,1
56,57,1
57,2,1
57,5,1
57,9,1
57,21,1
57,26,1
57,30,1
57,34,1
57,37,1
57,38,1
57,45,1
57,47,1
57,48,1
57,49,1
57,50,1
57,55,1
57,56,1
57,57,1
58,1,1
58,6,1
58,9,1
58,21,1
58,25,1
58,31,1
58,34,1
58,35,1
58,38,1
58,40,1
58,46,1
58,48,1
58,49,1
58,50,1
58,55,1
58,56,1
58,57,1
59,2,1
59,7,1
59,9,1
59,22,1
59,27,1
59,33,1
59,34,1
59,36,1
59,38,1
59,41,1
59,47,1
59,48,1
59,49,1
59,50,1
59,55,1
59,56,1
59,57,1
60,1,1
60,8,1
60,9,1
60,20,1
60,23,1
60,29,1
60,34,1
60,37,1
60,38,1
60,42,1
60,46,1
60,48,1
60,49,1
60,50,1
60,55,1
60,56,1
60,57,1
61,2,1
61,3,1
61,9,1
61,20,1
61,24,1
61,29,1
61,34,1
61,35,1
61,38,1
61,43,1
61,47,1
61,48,1
61,49,1
61,50,1
61,55,1
61,56,1
61,57,1
62,1,1
62,4,1
62,9,1
62,21,1
62,26,1
62,30,1
62,34,1
62,36,1
62,38,1
62,44,1
62,46,1
62,48,1
62,49,1
62,50,1
62,55,1
62,56,1
62,57,1
63,2,1
63,5,1
63,9,1
63,21,1
63,25,1
63,31,1
63,34,1
63,37,1
63,38,1
63,45,1
63,47,1
63,48,1
63,49,1
63,50,1
63,55,1
63,56,1
63,57,1
64,1,1
64,6,1
64,9,1
64,21,1
64,26,1
64,30,1
64,34,1
64,35,1
64,38,1
64,39,1
64,46,1
64,48,1
64,49,1
64,50,1
64,55,1
64,56,1
64,57,1
65,2,1
65,7,1
65,9,1
65,21,1
65,25,1
65,31,1
65,34,1
65,36,1
65,38,1
65,40,1
65,47,1
65,48,1
65,49,1
65,50,1
65,55,1
65,56,1
65,57,1
66,1,1
66,8,1
66,9,1
66,21,1
66,26,1
66,31,1
66,34,1
66,37,1
66,38,1
66,41,1
66,46,1
66,48,1
66,49,1
66,50,1
66,55,1
66,56,1
66,57,1
67,2,1
67,3,1
67,9,1
67,20,1
67,23,1
67,29,1
67,34,1
67,35,1
67,38,1
67,42,1
67,47,1
67,48,1
67,49,1
67,50,1
67,55,1
67,56,1
67,57,1
68,1,1
68,4,1
68,9,1
68,22,1
68,28,1
68,33,1
68,34,1
68,36,1
68,38,1
68,43,1
68,46,1
68,48,1
68,49,1
68,50,1
68,55,1
68,56,1
68,57,1
69,2,1
69,5,1
69,9,1
69,21,1
69,25,1
69,31,1
69,34,1
69,37,1
69,38,1
69,44,1
69,47,1
69,48,1
69,49,1
69,50,1
69,55,1
69,56,1
69,57,1
70,1,1
70,6,1
70,9,1
70,20,1
70,24,1
70,29,1
70,34,1
70,35,1
70,38,1
70,45,1
70,46,1
70,48,1
70,49,1
70,50,1
70,55,1
70,56,1
70,57,1
71,2,1
71,7,1
71,9,1
71,22,1
71,27,1
71,32,1
71,34,1
71,36,1
71,38,1
71,39,1
71,47,1
71,48,1
71,49,1
71,50,1
71,56,1
71,57,1
72,1,1
72,8,1
72,9,1
72,20,1
72,23,1
72,29,1
72,34,1
72,37,1
72,38,1
72,40,1
72,46,1
72,48,1
72,49,1
72,50,1
72,56,1
72,57,1
73,2,1
73,3,1
73,9,1
73,21,1
73,26,1
73,30,1
73,34,1
73,35,1
73,38,1
73,41,1
73,47,1
73,48,1
73,49,1
73,50,1
73,56,1
73,57,1
74,1,1
74,4,1
74,9,1
74,22,1
74,28,1
74,32,1
74,34,1
74,36,1
74,38,1
74,42,1
74,46,1
74,48,1
74,49,1
74,50,1
74,56,1
74,57,1
75,2,1
75,5,1
75,9,1
75,21,1
75,25,1
75,31,1
75,34,1
75,37,1
75,38,1
75,43,1
75,47,1
75,48,1
75,49,1
75,50,1
75,56,1
75,57,1
76,1,1
76,6,1
76,9,1
76,20,1
76,24,1
76,29,1
76,34,1
76,35,1
76,38,1
76,44,1
76,46,1
76,48,1
76,49,1
76,50,1
76,56,1
76,57,1
77,2,1
77,7,1
77,9,1
77,22,1
77,27,1
77,33,1
77,34,1
77,36,1
77,38,1
77,45,1
77,47,1
77,48,1
77,49,1
77,50,1
77,56,1
77,57,1
78,1,1
78,8,1
78,9,1
78,20,1
78,23,1
78,29,1
78,34,1
78,37,1
78,38,1
78,39,1
78,46,1
78,48,1
78,49,1
78,50,1
78,56,1
78,57,1
79,2,1
79,3,1
79,9,1
79,21,1
79,26,1
79,30,1
79,34,1
79,35,1
79,38,1
79,40,1
79,47,1
79,48,1
79,49,1
79,50,1
79,56,1
79,57,1
80,1,1
80,4,1
80,9,1
80,21,1
80,25,1
80,30,1
80,34,1
80,36,1
80,38,1
80,41,1
80,46,1
80,48,1
80,49,1
80,50,1
80,56,1
80,57,1
81,2,1
81,5,1
81,9,1
81,21,1
81,26,1
81,30,1
81,34,1
81,37,1
81,38,1
81,42,1
81,47,1
81,48,1
81,49,1
81,50,1
81,56,1
81,57,1
82,1,1
82,6,1
82,9,1
82,21,1
82,25,1
82,30,1
82,34,1
82,35,1
82,38,1
82,43,1
82,46,1
82,48,1
82,49,1
82,50,1
82,56,1
82,57,1
83,2,1
83,7,1
83,9,1
83,21,1
83,26,1
83,31,1
83,34,1
83,36,1
83,38,1
83,44,1
83,47,1
83,48,1
83,49,1
83,50,1
83,56,1
83,57,1
84,1,1
84,8,1
84,9,1
84,21,1
84,25,1
84,30,1
84,34,1
84,37,1
84,38,1
84,45,1
84,46,1
84,48,1
84,49,1
84,50,1
84,56,1
84,57,1
85,2,1
85,9,1
85,21,1
85,26,1
85,30,1
85,34,1
85,35,1
85,38,1
85,47,1
85,48,1
85,49,1
85,50,1
85,57,1
86,1,1
86,9,1
86,21,1
86,25,1
86,30,1
86,34,1
86,36,1
86,38,1
86,46,1
86,48,1
86,49,1
86,50,1
86,57,1
87,2,1
87,9,1
87,20,1
87,24,1
87,29,1
87,34,1
87,37,1
87,38,1
87,47,1
87,48,1
87,49,1
87,50,1
87,57,1
88,1,1
88,9,1
88,20,1
88,23,1
88,29,1
88,34,1
88,35,1
88,38,1
88,46,1
88,48,1
88,49,1
88,50,1
88,57,1
89,2,1
89,9,1
89,20,1
89,24,1
89,29,1
89,34,1
89,36,1
89,38,1
89,47,1
89,48,1
89,49,1
89,50,1
89,57,1
90,1,1
90,9,1
90,20,1
90,29,1
90,34,1
90,37,1
90,38,1
90,46,1
90,48,1
90,49,1
90,50,1
90,57,1
91,2,1
91,9,1
91,22,1
91,28,1
91,32,1
91,34,1
91,35,1
91,38,1
91,47,1
91,48,1
91,49,1
91,50,1
91,57,1
92,1,1
92,9,1
92,21,1
92,26,1
92,31,1
92,34,1
92,36,1
92,38,1
92,46,1
92,48,1
92,49,1
92,50,1
92,57,1
93,2,1
93,9,1
93,21,1
93,25,1
93,30,1
93,34,1
93,37,1
93,38,1
93,47,1
93,48,1
93,49,1
93,50,1
93,57,1
94,1,1
94,9,1
94,22,1
94,27,1
94,32,1
94,34,1
94,35,1
94,38,1
94,46,1
94,48,1
94,49,1
94,50,1
94,57,1
95,2,1
95,9,1
95,21,1
95,26,1
95,30,1
95,34,1
95,36,1
95,38,1
95,47,1
95,48,1
95,49,1
95,50,1
95,57,1
96,1,1
96,9,1
96,22,1
96,28,1
96,32,1
96,34,1
96,37,1
96,38,1
96,46,1
96,48,1
96,49,1
96,50,1
96,57,1
97,2,1
97,9,1
97,22,1
97,27,1
97,32,1
97,34,1
97,38,1
97,47,1
97,48,1
97,49,1
97,50,1
97,57,1
98,1,1
98,9,1
98,22,1
98,28,1
98,32,1
98,34,1
98,38,1
98,46,1
98,48,1
98,49,1
98,50,1
98,57,1
99,2,1
99,9,1
99,21,1
99,25,1
99,31,1
99,34,1
99,38,1
99,47,1
99,48,1
99,49,1
99,50,1
100,9,1
100,21,1
100,26,1
100,30,1
100,34,1
100,38,1
100,48,1
100,49,1
100,50,1
\.

\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Legislative Sub District 35B" "Legislative Sub District 2" "Legislative Sub District 3" "Legislative Sub District 4" "Legislative Sub District 5" "Congressional District 1" "Congressional District 2" "Congressional District 3" "Jurisdiction"
\i Infrastructure-TestFooter.sql
