\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-WriteInsAliases-NofM.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small 2-of-M contest with write-ins and aliases, no rejected ballots.'
\echo 'Ballot styles:  1'
\echo 'Reporting contexts:  1'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Parking Committee, vote for at most 2', 'N-of-M', 2, 2, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (1,  1, 'Oona Won', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1,  'Car Tay Fower', false),
  (5,  1, 'Chi Sevuhn', false),
  (6,  1, 'CHI SEVUHN ALIAS', true),
  (7,  1, 'TAYRA TREE ALIAS', true);


insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1); 

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10,1, true),
  (11,1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 1, 1),
  (1, 6, 1),
  (2, 2, 1),
  (2, 3, 1),
  (3, 6, 1),
  (4, 4, 1),
  (4, 5, 1),
  (5, 5, 1),
  (6, 4, 1),
  (6, 6, 1),
  (7, 5, 1),
  (8, 0, 1),
  (8, 1, 1),
  (8, 2, 1),
  (9, 2, 1),
  (9, 4, 1),
  (10, 3, 1),
  (10, 4, 1),
  (11, 6, 1),
  (11, 7, 1);

\echo
\echo '-----------------------------------------------------------------------'
\echo '                          BEFORE RECONCILIATION'
\echo '-----------------------------------------------------------------------'
\echo
\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"

insert into Alias (AliasId, ChoiceId) values
  (6, 5),
  (7, 3);

\echo
\echo '-----------------------------------------------------------------------'
\echo '                          AFTER RECONCILIATION'
\echo '-----------------------------------------------------------------------'
\echo
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"

\i Infrastructure-TestFooter.sql
