\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-SplitPrecinct-AbsenteeByCategory.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small 1-of-M contest with a split precinct and absentee ballots via'
\echo 'categories.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1'),
  ('District 1'),
  ('District 2');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'President, vote for at most 1', 'N-of-M', 1, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (1,  1, 'Oona Won', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'District 1 Style'),
  (2, 'District 2 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (2, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'District 1'),
  (2, 'Precinct 1'),
  (2, 'District 2');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 2, true),
  (2, 1, true),
  (3, 2, true),
  (4, 1, true),
  (5, 2, true),
  (6, 1, true),
  (7, 2, true),
  (8, 1, true),
  (9, 2, true),
  (10, 1, true),
  (11, 2, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 1, 1),
  (2, 2, 1),
  (3, 2, 1),
  (4, 3, 1),
  (5, 3, 1),
  (6, 3, 1),
  (7, 4, 1),
  (8, 4, 1),
  (9, 4, 1),
  (10, 4, 1),
  (11, 0, 1),
  (11, 1, 1);

insert into BallotCategoryAssociation (BallotId, Category) values
  (1, 'Absentee'),
  (4, 'Absentee'),
  (11, 'Absentee');

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "District 1" "District 2"
\i Infrastructure-TestFooter.sql
