\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-Primary-SplitPrecinct.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small primary election with a split precinct, no write-ins,'
\echo 'no rejected ballots.'
\echo 'Ballot styles:  4'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into ReportingContext values
  ('Precinct 1'),
  ('District 1'),
  ('District 2');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'District 1 nonpartisan office, vote for at most 1', 'N-of-M', 1, 0, false),
  (2, 'District 2 nonpartisan office, vote for at most 1', 'N-of-M', 1, 0, false),
  (3, 'Nominee of the Bipartisan Party, vote for at most 1', 'N-of-M', 1, 0, false),
  (4, 'Nominee of the Moderate Party, vote for at most 1', 'N-of-M', 1, 0, false);

copy Choice from stdin CSV;
1,1,Choice #1 District 1 nonpartisan office,,false
2,1,Choice #2 District 1 nonpartisan office,,false
3,1,Choice #3 District 1 nonpartisan office,,false
4,1,Choice #4 District 1 nonpartisan office,,false
5,2,Choice #1 District 2 nonpartisan office,,false
6,2,Choice #2 District 2 nonpartisan office,,false
7,2,Choice #3 District 2 nonpartisan office,,false
8,2,Choice #4 District 2 nonpartisan office,,false
9,3,Choice #1 Nominee Bipartisan Party,,false
10,3,Choice #2 Nominee Bipartisan Party,,false
11,4,Choice #1 Nominee Moderate Party,,false
12,4,Choice #2 Nominee Moderate Party,,false
\.

insert into BallotStyle (StyleId, Name) values
  (1, 'District 1 Bipartisan Party Style'),
  (2, 'District 1 Moderate Party Style'),
  (3, 'District 2 Bipartisan Party Style'),
  (4, 'District 2 Moderate Party Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 3),
  (2, 1),
  (2, 4),
  (3, 2),
  (3, 3),
  (4, 2),
  (4, 4);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'District 1'),
  (2, 'Precinct 1'),
  (2, 'District 1'),
  (3, 'Precinct 1'),
  (3, 'District 2'),
  (4, 'Precinct 1'),
  (4, 'District 2');

copy Ballot from stdin CSV;
1,1,true
2,4,true
3,4,true
4,2,true
5,2,true
6,4,true
7,2,true
8,3,true
9,3,true
10,4,true
11,4,true
12,2,true
13,3,true
14,2,true
15,1,true
16,4,true
17,2,true
18,4,true
19,4,true
20,4,true
21,2,true
22,4,true
23,4,true
24,2,true
25,1,true
26,2,true
27,1,true
28,2,true
29,4,true
30,3,true
31,4,true
32,4,true
33,4,true
34,2,true
35,4,true
36,3,true
37,1,true
38,4,true
39,1,true
40,4,true
\.

copy VoterInput from stdin CSV;
1,4,1
1,10,1
2,8,1
2,12,1
3,8,1
3,12,1
4,3,1
4,12,1
5,4,1
5,12,1
6,7,1
6,12,1
7,2,1
7,12,1
8,8,1
8,10,1
9,7,1
9,9,1
10,8,1
10,12,1
11,6,1
11,12,1
12,3,1
12,11,1
13,7,1
13,10,1
14,4,1
14,12,1
15,1,1
15,10,1
16,8,1
16,12,1
17,2,1
17,11,1
18,6,1
18,11,1
19,7,1
19,12,1
20,8,1
20,11,1
21,3,1
21,12,1
22,5,1
22,12,1
23,6,1
23,11,1
24,4,1
24,11,1
25,9,1
26,12,1
27,10,1
29,7,1
29,12,1
30,8,1
31,5,1
31,11,1
32,6,1
32,12,1
33,7,1
33,11,1
35,8,1
35,12,1
37,9,1
38,11,1
39,10,1
40,12,1
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "District 1" "District 2"
\i Infrastructure-TestFooter.sql
