\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-Primary-CrossPartyEndorsement.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small primary election with straight party voting and cross-party'
\echo 'endorsement in a non-party-specific contest.'
\echo 'Ballot styles:  3'
\echo 'Reporting contexts:  4'

\i Infrastructure-VoteSchema.sql

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party'),
  ('Alliance Party');

insert into ReportingContext values
  ('Precinct 1'),
  ('Precinct 1 Bipartisan Party'),
  ('Precinct 1 Moderate Party'),
  ('Precinct 1 Alliance Party');

-- The Alliance Party ran into ballot access problems so they won't have any
-- nominees for the general election.

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Straight party, vote for at most 1', 'Straight party selection', 1, 0, false),
  (2, 'Non-party-specific office, vote for at most 1', 'N-of-M', 1, 0, false),
  (3, 'Nominee of the Bipartisan Party, vote for at most 1', 'N-of-M', 1, 0, false),
  (4, 'Nominee of the Moderate Party, vote for at most 1', 'N-of-M', 1, 0, false);

insert into Choice (ChoiceId, ContestId, Name, Affiliation, IsWriteIn) values
  (0,  4, 'Nada Zayro',    'Moderate Party',   false),
  (1,  3, 'Oona Won',      'Bipartisan Party', false),
  (2,  3, 'Beeso Tu',      'Bipartisan Party', false),
  (3,  2, 'Tayra Tree',    'Bipartisan Party', false),
  (4,  2, 'Car Tay Fower', 'Moderate Party',   false),
  (5,  1, 'Bipartisan Party', NULL,            false),
  (6,  1, 'Moderate Party',   NULL,            false),
  (7,  1, 'Alliance Party',   NULL,            false);

insert into Endorsement (Party, ChoiceId, Value) values
  ('Bipartisan Party', 3, 1),
  ('Moderate Party',   4, 1),
  ('Alliance Party',   4, 1);

insert into BallotStyle (StyleId, Name) values
  (1, 'Bipartisan Party Style'),
  (2, 'Moderate Party Style'),
  (3, 'Alliance Party Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2),
  (1, 3),
  (2, 1),
  (2, 2),
  (2, 4),
  (3, 1),
  (3, 2);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Precinct 1 Bipartisan Party'),
  (2, 'Precinct 1'),
  (2, 'Precinct 1 Moderate Party'),
  (3, 'Precinct 1'),
  (3, 'Precinct 1 Alliance Party');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 3, true),
  (6, 2, true),
  (7, 2, true),
  (8, 2, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 5, 1),
  (1, 1, 1),
  (2, 6, 1),
  (2, 2, 1),
  (3, 4, 1),
  (3, 2, 1),
  (4, 3, 1),
  (5, 7, 1),
  (6, 4, 1),
  (7, 3, 1),
  (8, 3, 1),
  (8, 4, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1 Alliance Party" "Precinct 1"
\i Infrastructure-TestFooter.sql
