\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-AbsenteeBySpecialPrecinct-SplitPrecinct.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small 1-of-M contest with absentee ballots via a special precinct'
\echo 'and a split precinct.'
\echo 'Ballot styles:  4'
\echo 'Reporting contexts:  5'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1 (consolidated)'),
  ('Precinct 1 (in-person)'),
  ('Precinct 1 (absentee)'),
  ('District 1'),
  ('District 2');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'President, vote for at most 1', 'N-of-M', 1, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (1,  1, 'Oona Won', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false),
  (5,  1, 'Wu Fife', false),
  (6,  1, 'Lu Sigs', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'District 1 Style (in-person)'),
  (2, 'District 2 Style (in-person)'),
  (3, 'District 1 Style (absentee)'),
  (4, 'District 2 Style (absentee)');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (2, 1),
  (3, 1),
  (4, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1 (consolidated)'),
  (1, 'Precinct 1 (in-person)'),
  (1, 'District 1'),
  (2, 'Precinct 1 (consolidated)'),
  (2, 'Precinct 1 (in-person)'),
  (2, 'District 2'),
  (3, 'Precinct 1 (consolidated)'),
  (3, 'Precinct 1 (absentee)'),
  (3, 'District 1'),
  (4, 'Precinct 1 (consolidated)'),
  (4, 'Precinct 1 (absentee)'),
  (4, 'District 2');

copy Ballot from stdin CSV;
1,1,true
2,2,true
3,3,true
4,2,true
5,4,true
6,1,true
7,1,true
8,3,true
9,2,true
10,4,true
11,4,true
12,3,true
13,4,true
14,2,true
15,1,true
16,3,true
17,4,true
18,1,true
19,3,true
20,3,true
21,2,true
22,1,true
23,1,true
24,3,true
25,2,true
\.

copy VoterInput from stdin CSV;
1,6,1
2,5,1
3,6,1
4,4,1
5,5,1
6,6,1
7,3,1
8,4,1
9,5,1
10,6,1
11,2,1
12,3,1
13,4,1
14,5,1
15,6,1
16,1,1
17,2,1
18,3,1
19,4,1
20,5,1
21,6,1
22,0,1
22,1,1
22,2,1
22,3,1
22,4,1
22,5,1
22,6,1
25,1,1
25,2,1
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1 (in-person)" "Precinct 1 (absentee)" "District 1" "District 2" "Precinct 1 (consolidated)"
\i Infrastructure-TestFooter.sql
