// $Id: misc.cc 370 2007-09-04 14:02:22Z dflater $

#include <string>
#include <sstream>
#include <istream>
#include <cln/cln.h>
#include <assert.h>
#include <math.h>
#include "parser.hh"


std::string stringify (unsigned long x) {
  std::ostringstream buf;
  buf << x;
  return buf.str();
}


// std::string stringify (std::istream &in) {
//   std::string linebuf, bigbuf;
//   while (getline (in, linebuf))
//     bigbuf += linebuf + '\n';
//   return bigbuf;
// }


std::string stringify (TGParser::Contest::Logic logic) {
  switch (logic) {
  case TGParser::Contest::NofM:
    return "N-of-M";
  case TGParser::Contest::cumulative:
    return "Cumulative";
  case TGParser::Contest::rankedOrder:
    return "Ranked order";
  }
  assert (false);
}


unsigned long randFunc (unsigned long N) {
  assert (N > 0);
  // CLN random functions are self-seeding.
  cln::cl_I r_I (cln::random_I (N));
  assert (r_I < N);
  return cln::cl_I_to_ulong (r_I);
}


unsigned long evenDist (unsigned long N,
			unsigned long domain,
			unsigned long range) {
  assert (domain > 0);
  assert (range > 0);
  assert (N > 0);
  assert (N <= domain);
  return ceil ((double)N * range / domain);
}
