\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-samples-AlleganyGeneral2004.sql 462 2008-01-14 20:51:46Z dflater $'
\echo
\echo 'Customized TestGenerator-generated test.  Test spec follows:'
\echo
\echo '  // Test spec based on Allegany County, MD sample ballot for'
\echo '  // congressional district 6, general election, 2004-11-02.'
\echo '  // http://vote.nist.gov/ballots/md_allegany_20041102_01.pdf'
\echo '  '
\echo '  // As of 2002-06-21,'
\echo '  //    Legislative District 1;'
\echo '  //    Delegate Districts 01A, 01B and 01C;'
\echo '  //    Election Districts many.'
\echo '  // Election District 6 is split between Delegate Districts 1B and 1C'
\echo '  // according to precinct.'
\echo '  // This test does not attempt to replicate that reporting structure.'
\echo '  districts=3'
\echo '  precincts=5'
\echo '  precinctDistribution=Even'
\echo '  '
\echo '  ballots=100'
\echo '  '
\echo '  (N=1 M=7 W=1 distribution=Triangle)          // President and VP'
\echo '  (N=1 M=5 W=1 distribution=Triangle)          // U.S. Senator'
\echo '  (level=D N=1 M=4 W=1 distribution=Triangle)  // House of Representatives'
\echo '  (N=1 M=2 W=1 distribution=Triangle)          // Judge of the Circuit Court'
\echo '  (N=1 M=2 distribution=Triangle)  // Judge, Court of Special Appeals At Large'
\echo '                                   // (yes/no for continuance in office)'
\echo '  (N=2 M=6 W=2 distribution=Triangle)          // Board of Education'
\echo '  (N=2 M=4 distribution=Triangle)              // Cumberland City Council'
\echo
\echo 'Contest and candidate names were copied in from the sample ballot but'
\echo 'the vote totals are synthetic and have no relationship to the actual'
\echo 'election results.'

\i Infrastructure-VoteSchema.sql

copy ReportingContext from stdin CSV;
Precinct 1
Precinct 2
Precinct 3
Precinct 4
Precinct 5
District 1
District 2
District 6
Jurisdiction
\.

insert into Party values
  ('Republican'),
  ('Democratic'),
  ('Green'),
  ('Libertarian'),
  ('Constitution'),
  ('Populist');

copy Contest from stdin CSV;
1,"PRESIDENT AND VICE PRESIDENT OF THE UNITED STATES
Vote for One",N-of-M,1,1,false
2,"U.S. SENATOR
Vote for One",N-of-M,1,1,false
3,"REPRESENTATIVE IN CONGRESS
CONGRESSIONAL DISTRICT 1
Vote for One",N-of-M,1,1,false
4,"REPRESENTATIVE IN CONGRESS
CONGRESSIONAL DISTRICT 2
Vote for One",N-of-M,1,1,false
5,"REPRESENTATIVE IN CONGRESS
CONGRESSIONAL DISTRICT 6
Vote for One",N-of-M,1,1,false
6,"JUDGE OF THE CIRCUIT COURT
JUDICIAL CIRCUIT 4
Vote for One",N-of-M,1,1,false
7,"JUDGE, COURT OF SPECIAL APPEALS
AT LARGE
Joseph F. Murphy, Jr.
Vote Yes or No For Continuance in Office",N-of-M,1,0,false
8,"BOARD OF EDUCATION
Vote for No More Than Two",N-of-M,2,2,false
9,"COUNCIL - CITY OF CUMBERLAND MUNICIPALITIES 1
Vote for No More Than Two",N-of-M,2,0,false
\.

copy Choice from stdin CSV;
1,1,Lawson Mitchell Bone,,true
2,1,George W. Bush (Texas) And Dick Cheney (Wyoming),Republican,false
3,1,John F. Kerry (Massachusetts) And John Edwards (North Carolina),Democratic,false
4,1,David Cobb (California) And Patricia LaMarche (Maine),Green,false
5,1,Michael Badnarik (Texas) And Richard V. Campagna (Iowa),Libertarian,false
6,1,Michael Anthony Peroutka (Maryland) And Chuck Baldwin (Florida),Constitution,false
7,1,Ralph Nader (Connecticut) And Peter Miguel Camejo (California),Populist,false
8,2,Ray Bly,,true
9,2,E. J. Pipkin,Republican,false
10,2,Barbara A. Mikulski,Democratic,false
11,2,Maria Allwine,Green,false
12,2,Thomas Trump,Constitution,false
13,3,Representative #1 in District 1,,true
14,3,Representative #2 in District 1,,false
15,3,Representative #3 in District 1,,false
16,3,Representative #4 in District 1,,false
17,4,Representative #1 in District 2,,true
18,4,Representative #2 in District 2,,false
19,4,Representative #3 in District 2,,false
20,4,Representative #4 in District 2,,false
21,5,Write-in representative,,true
22,5,Roscoe G. Bartlett,Republican,false
23,5,Kenneth T. Bosley,Democratic,false
24,5,Gregory J. Hemingway,Green,false
25,6,Write-in judge,,true
26,6,W. Timothy Finan,,false
27,7,YES,,false
28,7,NO,,false
29,8,Write-in #1 in BoE contest,,true
30,8,Write-in #2 in BoE contest,,true
31,8,Kimi-Scott McGreevy,,false
32,8,Jeffery T. Metz,,false
33,8,C. Fred Sloan,,false
34,8,Judie Thelen,,false
35,9,James F. Combs,,false
36,9,"Edward C. Hedrick, Jr.",,false
37,9,Terance J. Rephann,,false
38,9,Deborah Smith,,false
\.

copy BallotStyle from stdin CSV;
1,Precinct 1 style
2,Precinct 2 style
3,Precinct 3 style
4,Precinct 4 style
5,Precinct 5 style
\.

copy BallotStyleContestAssociation from stdin CSV;
1,1
1,2
1,3
1,6
1,7
1,8
1,9
2,1
2,2
2,4
2,6
2,7
2,8
2,9
3,1
3,2
3,4
3,6
3,7
3,8
3,9
4,1
4,2
4,5
4,6
4,7
4,8
4,9
5,1
5,2
5,5
5,6
5,7
5,8
5,9
\.

copy BallotStyleReportingContextAssociation from stdin CSV;
1,Precinct 1
1,District 1
1,Jurisdiction
2,Precinct 2
2,District 2
2,Jurisdiction
3,Precinct 3
3,District 2
3,Jurisdiction
4,Precinct 4
4,District 6
4,Jurisdiction
5,Precinct 5
5,District 6
5,Jurisdiction
\.

copy Ballot from stdin CSV;
1,1,true
2,2,true
3,2,true
4,1,true
5,1,true
6,1,true
7,2,true
8,3,true
9,5,true
10,4,true
11,2,true
12,5,true
13,3,true
14,2,true
15,4,true
16,5,true
17,3,true
18,4,true
19,3,true
20,5,true
21,4,true
22,3,true
23,5,true
24,1,true
25,4,true
26,2,true
27,1,true
28,1,true
29,3,true
30,3,true
31,4,true
32,1,true
33,3,true
34,2,true
35,3,true
36,2,true
37,5,true
38,5,true
39,4,true
40,3,true
41,4,true
42,2,true
43,1,true
44,3,true
45,4,true
46,1,true
47,4,true
48,2,true
49,1,true
50,3,true
51,1,true
52,2,true
53,4,true
54,3,true
55,1,true
56,3,true
57,2,true
58,4,true
59,1,true
60,5,true
61,5,true
62,4,true
63,3,true
64,5,true
65,5,true
66,2,true
67,3,true
68,5,true
69,1,true
70,5,true
71,3,true
72,4,true
73,4,true
74,3,true
75,3,true
76,1,true
77,5,true
78,3,true
79,5,true
80,1,true
81,3,true
82,2,true
83,5,true
84,1,true
85,1,true
86,5,true
87,5,true
88,3,true
89,3,true
90,5,true
91,4,true
92,5,true
93,4,true
94,3,true
95,1,true
96,2,true
97,1,true
98,2,true
99,3,true
100,2,true
\.

copy VoterInput from stdin CSV;
1,7,1
1,12,1
1,16,1
1,26,1
1,28,1
1,33,1
1,34,1
1,37,1
1,38,1
2,7,1
2,12,1
2,20,1
2,26,1
2,28,1
2,33,1
2,34,1
2,37,1
2,38,1
3,7,1
3,12,1
3,20,1
3,26,1
3,28,1
3,33,1
3,34,1
3,37,1
3,38,1
4,6,1
4,12,1
4,16,1
4,26,1
4,28,1
4,33,1
4,34,1
4,37,1
4,38,1
5,7,1
5,12,1
5,15,1
5,26,1
5,28,1
5,33,1
5,34,1
5,37,1
5,38,1
6,6,1
6,12,1
6,16,1
6,26,1
6,28,1
6,33,1
6,34,1
6,37,1
6,38,1
7,7,1
7,11,1
7,20,1
7,26,1
7,28,1
7,33,1
7,34,1
7,37,1
7,38,1
8,6,1
8,12,1
8,20,1
8,26,1
8,28,1
8,33,1
8,34,1
8,37,1
8,38,1
9,7,1
9,11,1
9,24,1
9,26,1
9,28,1
9,33,1
9,34,1
9,37,1
9,38,1
10,5,1
10,12,1
10,24,1
10,26,1
10,28,1
10,32,1
10,34,1
10,37,1
10,38,1
11,6,1
11,11,1
11,19,1
11,26,1
11,28,1
11,33,1
11,34,1
11,37,1
11,38,1
12,7,1
12,12,1
12,24,1
12,26,1
12,28,1
12,32,1
12,34,1
12,37,1
12,38,1
13,5,1
13,11,1
13,20,1
13,26,1
13,28,1
13,33,1
13,34,1
13,37,1
13,38,1
14,6,1
14,12,1
14,19,1
14,26,1
14,28,1
14,32,1
14,34,1
14,37,1
14,38,1
15,7,1
15,11,1
15,23,1
15,26,1
15,28,1
15,33,1
15,34,1
15,37,1
15,38,1
16,5,1
16,12,1
16,24,1
16,26,1
16,28,1
16,32,1
16,34,1
16,37,1
16,38,1
17,6,1
17,11,1
17,20,1
17,26,1
17,28,1
17,33,1
17,34,1
17,37,1
17,38,1
18,7,1
18,12,1
18,23,1
18,26,1
18,28,1
18,32,1
18,34,1
18,37,1
18,38,1
19,4,1
19,10,1
19,19,1
19,26,1
19,28,1
19,33,1
19,34,1
19,37,1
19,38,1
20,5,1
20,11,1
20,24,1
20,26,1
20,28,1
20,32,1
20,34,1
20,37,1
20,38,1
21,6,1
21,12,1
21,23,1
21,26,1
21,28,1
21,33,1
21,34,1
21,36,1
21,38,1
22,7,1
22,10,1
22,20,1
22,26,1
22,28,1
22,32,1
22,34,1
22,37,1
22,38,1
23,4,1
23,11,1
23,24,1
23,26,1
23,28,1
23,33,1
23,34,1
23,36,1
23,38,1
24,5,1
24,12,1
24,15,1
24,26,1
24,28,1
24,32,1
24,34,1
24,37,1
24,38,1
25,6,1
25,10,1
25,22,1
25,26,1
25,28,1
25,33,1
25,34,1
25,36,1
25,38,1
26,7,1
26,11,1
26,19,1
26,26,1
26,28,1
26,32,1
26,34,1
26,37,1
26,38,1
27,4,1
27,12,1
27,16,1
27,26,1
27,28,1
27,33,1
27,34,1
27,36,1
27,38,1
28,5,1
28,10,1
28,14,1
28,26,1
28,28,1
28,31,1
28,32,1
28,37,1
28,38,1
29,6,1
29,11,1
29,20,1
29,26,1
29,28,1
29,33,1
29,34,1
29,36,1
29,38,1
30,7,1
30,12,1
30,18,1
30,26,1
30,28,1
30,31,1
30,32,1
30,37,1
30,38,1
31,3,1
31,10,1
31,23,1
31,26,1
31,28,1
31,33,1
31,34,1
31,36,1
31,38,1
32,4,1
32,11,1
32,15,1
32,26,1
32,28,1
32,31,1
32,32,1
32,37,1
32,38,1
33,5,1
33,12,1
33,19,1
33,26,1
33,28,1
33,33,1
33,34,1
33,36,1
33,38,1
34,6,1
34,10,1
34,20,1
34,25,1
34,27,1
34,31,1
34,32,1
34,37,1
34,38,1
35,7,1
35,11,1
35,18,1
35,26,1
35,28,1
35,33,1
35,34,1
35,36,1
35,38,1
36,3,1
36,12,1
36,19,1
36,25,1
36,27,1
36,31,1
36,32,1
36,37,1
36,38,1
37,4,1
37,9,1
37,24,1
37,26,1
37,28,1
37,33,1
37,34,1
37,36,1
37,38,1
38,5,1
38,10,1
38,22,1
38,25,1
38,27,1
38,31,1
38,32,1
38,37,1
38,38,1
39,6,1
39,11,1
39,23,1
39,26,1
39,28,1
39,33,1
39,34,1
39,36,1
39,38,1
40,7,1
40,12,1
40,20,1
40,25,1
40,27,1
40,31,1
40,32,1
40,37,1
40,38,1
41,3,1
41,9,1
41,24,1
41,26,1
41,28,1
41,33,1
41,34,1
41,36,1
41,38,1
42,4,1
42,10,1
42,18,1
42,25,1
42,27,1
42,31,1
42,32,1
42,37,1
42,38,1
43,5,1
43,11,1
43,16,1
43,26,1
43,28,1
43,33,1
43,34,1
43,36,1
43,38,1
44,6,1
44,12,1
44,19,1
44,25,1
44,27,1
44,31,1
44,32,1
44,37,1
44,38,1
45,7,1
45,9,1
45,22,1
45,26,1
45,28,1
45,33,1
45,34,1
45,36,1
45,38,1
46,2,1
46,10,1
46,14,1
46,25,1
46,27,1
46,30,1
46,31,1
46,37,1
46,38,1
47,3,1
47,11,1
47,23,1
47,26,1
47,28,1
47,32,1
47,33,1
47,36,1
47,38,1
48,4,1
48,12,1
48,20,1
48,25,1
48,27,1
48,30,1
48,34,1
48,37,1
48,38,1
49,5,1
49,9,1
49,15,1
49,26,1
49,28,1
49,31,1
49,32,1
49,36,1
49,38,1
50,6,1
50,10,1
50,18,1
50,25,1
50,27,1
50,33,1
50,34,1
50,37,1
50,38,1
51,7,1
51,11,1
51,16,1
51,26,1
51,28,1
51,30,1
51,31,1
51,36,1
51,38,1
52,2,1
52,12,1
52,19,1
52,25,1
52,27,1
52,32,1
52,33,1
52,37,1
52,38,1
53,3,1
53,9,1
53,24,1
53,26,1
53,28,1
53,30,1
53,34,1
53,36,1
53,38,1
54,4,1
54,10,1
54,20,1
54,25,1
54,27,1
54,31,1
54,32,1
54,37,1
54,38,1
55,5,1
55,11,1
55,13,1
55,26,1
55,28,1
55,33,1
55,34,1
55,36,1
55,38,1
56,6,1
56,12,1
56,17,1
56,25,1
56,27,1
56,30,1
56,31,1
56,37,1
56,38,1
57,7,1
57,9,1
57,18,1
57,26,1
57,28,1
57,32,1
57,33,1
57,36,1
57,38,1
58,2,1
58,10,1
58,21,1
58,25,1
58,27,1
58,30,1
58,34,1
58,37,1
58,38,1
59,3,1
59,11,1
59,14,1
59,26,1
59,28,1
59,31,1
59,32,1
59,36,1
59,38,1
60,4,1
60,12,1
60,22,1
60,25,1
60,27,1
60,33,1
60,34,1
60,37,1
60,38,1
61,5,1
61,8,1
61,23,1
61,26,1
61,28,1
61,30,1
61,31,1
61,35,1
61,36,1
62,6,1
62,9,1
62,24,1
62,25,1
62,27,1
62,32,1
62,33,1
62,37,1
62,38,1
63,7,1
63,10,1
63,19,1
63,26,1
63,28,1
63,30,1
63,34,1
63,35,1
63,36,1
64,1,1
64,11,1
64,21,1
64,25,1
64,27,1
64,31,1
64,32,1
64,37,1
64,38,1
65,2,1
65,12,1
65,22,1
65,26,1
65,28,1
65,33,1
65,34,1
65,35,1
65,36,1
66,3,1
66,8,1
66,20,1
66,25,1
66,27,1
66,30,1
66,31,1
66,37,1
66,38,1
67,4,1
67,9,1
67,17,1
67,26,1
67,28,1
67,32,1
67,33,1
67,35,1
67,36,1
68,5,1
68,10,1
68,23,1
68,25,1
68,27,1
68,29,1
68,34,1
68,37,1
68,38,1
69,6,1
69,11,1
69,15,1
69,26,1
69,28,1
69,30,1
69,31,1
69,35,1
69,36,1
70,7,1
70,12,1
70,24,1
70,25,1
70,27,1
70,32,1
70,33,1
70,37,1
70,38,1
71,1,1
71,8,1
71,18,1
71,26,1
71,28,1
71,29,1
71,34,1
71,35,1
71,36,1
72,2,1
72,9,1
72,21,1
72,25,1
72,27,1
72,30,1
72,31,1
72,37,1
72,38,1
73,3,1
73,10,1
73,22,1
73,26,1
73,28,1
73,32,1
73,33,1
73,35,1
73,36,1
74,4,1
74,11,1
74,19,1
74,25,1
74,27,1
74,29,1
74,34,1
74,37,1
74,38,1
75,5,1
75,12,1
75,20,1
75,26,1
75,28,1
75,30,1
75,31,1
75,35,1
75,36,1
76,6,1
76,8,1
76,16,1
76,25,1
76,27,1
76,32,1
76,33,1
76,37,1
76,38,1
77,7,1
77,9,1
77,23,1
77,26,1
77,28,1
77,29,1
77,34,1
77,35,1
77,36,1
78,1,1
78,10,1
78,17,1
78,25,1
78,27,1
78,30,1
78,31,1
78,37,1
78,38,1
79,2,1
79,11,1
79,24,1
79,26,1
79,28,1
79,32,1
79,33,1
79,35,1
79,36,1
80,3,1
80,12,1
80,13,1
80,25,1
80,27,1
80,29,1
80,34,1
80,37,1
80,38,1
81,4,1
81,8,1
81,18,1
81,26,1
81,28,1
81,30,1
81,31,1
81,35,1
81,36,1
82,5,1
82,9,1
82,19,1
82,25,1
82,27,1
82,32,1
82,33,1
82,37,1
82,38,1
83,6,1
83,10,1
83,26,1
83,28,1
83,29,1
83,34,1
83,35,1
83,36,1
84,7,1
84,11,1
84,14,1
84,25,1
84,27,1
84,30,1
84,31,1
84,37,1
84,38,1
85,12,1
85,15,1
85,26,1
85,28,1
85,32,1
85,33,1
85,35,1
85,36,1
86,8,1
86,25,1
86,27,1
86,29,1
86,34,1
86,37,1
86,38,1
87,9,1
87,26,1
87,28,1
87,30,1
87,31,1
87,35,1
87,36,1
88,10,1
88,20,1
88,25,1
88,27,1
88,32,1
88,33,1
88,37,1
88,38,1
89,11,1
89,17,1
89,26,1
89,28,1
89,29,1
89,34,1
89,35,1
89,36,1
90,12,1
90,25,1
90,27,1
90,30,1
90,31,1
90,37,1
90,38,1
91,26,1
91,28,1
91,32,1
91,33,1
91,35,1
91,36,1
92,25,1
92,27,1
92,29,1
92,34,1
92,37,1
92,38,1
93,26,1
93,28,1
93,30,1
93,31,1
93,35,1
93,36,1
94,18,1
94,25,1
94,27,1
94,32,1
94,33,1
94,37,1
94,38,1
95,16,1
95,26,1
95,28,1
95,34,1
95,35,1
95,36,1
96,19,1
96,25,1
96,27,1
96,37,1
96,38,1
97,26,1
97,28,1
97,35,1
97,36,1
98,20,1
98,25,1
98,27,1
98,37,1
98,38,1
99,26,1
99,28,1
99,35,1
99,36,1
100,37,1
100,38,1
\.

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "Precinct 2" "Precinct 3" "Precinct 4" "Precinct 5" "District 1" "District 2" "District 6" "Jurisdiction"
\i Infrastructure-TestFooter.sql
