\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-StraightParty-NofM.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small straight party + 2-of-M contest, no write-ins, no rejected ballots.'
\echo 'Ballot styles:  1'
\echo 'Reporting contexts:  1'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1');

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Straight party, vote for at most 1', 'Straight party selection', 1, 0, false),
  (2, 'Leadership coalition, vote for at most 2', 'N-of-M', 2, 0, false);

insert into Choice (ChoiceId, ContestId, Name, Affiliation, IsWriteIn) values
  (0,  2, 'Nada Zayro',       NULL,               false),
  (1,  2, 'Oona Won',         NULL,               false),
  (2,  2, 'Beeso Tu',         'Bipartisan Party', false),
  (3,  2, 'Tayra Tree',       'Moderate Party',   false),
  (4,  2, 'Car Tay Fower',    'Bipartisan Party', false),
  (5,  2, 'Wu Fife',          'Moderate Party',   false),
  (6,  2, 'Lu Sigs',	      NULL, 		  false),
  (7,  1, 'Bipartisan Party', NULL,               false),
  (8,  1, 'Moderate Party',   NULL,               false);

insert into Endorsement (Party, ChoiceId, Value) values
  ('Bipartisan Party', 2, 1),
  ('Moderate Party',   3, 1),
  ('Bipartisan Party', 4, 1),
  ('Moderate Party',   5, 1);

insert into BallotStyle (StyleId, Name) values
  (1, 'Precinct 1 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10, 1, true),
  (11, 1, true),
  (12, 1, true),
  (13, 1, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 7, 1),
  (2, 3, 1),
  (3, 8, 1),
  (4, 4, 1),
  (4, 6, 1),
  (5, 4, 1),
  (5, 6, 1),
  (6, 7, 1),
  (7, 5, 1),
  (7, 6, 1),
  (8, 5, 1),
  (8, 6, 1),
  (9, 8, 1),
  (10, 5, 1),
  (11, 6, 1),
  (12, 1, 1),
  (12, 6, 1),
  (13, 0, 1),
  (13, 2, 1),
  (13, 4, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1"
\i Infrastructure-TestFooter.sql
