\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-SplitPrecinct-Cumulative.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small Cumulative contest, N=2, with a split precinct.'
\echo 'Ballot styles:  2'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Precinct 1'),
  ('District 1'),
  ('District 2');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Parking Committee, cast at most 2 votes', 'Cumulative', 2, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  1, 'Nada Zayro', false),
  (1,  1, 'Oona Won', false),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'District 1 Style'),
  (2, 'District 2 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (2, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'District 1'),
  (2, 'Precinct 1'),
  (2, 'District 2');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 2, true),
  (2, 1, true),
  (3, 2, true),
  (4, 1, true),
  (5, 2, true),
  (6, 1, true),
  (7, 2, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 1, 1),
  (1, 4, 1),
  (2, 2, 2),
  (3, 3, 2),
  (4, 3, 1),
  (4, 4, 1),
  (5, 4, 2),
  (6, 1, 1),
  (6, 2, 1),
  (6, 3, 1),
  (7, 0, 2),
  (7, 2, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "District 1" "District 2"
\i Infrastructure-TestFooter.sql
