\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-RankedOrder-WriteIns.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small ranked order contest, N=1, M=4, with write-in.'
\echo 'Ballot styles:  1'
\echo 'Reporting contexts:  1'

\i Infrastructure-VoteSchema.sql

insert into ReportingContext values
  ('Jurisdiction');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'President, rank in order of preference', 'Ranked order', 1, 1, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (1,  1, 'Oona Won', true),
  (2,  1, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Jurisdiction Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Jurisdiction');

insert into Ballot (BallotId, StyleId, Accepted) values
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10, 1, true);

-- Since Oona Won is a write-in on just one ballot, she is not ranked
-- by the other ballots.

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 1, 1),
  (1, 3, 2),
  (1, 2, 3),
  (1, 4, 4),

  (2, 2, 1),
  (2, 3, 2),
  (2, 4, 3),
  (3, 2, 1),
  (3, 3, 2),
  (3, 4, 3),

  (4, 3, 1),
  (4, 4, 2),
  (4, 2, 3),
  (5, 3, 1),
  (5, 4, 2),
  (5, 2, 3),
  (6, 3, 1),
  (6, 4, 2),
  (6, 2, 3),

  (7, 4, 1),
  (7, 3, 2),
  (7, 2, 3),
  (8, 4, 1),
  (8, 3, 2),
  (8, 2, 3),
  (9, 4, 1),
  (9, 3, 2),
  (9, 2, 3),
  (10, 4, 1),
  (10, 3, 2),
  (10, 2, 3);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Jurisdiction"
\i Infrastructure-TestFooter.sql
