\i Infrastructure-TestHeader.sql

\echo '$Id: 1-basic-Primary-AbsenteeBySpecialPrecinct.sql 452 2008-01-09 14:24:56Z dflater $'
\echo
\echo 'Small primary election with absentee ballots via a special precinct and'
\echo 'ballot style, no write-ins, no rejected ballots.'
\echo 'Ballot styles:  4'
\echo 'Reporting contexts:  3'

\i Infrastructure-VoteSchema.sql

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into ReportingContext values
  ('Precinct 1'),
  ('Absentee Precinct'),
  ('Jurisdiction');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'Nonpartisan office, vote for at most 1', 'N-of-M', 1, 0, false),
  (2, 'Nominee of the Bipartisan Party, vote for at most 1', 'N-of-M', 1, 0, false),
  (3, 'Nominee of the Moderate Party, vote for at most 1', 'N-of-M', 1, 0, false);

insert into Choice (ChoiceId, ContestId, Name, IsWriteIn) values
  (0,  3, 'Nada Zayro', false),
  (1,  2, 'Oona Won', false),
  (2,  2, 'Beeso Tu', false),
  (3,  1, 'Tayra Tree', false),
  (4,  1, 'Car Tay Fower', false);

insert into BallotStyle (StyleId, Name) values
  (1, 'Bipartisan Party Style (polling place)'),
  (2, 'Moderate Party Style (polling place)'),
  (3, 'Bipartisan Party Style (absentee)'),
  (4, 'Moderate Party Style (absentee)');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2),
  (2, 1),
  (2, 3),
  (3, 1),
  (3, 2),
  (4, 1),
  (4, 3);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'Precinct 1'),
  (1, 'Jurisdiction'),
  (2, 'Precinct 1'),
  (2, 'Jurisdiction'),
  (3, 'Absentee Precinct'),
  (3, 'Jurisdiction'),
  (4, 'Absentee Precinct'),
  (4, 'Jurisdiction');

insert into Ballot (BallotId, StyleId, Accepted) values
  (0, 1, true),
  (1, 3, true),
  (2, 1, true),
  (3, 3, true),
  (4, 1, true),
  (5, 4, true),
  (6, 2, true),
  (7, 2, true),
  (8, 2, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (1, 3, 1),
  (1, 1, 1),
  (2, 4, 1),
  (2, 2, 1),
  (3, 4, 1),
  (3, 2, 1),
  (4, 3, 1),
  (5, 4, 1),
  (6, 4, 1),
  (7, 3, 1),
  (8, 3, 1),
  (8, 4, 1);

\i Infrastructure-TestHook.sql
\i Infrastructure-IntegrityChecks.sql
\! ReportGenerator/ReportGenerator "Precinct 1" "Absentee Precinct" "Jurisdiction"
\i Infrastructure-TestFooter.sql
