-- These base definitions are included by all 0-integrity tests and
-- then tweaked by each individual test case to obtain the needed
-- scenario.


-- Ballot styles are assigned by district.
--
-- District 1 has a straight party contest and three others.
-- District 2 only has one contest.
--
-- Precinct 1 is fully contained within District 1.
-- Precinct 2 is split between Districts 1 and 2.
--
-- The district and jurisdiction reporting contexts are inherited from
-- the ballot style, but a precinct must be specified for each ballot.


\i Infrastructure-VoteSchema.sql

\echo '$Id: 0-integrity-common.sql 95 2007-03-19 13:59:35Z dflater $'

insert into ReportingContext values
  ('Precinct 1'),
  ('Precinct 2'),
  ('District 1'),
  ('District 2'),
  ('Jurisdiction');

insert into Party values
  ('Bipartisan Party'),
  ('Moderate Party');

insert into Contest (ContestId, Description, CountingLogic, N,
                     MaxWriteIns, Rotate) values
  (1, 'President, vote for at most 1',           'N-of-M',     1, 1, false),
  (2, 'Finance Committee, vote for at most 2',   'N-of-M',     2, 2, false),
  (3, 'Parking Committee, cast at most 2 votes', 'Cumulative', 2, 2, false),
  (4, 'Straight party, vote for at most 1',      'Straight party selection', 1, 0, false);

insert into Choice (ChoiceId, ContestId, Name, Affiliation, IsWriteIn) values
  (1,  1, 'Mr. President',    'Bipartisan Party', false),
  (2,  1, 'Mr. Incumbent',    'Moderate Party',   false),
  (3,  1, 'INCUMBENT',        NULL,               true),
  (4,  2, 'Mr. Fiscal',       'Bipartisan Party', false),
  (5,  2, 'Ms. Frugal',       'Moderate Party',   false),
  (6,  2, 'Dr. Magnate',      NULL,               true),
  (7,  3, 'Ms. Dent',         NULL,               false),
  (8,  3, 'Ms. Parker',       NULL,               false),
  (9,  4, 'Bipartisan Party', NULL,               false),
  (10, 4, 'Moderate Party',   NULL,               false);

insert into BallotStyle (StyleId, Name) values
  (1, 'District 1 Style'),
  (2, 'District 2 Style');

insert into BallotStyleContestAssociation (StyleId, ContestId) values
  (1, 1),
  (1, 2),
  (1, 3),
  (1, 4),
  (2, 1);

insert into BallotStyleReportingContextAssociation (StyleId,
						    ReportingContext) values
  (1, 'District 1'),
  (1, 'Jurisdiction'),
  (2, 'District 2'),
  (2, 'Jurisdiction');

insert into Endorsement (Party, ChoiceId, Value) values
  ('Bipartisan Party', 1, 1),
  ('Bipartisan Party', 4, 1),
  ('Moderate Party',   2, 1),
  ('Moderate Party',   5, 1);

insert into Ballot (BallotId, StyleId, Accepted) values
  (1, 1, true),
  (2, 1, true),
  (3, 1, true),
  (4, 1, true),
  (5, 1, true),
  (6, 1, true),
  (7, 1, true),
  (8, 1, true),
  (9, 1, true),
  (10, 1, true),
  (11, 1, true),
  (12, 2, true),
  (13, 2, true),
  (14, 2, true);

insert into VoterInput (BallotId, ChoiceId, Value) values
  (2, 1, 1),
  (2, 4, 1),
  (2, 7, 1),
  (3, 2, 1),
  (3, 5, 1),
  (3, 8, 1),
  (4, 3, 1),
  (4, 6, 1),
  (5, 1, 1),
  (5, 2, 1),
  (5, 4, 1),
  (5, 5, 1),
  (5, 7, 1),
  (5, 8, 1),
  (6, 2, 1),
  (6, 3, 1),
  (6, 5, 1),
  (6, 6, 1),
  (7, 1, 1),
  (7, 2, 1),
  (7, 3, 1),
  (7, 4, 1),
  (7, 5, 1),
  (7, 6, 1),
  (7, 7, 1),
  (7, 8, 1),
  (8, 7, 2),
  (9, 8, 2),
  (10, 7, 2),
  (10, 8, 1),
  (11, 7, 1),
  (11, 8, 2),
  (12, 1, 1),
  (13, 2, 1),
  (14, 3, 1);
