\i Infrastructure-TestHeader.sql

\echo '$Id: 0-integrity-OutOfRangeEndorsement.sql 95 2007-03-19 13:59:35Z dflater $'
\echo
\echo 'Verify that straight party endorsement values exceeding 1 (for N-of-M)'
\echo 'or N (for Cumulative) are detected by the integrity check.  The "All'
\echo 'results should be empty" notice does not apply to this test case.'
\echo 'Refer instead to the "Expected results" printed at the bottom.'

\i 0-integrity-common.sql

-- 1-of-M
update Endorsement
  set Value = 2
  where ChoiceId = 1;
-- 2-of-M
update Endorsement
  set Value = 2
  where ChoiceId = 4;
-- Cumulative (2)
insert into Endorsement (Party, ChoiceId, Value) values
  ('Bipartisan Party', 7, 3);

\i Infrastructure-IntegrityChecks.sql

\echo 'Expected results:'
\echo '      Out Of Range Endorsements'
\echo '      party       | choiceid | value '
\echo '------------------+----------+-------'
\echo ' Bipartisan Party |        1 |     2'
\echo ' Bipartisan Party |        4 |     2'
\echo ' Bipartisan Party |        7 |     3'
\echo '(3 rows)'

\i Infrastructure-TestFooter.sql
