model ConnectedTanksdddModel
  ConnectedTanksddd _ConnectedTanksddd;
  model ConnectedTanksddd
    Pipe pipe;
    Tank fluidReservoir1(fluidLevel.start=40.0,fluidLevel.fixed=true);
    Tank fluidReservoir2(fluidLevel.start=15.0,fluidLevel.fixed=true);
  equation
    connect(pipe.toTank1,fluidReservoir1.tankToPipe);
    connect(fluidReservoir2.tankToPipe,pipe.toTank2);
  end ConnectedTanksddd;
  connector VolumeFlowElement
    flow VolumeFlowRate q;
    Pressure p;
  end VolumeFlowElement;
  type Pressure=Real(unit="Pa");
  type VolumeFlowRate=Real(unit="m³/s");
  model Tank
    VolumeFlowElement tankToPipe;
    flow VolumetricFlowRate fluidFlow;
    Pressure tankFluidPressure;
    parameter SurfaceArea surfaceAreaTank(start=4.0,fixed=true);
    parameter Acceleration gravity(start=9.8,fixed=true);
    parameter Density fluidDensity(start=10.0,fixed=true);
    flow Height fluidLevel;
  equation
    tankFluidPressure=tankToPipe.p;
    fluidFlow=tankToPipe.q;
    tankFluidPressure=gravity*fluidLevel*fluidDensity;
    der(fluidLevel)=-fluidFlow/surfaceAreaTank;
  end Tank;
  type Height=Real(unit="m");
  type Density=Real(unit="kg/(m^3)");
  type Acceleration=Real(unit="m/(s^2)");
  type SurfaceArea=Real(unit="m^2");
  type Pressure=Real(unit="kg/((s^2)*m)");
  type VolumetricFlowRate=Real(unit="(m^3)/s");
  model Pipe
    VolumeFlowElement toTank1;
    VolumeFlowElement toTank2;
    flow VolumetricFlowRate fluidFlow;
    Pressure fluidPressure;
    parameter Length pipeLength(start=10.0,fixed=true);
    parameter Length radius(start=0.5,fixed=true);
    parameter Viscosity dynamicViscosity(start=2.0,fixed=true);
    ViscousResistance resistance;
  equation
    resistance=(8*dynamicViscosity*pipeLength)/(3.1416*(radius^4));
    fluidFlow=fluidPressure/resistance;
    fluidPressure=toTank2.p-toTank1.p;
    toTank1.q+toTank2.q=0;
    fluidFlow=toTank1.q;
  end Pipe;
  type ViscousResistance=Real(unit="(kg)/(s*m^4)");
  type Viscosity=Real(unit="kg/(s*m)");
  type Length=Real(unit="m");
end ConnectedTanksdddModel;
