model CircuitModel
  Circuit _Circuit;
  model Circuit
    Source s;
    Capacitor c(C.start=0.01,C.fixed=true);
    Resistor ri(R.start=20.0,R.fixed=true);
    Inductor i(L.start=0.1,L.fixed=true);
    Ground g;
    Resistor rc(R.start=10.0,R.fixed=true);
  equation
    connect(g.p,s.n);
    connect(s.p,rc.p);
    connect(rc.p,ri.p);
    connect(ri.n,i.p);
    connect(i.n,c.n);
    connect(c.p,rc.n);
    connect(c.n,s.n);
  end Circuit;
  connector ChargeFlowElement
    flow Current i;
    Voltage v;
  end ChargeFlowElement;
  type Voltage=Real(unit="V");
  type Current=Real(unit="A");
  model Resistor
    extends TwoPinElectricalComponent;
    parameter Resistance R;
  equation
    R*iThru=vDrop;
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end Resistor;
  type Resistance=Real(unit="Ohm");
  model TwoPinElectricalComponent
    flow Current iThru;
    Voltage vDrop;
    ChargeFlowElement p;
    ChargeFlowElement n;
  end TwoPinElectricalComponent;
  model Ground
    ChargeFlowElement p;
  equation
    p.v=0;
  end Ground;
  model Inductor
    extends TwoPinElectricalComponent;
    parameter Inductance L;
  equation
    L*der(iThru)=vDrop;
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end Inductor;
  type Inductance=Real(unit="H");
  model Capacitor
    extends TwoPinElectricalComponent;
    parameter Capacitance C;
  equation
    C*der(vDrop)=iThru;
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end Capacitor;
  type Capacitance=Real(unit="F");
  model Source
    extends TwoPinElectricalComponent;
    parameter Voltage amp(start=220.0,fixed=true);
  equation
    vDrop=amp*sin(2*3.14*time);
    0=p.i+n.i;
    vDrop=p.v-n.v;
    iThru=p.i;
  end Source;
end CircuitModel;
