model CruiseControlTotalSystemScenario1Model
  CruiseControlTotalSystemScenario1 _CruiseControlTotalSystemScenario1;
  model CruiseControlTotalSystemScenario1
    extends CruiseControlTotalSystem(redeclare Car1 controlledVehicle);
  end CruiseControlTotalSystemScenario1;
  model Car
    replaceable Person driver;
    replaceable CruiseController speedController(kI.start=30.0,kI.fixed=true,kP.start=200.0,kP.fixed=true,throttleAccRatio.start=1.0,throttleAccRatio.fixed=true);
    Engine powerSource;
    replaceable Wheel impeller;
    replaceable parameter Mass mass;
    replaceable parameter Area crossSectionalArea;
    replaceable parameter Real dragCoefficient;
    PhSLMomFlowElement carLMomF;
    PhSAMomFlowElement aMomFlowComponentAMomF;
  equation
    connect(driver.personSpeed,speedController.speedDriverJack);
    connect(impeller.wheelSpeed,speedController.speedSensorJack);
    connect(speedController.throttleActuatorJack,powerSource.engineThrottleSetting);
    connect(powerSource.crankshaft,impeller.hub);
    connect(impeller.aMomFlowComponentAMomF,aMomFlowComponentAMomF);
    carLMomF.f=mass*der(carLMomF.lV);
  end Car;
  connector PhSAMomFlowElement
    flow Torque trq;
    AngularVelocity aV;
  end PhSAMomFlowElement;
  type AngularVelocity=Real(unit="rad/s");
  type Torque=Real(unit="NÂ·m");
  type LinearVelocity=Real(unit="m/s");
  connector PhSLMomFlowElement
    flow Force f;
    Velocity lV;
  end PhSLMomFlowElement;
  type Velocity=Real(unit="m/s");
  type Force=Real(unit="N");
  type Area=Real(unit="m^2");
  type Mass=Real(unit="kg");
  model Wheel
    extends AMomFlowComponent;
    PhSAMomFlowElement hub;
    output LinearVelocity wheelSpeed;
  equation
    hub.aV=-aMomFlowComponentAMomF.aV;
    wheelSpeed=-hub.aV*radius;
    hub.trq+aMomFlowComponentAMomF.trq=0;
  end Wheel;
  model AMomFlowComponent
    PhSAMomFlowElement aMomFlowComponentAMomF;
    replaceable Length radius;
  end AMomFlowComponent;
  type Length=Real(unit="m");
  model Engine
    PhSAMomFlowElement crankshaft;
    parameter Torque trqCoef(start=1.0,fixed=true);
    input Real engineThrottleSetting;
  equation
    crankshaft.trq=engineThrottleSetting*trqCoef;
  end Engine;
  model CruiseController
    output Real throttleActuatorJack;
    input LinearVelocity speedDriverJack;
    input LinearVelocity speedSensorJack;
    replaceable parameter ICoefficient kI(start=1.0,fixed=true);
    replaceable parameter PCoefficient kP(start=1.0,fixed=true);
    Acceleration accCmd;
    Length errorInteg;
    replaceable parameter ThrottleAccelerationRatio throttleAccRatio(start=1.0,fixed=true);
  equation
    der(errorInteg)=speedDriverJack-speedSensorJack;
    accCmd=kP*(speedDriverJack-speedSensorJack)+kI*errorInteg;
    throttleActuatorJack=accCmd*throttleAccRatio;
  end CruiseController;
  type ThrottleAccelerationRatio=Real(unit="s^2/m");
  type Acceleration=Real(unit="m/s^2");
  type PCoefficient=Real(unit="1/s");
  type ICoefficient=Real(unit="1/s^2");
  model Person
    output LinearVelocity personSpeed;
  end Person;
  model Car1
    extends Car(redeclare Person1 driver,redeclare CruiseController1 speedController,redeclare Wheel1 impeller,redeclare Mass mass(start=2000.0,fixed=true),redeclare Area crossSectionalArea(start=2.0,fixed=true),redeclare Real dragCoefficient(start=1.0,fixed=true));
  end Car1;
  model Wheel1
    extends Wheel(redeclare parameter Length radius(start=0.5,fixed=true));
  end Wheel1;
  model CruiseController1
    extends CruiseController(redeclare ICoefficient kI(start=30.0,fixed=true),redeclare PCoefficient kP(start=200.0,fixed=true),redeclare ThrottleAccelerationRatio throttleAccRatio(start=1.0,fixed=true));
  end CruiseController1;
  model Person1
    extends Person;
    parameter Time changetime(start=100.0,fixed=true);
    parameter LinearVelocity speed1(start=10.0,fixed=true);
    parameter LinearVelocity speed2(start=15.0,fixed=true);
  equation
    if time<changetime then
personSpeed=speed1;
else
personSpeed=speed2;
end if;
  end Person1;
  type Time=Real(unit="s");
  model CruiseControlTotalSystem
    replaceable Car controlledVehicle;
    Earth operatingEnvironment;
    LMomPotEngTransformation gravVehicleLink;
    FluidEffect airVehicleLink;
    ALMomTransComponent aLMTC;
  equation
    connect(operatingEnvironment.lMomentumGroundLMomF,aLMTC.lMCG);
    connect(gravVehicleLink.lMomPotEngTransformationLMomF,controlledVehicle.carLMomF);
    connect(operatingEnvironment.airLMomF,airVehicleLink.air);
    connect(airVehicleLink.car,controlledVehicle.carLMomF);
    connect(controlledVehicle.aMomFlowComponentAMomF,aLMTC.aMomFlowComponentAMomF);
    connect(controlledVehicle.carLMomF,aLMTC.aLMomTransComponentLMomF);
    gravVehicleLink.slope=operatingEnvironment.surface.slope;
    gravVehicleLink.mass=controlledVehicle.mass;
    gravVehicleLink.acceleration=operatingEnvironment.acceleration;
    airVehicleLink.crossSectionalArea=controlledVehicle.crossSectionalArea;
    controlledVehicle.dragCoefficient=airVehicleLink.dragCoefficient;
    operatingEnvironment.atmosphere.density=airVehicleLink.density;
    aLMTC.radius=controlledVehicle.impeller.radius;
  end CruiseControlTotalSystem;
  model ALMomTransComponent
    extends AMomFlowComponent;
    PhSLMomFlowElement lMCG;
    PhSLMomFlowElement aLMomTransComponentLMomF;
  equation
    aMomFlowComponentAMomF.aV=(aLMomTransComponentLMomF.lV-lMCG.lV)/radius;
    aMomFlowComponentAMomF.trq=aLMomTransComponentLMomF.f*radius;
    lMCG.f=0;
  end ALMomTransComponent;
  model FluidEffect
    PhSLMomFlowElement car;
    PhSLMomFlowElement air;
    Area crossSectionalArea;
    Real dragCoefficient;
    Density density;
    LinearVelocity vel;
  equation
    air.f+car.f=0;
    air.f=0.5*density*vel^2*dragCoefficient*crossSectionalArea;
    car.lV-air.lV=vel;
  end FluidEffect;
  type Density=Real(unit="kg/m^3");
  model LMomPotEngTransformation
    PhSLMomFlowElement lMomPotEngTransformationLMomF;
    Mass mass;
    Angle slope;
    Acceleration acceleration;
  equation
    lMomPotEngTransformationLMomF.f=mass*acceleration*sin(slope);
  end LMomPotEngTransformation;
  type Angle=Real;
  model Earth
    Air atmosphere(density.start=1.2,density.fixed=true);
    Road surface(start.start=50.0,start.fixed=true,stop.start=70.0,stop.fixed=true,rise.start=0.1,rise.fixed=true,flat.start=0.0,flat.fixed=true);
    parameter Acceleration acceleration(start=9.8,fixed=true);
    PhSLMomFlowElement lMomentumGroundLMomF;
    PhSLMomFlowElement airLMomF;
  equation
    connect(surface.lMomentumGroundLMomF,lMomentumGroundLMomF);
    connect(atmosphere.airLMomF,airLMomF);
  end Earth;
  model Road
    extends LMomentumGround;
    Angle slope;
    parameter Angle flat;
    parameter Time start;
    parameter Time stop;
    parameter Angle rise;
  equation
    if time>start and time<stop then
slope=rise;
else
slope=flat;
end if;
  end Road;
  model LMomentumGround
    PhSLMomFlowElement lMomentumGroundLMomF;
  equation
    lMomentumGroundLMomF.lV=0;
  end LMomentumGround;
  model Air
    PhSLMomFlowElement airLMomF;
    parameter Density density;
  equation
    airLMomF.lV=0;
  end Air;
end CruiseControlTotalSystemScenario1Model;
