package com.engisis.sysphs.util;

import java.io.IOException;
import java.io.Writer;

/**
 * Generic text writer
 * 
 * @author barbau
 *
 */
public class TextWriter extends Visitor
{
    
    /**
     * indentation level
     */
    private int t = 0;
    /**
     * indentation string
     */
    private final static String TAB = "  ";
    /**
     * writer
     */
    private Writer w;
    
    /**
     * Creates a text writer for the specified writer
     * 
     * @param w
     *            object to write into
     */
    protected TextWriter(Writer w)
    {
        this.w = w;
    }
    
    /**
     * Increases the indentation
     */
    protected final void indent()
    {
        t++;
    }
    
    /**
     * Decreases the indentation
     */
    protected final void unindent()
    {
        t--;
    }
    
    public static final int T = 1;
    public static final int L = 2;
    public static final int TL = 3;
    
    /**
     * Writes the text
     * 
     * @param text
     *            text to write
     * @throws IOException
     */
    protected void append(String text) throws IOException
    {
        w.append(text);
    }
    
    /**
     * Writes the text, with indentation or new line
     * 
     * @param text
     *            text to write
     * @param param
     *            whether indentation or new line is used
     * @throws IOException
     */
    protected void append(String text, int param) throws IOException
    {
        if ((param & T) != 0)
            for (int i = 0; i < t; i++)
                w.append(TAB);
        w.append(text);
        if ((param & L) != 0)
            w.append('\n');
    }
}
