package com.engisis.sysphs.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * Generic translator from simulation platforms to SysML.
 * 
 * @author barbau
 *
 */
public abstract class SimulationToSysMLTranslator
{
    
    private String filenamesuffix;
    private String modelnamesuffix;
    
    protected String outputfilename;
    protected String outputrootname;
    
    public void setFileNameSuffix(String suffix)
    {
        this.filenamesuffix = suffix;
    }
    
    public String getFileNameSuffix()
    {
        return filenamesuffix == null ? "" : filenamesuffix;
    }
    
    public void setModelNameSuffix(String suffix)
    {
        this.modelnamesuffix = suffix;
    }
    
    public String getModelNameSuffix()
    {
        return modelnamesuffix == null ? "" : modelnamesuffix;
    }
    
    public String getOutputFileName()
    {
        return outputfilename;
    }
    
    public void setOutputFileName(String outputfilename)
    {
        this.outputfilename = outputfilename;
    }
    
    public String getOutputRootName()
    {
        return outputrootname;
    }
    
    public void setOutputRootName(String outputrootname)
    {
        this.outputrootname = outputrootname;
    }
    
    public abstract void execute(String model, ResourceSet rs, File outputdirectory, String target, String[] paths) throws IOException,
            UMLModelErrorException;
    
    public void loadOptions(Set<Object> options)
    {
        Set<Object> values = getOptionValues();
        if (options != null)
            for (Object str : options)
                if (!values.contains(str))
                    throw new IllegalArgumentException("The option is not valid: " + str);
    }
    
    public abstract Set<java.lang.Class<?>> getOptions();
    
    public final Set<Object> getOptionValues()
    {
        HashSet<Object> res = new HashSet<Object>();
        Set<java.lang.Class<?>> options = getOptions();
        if (options != null)
            for (java.lang.Class<?> en : options)
                if (en.isEnum())
                    for (Object o : en.getEnumConstants())
                        res.add(o);
        return res;
    }
}
