package com.engisis.sysphs.util;

import java.util.BitSet;

import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Interval;
import org.apache.log4j.Logger;

/**
 * Class to log ANTLR parsing errors/warnings
 * 
 * @author barbau
 *
 */
public class ANTLRErrorListener extends DiagnosticErrorListener
{
    /**
     * logger
     */
    private Logger log;
    
    /**
     * Constructs a listener with a log
     * 
     * @param log
     */
    public ANTLRErrorListener(Logger log)
    {
        this.log = log;
    }
    
    @Override
    public void syntaxError(Recognizer<?, ?> rec, Object symbol, int line, int column, String msg,
            RecognitionException re)
    {
        log.error("Syntax error at " + line + ":" + column + ", " + msg + " at " + symbol);
    }
    
    @Override
    public void reportContextSensitivity(Parser reco, DFA dfa, int start, int stop, int exact, ATNConfigSet arg5)
    {
        log.warn("Context sensitivity found: decision " + getDecisionDescription(reco, dfa) + ", interval: "
                + reco.getInputStream().getText(Interval.of(start, stop)));
        
    }
    
    @Override
    public void reportAttemptingFullContext(Parser rec, DFA dfa, int start, int stop, BitSet conflict,
            ATNConfigSet configs)
    {
        log.warn("Attempting full context: decision " + getDecisionDescription(rec, dfa) + ", interval: "
                + rec.getInputStream().getText(Interval.of(start, stop)));
    }
    
    @Override
    public void reportAmbiguity(Parser rec, DFA dfa, int start, int stop, boolean exact, BitSet amb, ATNConfigSet conf)
    {
        log.error("Ambiguity found: decision " + getDecisionDescription(rec, dfa) + ", alternatives: "
                + getConflictingAlts(amb, conf) + ", interval: "
                + rec.getInputStream().getText(Interval.of(start, stop)));
    }
    
}
