package com.engisis.sysphs.translation.simulink;

import java.util.Hashtable;

import com.engisis.sysphs.generation.simulink.SimscapeBaseListener;
import com.engisis.sysphs.generation.simulink.SimscapeParser;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Add_opContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Argument_listContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.ArrayContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.EquationContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr10Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr11Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr2Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr3Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr4Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr5Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr6Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr7Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr8Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Expr9Context;
import com.engisis.sysphs.generation.simulink.SimscapeParser.ExprContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Id_argContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.If_clauseContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Let_clauseContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Mul_opContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.ObjectContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Pow_opContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.ReferenceContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.Relational_opContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.RowContext;
import com.engisis.sysphs.generation.simulink.SimscapeParser.UnaryContext;

import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.log4j.Logger;

/**
 * Class to extract from Simscape expressions
 * 
 * @author barbau
 *
 */
public class SimscapeExpressionExtractor extends SimscapeBaseListener
{
    private static final Logger log = Logger.getLogger(SimscapeExpressionExtractor.class);
    /**
     * Associates translated text to syntax tree nodes
     */
    private ParseTreeProperty<String> ptp = new ParseTreeProperty<String>();
    
    /**
     * substitution tables
     */
    private Hashtable<String, String> substitutions;
    
    public void prepareNextEquationParsing(Hashtable<String, String> substitutions)
    {
        this.substitutions = substitutions;
    }
    
    public String getValue(ParseTree pt)
    {
        String v = ptp.get(pt);
        // if (v == null)
        // log.error("The value of " + pt.getClass() + " is null");
        return v;
    }
    
    public void setValue(ParseTree pt, String str)
    {
        ptp.put(pt, str);
    }
    
    @Override
    public void exitEquation(EquationContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitLet_clause(Let_clauseContext ctx)
    {
        setValue(ctx, "");
        log.error("Let clause can't be translated");
    }
    
    @Override
    public void exitIf_clause(If_clauseContext ctx)
    {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); i++)
        {
            ParseTree pt = ctx.getChild(i);
            if (pt instanceof TerminalNode)
            {
                sb.append(pt.getText());
                if (((TerminalNode) pt).getSymbol().getType() == SimscapeParser.END)
                    sb.append(" if");
            }
            else
            {
                String v = getValue(pt);
                if (v != null)
                {
                    if (i != 0)
                        sb.append(" ");
                    sb.append(v);
                    if (pt instanceof ExprContext)
                        sb.append(" then");
                    else if (pt instanceof EquationContext)
                        sb.append(";");
                    
                }
            }
        }
        setValue(ctx, sb.toString());
    }
    
    @Override
    public void exitExpr(ExprContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr2(Expr2Context ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr3(Expr3Context ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr4(Expr4Context ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr5(Expr5Context ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitRelational_op(Relational_opContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr6(Expr6Context ctx)
    {
        if (ctx.expr7().size() > 1)
        {
            log.error("Colon operator not supported");
            setValue(ctx, "");
        }
        else
            setValue(ctx, getValue(ctx.expr7(0)));
    }
    
    @Override
    public void exitExpr7(Expr7Context ctx)
    {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.expr8().size(); i++)
        {
            String s = getValue(ctx.expr8(i));
            //if (!s.equals("0"))
            {
                if (sb.length() != 0 && i > 0)
                    sb.append(getValue(ctx.add_op(i - 1)));
                sb.append(s);
            }
        }
        if (sb.length() == 0)
            sb.append("0");
        setValue(ctx, sb.toString());
    }
    
    @Override
    public void exitAdd_op(Add_opContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr8(Expr8Context ctx)
    {
        StringBuilder sb = new StringBuilder();
        String s = getValue(ctx.expr9(0));
        if (!("1".equals(s) && ctx.mul_op().size()>0 && getValue(ctx.mul_op(0)).equals("*")))
            sb.append(s);
        for (int i = 1; i < ctx.expr9().size(); i++)
        {
            s = getValue(ctx.expr9(i));
            if (!"1".equals(s))
            {
                if (sb.length() != 0)
                    sb.append(getValue(ctx.mul_op(i - 1)));
                sb.append(s);
            }
        }
        if (sb.length() == 0)
            sb.append("1");
        setValue(ctx, sb.toString());
    }
    
    @Override
    public void exitMul_op(Mul_opContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr9(Expr9Context ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitUnary(UnaryContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr10(Expr10Context ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitPow_op(Pow_opContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitExpr11(Expr11Context ctx)
    {
        if (ctx.AT() != null)
        {
            log.error("Operator @ not supported");
        }
        else
            processStraight(ctx);
    }
    
    @Override
    public void exitArray(ArrayContext ctx)
    {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (RowContext rc : ctx.row())
            sb.append(getValue(rc));
        sb.append('}');
        setValue(ctx, sb.toString());
    }
    
    @Override
    public void exitRow(RowContext ctx)
    {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < ctx.expr().size(); i++)
        {
            if (i != 0)
                sb.append(',');
            sb.append(getValue(ctx.expr(i)));
        }
        sb.append('}');
        setValue(ctx, sb.toString());
    }
    
    @Override
    public void exitReference(ReferenceContext ctx)
    {
        processStraight(ctx);
        if (substitutions != null)
        {
            String v = substitutions.get(getValue(ctx));
            if (v != null)
                setValue(ctx, v);
        }
    }
    
    @Override
    public void exitId_arg(Id_argContext ctx)
    {
        processStraight(ctx);
    }
    
    @Override
    public void exitArgument_list(Argument_listContext ctx)
    {
        
        processStraight(ctx);
    }
    
    @Override
    public void exitObject(ObjectContext ctx)
    {
        // to translate {1, 'unit'}
        if (ctx.val().size() == 2)
        {
            String v0 = getValue(ctx.val(0).expr());
            String v1 = getValue(ctx.val(1).expr());
            if ("1".equals(v0) && v1.startsWith("'") && v1.endsWith("'"))
            {
                setValue(ctx, "1");
                return;
            }
        }
        
        log.error("Objects can't be translated");
    }
    
    @Override
    public void visitTerminal(TerminalNode node)
    {
        int t = node.getSymbol().getType();
        if (t == SimscapeParser.DOUBLE_EQ)
            setValue(node, "=");
        else if (t == SimscapeParser.NEG)
            setValue(node, " not ");
        else if (t == SimscapeParser.LOG_AND)
            setValue(node, " and ");
        else if (t == SimscapeParser.LOG_OR)
            setValue(node, " or ");
        else if (t == SimscapeParser.CCT)
        {
            log.error("Operator ' not supported");
        }
        else if (t == SimscapeParser.EL_CCT)
        {
            log.error("Operator .' not supported");
        }
        else if (t == SimscapeParser.EL_EXP)
        {
            log.error("Operator .^ not supported");
        }
        else if (t == SimscapeParser.EL_LEFTDIV)
        {
            log.error("Operator ./ not supported");
        }
        else if (t == SimscapeParser.EL_RIGHTDIV)
        {
            log.error("Operator .\\ not supported");
        }
        else if (t == SimscapeParser.EL_TIMES)
        {
            log.error("Operator .* not supported");
        }
        else
            setValue(node, node.getText());
    }
    
    protected void processStraight(ParseTree ctx)
    {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); i++)
        {
            String v = getValue(ctx.getChild(i));
            if (v != null)
                sb.append(v);
        }
        setValue(ctx, sb.toString());
    }
    
    protected void processWithSpaces(ParseTree ctx)
    {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ctx.getChildCount(); i++)
        {
            if (i != 0)
                sb.append(" ");
            String v = getValue(ctx.getChild(i));
            if (v != null)
                sb.append(v);
        }
        setValue(ctx, sb.toString());
    }
}
